/*
 * Decompiled with CFR 0.152.
 */
package de.uniba.minf.auth.spring.mvc;

import de.uniba.minf.auth.profile.AuthProfile;
import de.uniba.minf.auth.spring.mvc.model.AuthPojo;
import java.util.List;
import org.pac4j.core.profile.ProfileManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class AuthInfoHelper {
    private static final Logger log = LoggerFactory.getLogger(AuthInfoHelper.class);
    @Autowired
    private ProfileManager profileManager;

    public AuthPojo getAuth() {
        return this.getCurrentUserDetails();
    }

    public String getUserId() {
        AuthPojo user = this.getCurrentUserDetails();
        if (user != null) {
            return user.getUserId();
        }
        return null;
    }

    public AuthPojo getCurrentUserDetails() {
        List profiles = this.profileManager.getProfiles();
        if (profiles == null || profiles.isEmpty()) {
            return new AuthPojo();
        }
        if (profiles.size() > 1) {
            log.warn("Multiple user profiles available for the session => using first");
        }
        return this.getFromExtendedUserProfile((AuthProfile)profiles.get(0));
    }

    private AuthPojo getFromExtendedUserProfile(AuthProfile profile) {
        AuthPojo pojo = null;
        if (profile != null) {
            pojo = new AuthPojo();
            pojo.setAuth(!profile.isExpired());
            pojo.setDisplayName(profile.getDisplayName());
            pojo.setRoles(profile.getRoles());
            pojo.setLevel(profile.getLevel());
            pojo.setUserId(profile.getId());
        }
        return pojo;
    }
}

