/*
 * Decompiled with CFR 0.152.
 */
package de.uniba.minf.auth.spring.mvc;

import de.uniba.minf.auth.spring.mvc.AuthInfoHelper;
import de.uniba.minf.auth.spring.mvc.model.AuthPojo;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.springframework.util.StringUtils;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.LocaleResolver;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.support.RequestContextUtils;

public class AuthInfoHandlerInterceptor
implements HandlerInterceptor {
    private final AuthInfoHelper authInfoHelper;

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) throws Exception {
        if (modelAndView == null || modelAndView.getViewName() == null || modelAndView.getViewName().toLowerCase().startsWith("redirect:")) {
            return;
        }
        AuthPojo auth = this.authInfoHelper.getAuth();
        if (auth != null && auth.isAuth()) {
            this.setUserLocale(request, response, auth.getLanguage());
        } else {
            auth = new AuthPojo();
            auth.setAuth(false);
        }
        modelAndView.addObject("_auth", (Object)auth);
    }

    private void setUserLocale(HttpServletRequest request, HttpServletResponse response, String localeString) {
        if (localeString != null && !localeString.isEmpty()) {
            LocaleResolver localeResolver = RequestContextUtils.getLocaleResolver((HttpServletRequest)request);
            if (localeResolver == null) {
                throw new IllegalStateException("No LocaleResolver found: not in a DispatcherServlet request?");
            }
            localeResolver.setLocale(request, response, StringUtils.parseLocaleString((String)localeString));
        }
    }

    public AuthInfoHandlerInterceptor(AuthInfoHelper authInfoHelper) {
        this.authInfoHelper = authInfoHelper;
    }
}

