/*
 * Decompiled with CFR 0.152.
 */
package de.uniba.minf.auth.spring.controller;

import de.uniba.minf.auth.helpers.SAMLMetadataHelper;
import de.uniba.minf.auth.spring.error.NotFoundException;
import de.uniba.minf.auth.spring.error.SAML2MetadataNotFoundException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/saml/metadata"})
public class SAMLMetadataController {
    @Autowired
    private SAMLMetadataHelper metadataHelper;

    @GetMapping(value={"", "/", "/{action}"}, produces={"application/xml"})
    @ResponseBody
    public String getMetadata(@PathVariable(required=false, value="action") String action) {
        if (!(action == null || action.isEmpty() || action.equals("generate") || action.equals("filesystem"))) {
            throw new NotFoundException();
        }
        boolean generate = action != null && action.equals("generate");
        boolean filesystem = action != null && action.equals("filesystem");
        String metadata = this.metadataHelper.isFilesystemMetadataAvailable() && !generate || filesystem ? this.metadataHelper.getFromFilesystem() : this.metadataHelper.generateFromConfiguration();
        if (metadata != null) {
            return metadata;
        }
        throw new SAML2MetadataNotFoundException();
    }
}

