/*
 * Decompiled with CFR 0.152.
 */
package de.uniba.minf.auth.spring.controller;

import de.uniba.minf.auth.spring.config.SecurityConfig;
import de.uniba.minf.auth.spring.error.AuthenticatorNotAvailable;
import de.uniba.minf.auth.spring.mvc.AuthInfoHelper;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Map;
import java.util.Optional;
import org.pac4j.core.client.Client;
import org.pac4j.core.config.Config;
import org.pac4j.core.context.CallContext;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.context.session.SessionStore;
import org.pac4j.core.exception.http.HttpAction;
import org.pac4j.http.client.indirect.FormClient;
import org.pac4j.jee.context.JEEContext;
import org.pac4j.jee.context.session.JEESessionStore;
import org.pac4j.jee.http.adapter.JEEHttpActionAdapter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class LoginController {
    @Autowired
    protected AuthInfoHelper authInfoHelper;
    @Autowired
    private SecurityConfig securityConfig;
    @Autowired
    private Config config;
    @Autowired
    private JEEContext webContext;
    private final String loginView;

    public LoginController() {
        this.loginView = "login";
    }

    public LoginController(String loginView) {
        this.loginView = loginView;
    }

    @GetMapping(value={"/login"})
    public String loginForm(Map<String, Object> map, @RequestParam(required=false, value="url") String url, @RequestParam(required=false, value="error") String error, HttpServletRequest request, HttpServletResponse response) {
        FormClient formClient = (FormClient)this.config.getClients().findClient(this.securityConfig.getLocal().getAuthorizerName()).get();
        if (this.securityConfig.isEnabled() && this.securityConfig.getIndirectStartClientName().equals(formClient.getName())) {
            map.put("callbackUrl", formClient.getCallbackUrl());
            map.put("clients", this.securityConfig.getEnabledIndirectClients().values().stream().filter(c -> !FormClient.class.isAssignableFrom(c.getClass())));
            map.put("clientName", this.securityConfig.getLocal().getAuthorizerName());
            map.put("requestUrl", url != null ? url : this.securityConfig.getDefaultLoginUrl());
            map.put("localEnabled", this.securityConfig.getLocal().isEnabled());
            map.put("error", error);
            return this.loginView;
        }
        if (this.securityConfig.isEnabled()) {
            Client client = (Client)this.config.getClients().findClient(this.securityConfig.getIndirectStartClientName()).get();
            JEEHttpActionAdapter.INSTANCE.adapt((HttpAction)client.getRedirectionAction(new CallContext((WebContext)this.webContext, (SessionStore)new JEESessionStore())).get(), (WebContext)this.webContext);
        } else {
            response.setHeader("Location", this.securityConfig.baseUrl().getUrl());
            response.setStatus(302);
        }
        return null;
    }

    @GetMapping(value={"/startLogin"})
    public void startLogin(@RequestParam(name="client") String clientName, HttpServletRequest request, HttpServletResponse response) {
        Optional client = this.config.getClients().findClient(clientName);
        if (client.isEmpty()) {
            throw new AuthenticatorNotAvailable(clientName);
        }
        JEEHttpActionAdapter.INSTANCE.adapt((HttpAction)((Client)client.get()).getRedirectionAction(new CallContext((WebContext)this.webContext, (SessionStore)new JEESessionStore())).get(), (WebContext)this.webContext);
    }

    @RequestMapping(value={"/forceLogin"})
    @ResponseBody
    public void forceLogin() {
        try {
            String name = this.webContext.getRequestParameter("client_name").map(String::valueOf).orElse("");
            Client client = (Client)this.config.getClients().findClient(name).get();
            JEEHttpActionAdapter.INSTANCE.adapt((HttpAction)((Object)client.getRedirectionAction(new CallContext((WebContext)this.webContext, (SessionStore)new JEESessionStore())).get()), (WebContext)this.webContext);
        }
        catch (HttpAction httpAction) {
            // empty catch block
        }
    }
}

