/*
 * Decompiled with CFR 0.152.
 */
package de.uniba.minf.auth.spring.config;

import com.github.scribejava.apis.GitHubApi;
import com.nimbusds.oauth2.sdk.auth.ClientAuthenticationMethod;
import de.uniba.minf.auth.ProfileActionHandler;
import de.uniba.minf.auth.config.BaseSecurity;
import de.uniba.minf.auth.config.BaseSecurityConfig;
import de.uniba.minf.auth.config.OrderedClient;
import de.uniba.minf.auth.config.oauth.OAuthSecurity;
import de.uniba.minf.auth.config.openid.OpenIDSecurity;
import de.uniba.minf.auth.helpers.SAMLMetadataHelper;
import de.uniba.minf.auth.profile.creator.ExtendedOAuthProfileCreator;
import de.uniba.minf.auth.profile.creator.ExtendedOidcProfileCreator;
import de.uniba.minf.auth.profile.creator.JwtProfileCreator;
import de.uniba.minf.auth.profile.creator.LocalProfileCreator;
import de.uniba.minf.auth.profile.creator.SamlProfileCreator;
import de.uniba.minf.auth.saml.CustomSAML2Client;
import de.uniba.minf.auth.spring.authentication.CustomProfileManager;
import de.uniba.minf.auth.spring.authentication.LocalUsernamePasswordAuthenticator;
import de.uniba.minf.auth.spring.mvc.AuthInfoHelper;
import java.io.FileNotFoundException;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.pac4j.core.client.BaseClient;
import org.pac4j.core.client.Client;
import org.pac4j.core.client.Clients;
import org.pac4j.core.client.DirectClient;
import org.pac4j.core.client.IndirectClient;
import org.pac4j.core.config.Config;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.context.session.SessionStore;
import org.pac4j.core.credentials.authenticator.Authenticator;
import org.pac4j.core.profile.creator.ProfileCreator;
import org.pac4j.http.client.direct.DirectBearerAuthClient;
import org.pac4j.http.client.direct.HeaderClient;
import org.pac4j.http.client.direct.ParameterClient;
import org.pac4j.http.client.indirect.FormClient;
import org.pac4j.jwt.profile.JwtGenerator;
import org.pac4j.oauth.client.OAuth20Client;
import org.pac4j.oauth.config.OAuth20Configuration;
import org.pac4j.oauth.profile.definition.OAuthProfileDefinition;
import org.pac4j.oauth.profile.github.GitHubProfileDefinition;
import org.pac4j.oidc.client.OidcClient;
import org.pac4j.oidc.config.OidcConfiguration;
import org.pac4j.saml.client.SAML2Client;
import org.pac4j.saml.config.SAML2Configuration;
import org.pac4j.springframework.web.CallbackController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.security.crypto.password.PasswordEncoder;

@Configuration
@ComponentScan
public class SecurityConfig
extends BaseSecurityConfig {
    private static final Logger log = LoggerFactory.getLogger(SecurityConfig.class);
    private boolean enabled;
    private String indirectStartClientName;
    private String directClientNames;

    @Bean
    public AuthInfoHelper authInfoHelper() {
        return new AuthInfoHelper();
    }

    @Bean
    public CallbackController callbackController() {
        return new CallbackController();
    }

    @Bean
    public JwtGenerator jwtGenerator() {
        return super.getJwtGenerator();
    }

    @Bean
    public SAMLMetadataHelper metadataHelper() {
        return new SAMLMetadataHelper();
    }

    @Bean
    public Config config(Optional<ProfileActionHandler> profileActionHandler, List<List<OrderedClient<IndirectClient>>> indirectClients, List<Optional<DirectClient>> directClients) throws URISyntaxException {
        ArrayList<OrderedClient<? extends Client>> clients = new ArrayList<OrderedClient<? extends Client>>();
        clients.addAll(indirectClients.stream().flatMap(c -> c.stream()).toList());
        clients.addAll(directClients.stream().filter(d -> d.isPresent()).map(d -> new OrderedClient(Integer.MAX_VALUE, (BaseClient)((DirectClient)d.get()))).toList());
        Collections.sort(clients);
        this.addClients(clients);
        Config config = new Config(new Clients(this.baseUrl().getAbsoluteUrl("/callback"), clients.stream().map(OrderedClient::getClient).collect(Collectors.toList())));
        config.setProfileManagerFactory((ctx, sst) -> new CustomProfileManager((WebContext)ctx, (SessionStore)sst, profileActionHandler.orElse(null)));
        this.directClientNames = String.join((CharSequence)",", this.getEnabledDirectClients().keySet());
        if (!this.getLocal().isEnabled() && this.getEnabledIndirectClients().size() == 1) {
            log.warn("No indirect clients configured: security is DISABLED");
            this.enabled = false;
        } else {
            this.indirectStartClientName = this.getLocal().isEnabled() || this.getEnabledIndirectClients().size() > 2 ? this.getLocal().getAuthorizerName() : this.getEnabledIndirectClients().values().stream().filter(c -> !FormClient.class.isAssignableFrom(c.getClass())).map(c -> c.getName()).findFirst().get();
            this.enabled = true;
            log.debug("Initialized security: \ndirectClients: {}\nindirectStartClient: {}", directClients, (Object)this.indirectStartClientName);
        }
        return config;
    }

    @Bean
    public Optional<DirectClient> directBearerAuthClient() {
        if (!this.rest.isEnabled()) {
            return Optional.empty();
        }
        DirectBearerAuthClient directBearerAuthClient = new DirectBearerAuthClient((Authenticator)super.getJwtAuthenticator());
        directBearerAuthClient.setName("directBearerAuthClient");
        directBearerAuthClient.setProfileCreator((ProfileCreator)new JwtProfileCreator());
        return Optional.of(directBearerAuthClient);
    }

    @Bean
    public Optional<DirectClient> headerClient() {
        if (!this.rest.isEnabled()) {
            return Optional.empty();
        }
        HeaderClient headerClient = new HeaderClient("token", (Authenticator)super.getJwtAuthenticator());
        headerClient.setName("headerClient");
        headerClient.setProfileCreator((ProfileCreator)new JwtProfileCreator());
        return Optional.of(headerClient);
    }

    @Bean
    public Optional<DirectClient> parameterClient() {
        if (!this.rest.isEnabled()) {
            return Optional.empty();
        }
        ParameterClient parameterClient = new ParameterClient("token", (Authenticator)super.getJwtAuthenticator());
        parameterClient.setName("parameterClient");
        parameterClient.setProfileCreator((ProfileCreator)new JwtProfileCreator());
        parameterClient.setSupportGetRequest(true);
        parameterClient.setSupportPostRequest(false);
        return Optional.of(parameterClient);
    }

    @Bean
    public List<OrderedClient<IndirectClient>> getFormClients() throws URISyntaxException {
        ArrayList<OrderedClient<IndirectClient>> localClients = new ArrayList<OrderedClient<IndirectClient>>();
        LocalUsernamePasswordAuthenticator localAuthenticator = new LocalUsernamePasswordAuthenticator();
        localAuthenticator.setEncoder((PasswordEncoder)new BCryptPasswordEncoder());
        if (this.local.isEnabled()) {
            localAuthenticator.setLocalUserConfigurations(this.local.getUsers());
        }
        FormClient c = new FormClient(this.baseUrl().getAbsoluteUrl("/login"), (Authenticator)localAuthenticator);
        this.setBaseClientConfig((BaseClient)c, (BaseSecurity)this.local);
        c.setProfileCreator((ProfileCreator)new LocalProfileCreator(c, (BaseSecurityConfig)this));
        localClients.add(new OrderedClient(this.local.getOrder(), (BaseClient)c));
        return localClients;
    }

    @Bean
    public List<OrderedClient<IndirectClient>> getOpenIDClients() {
        ArrayList<OrderedClient<IndirectClient>> openidClients = new ArrayList<OrderedClient<IndirectClient>>();
        if (this.openid == null || this.openid.length == 0) {
            return openidClients;
        }
        for (OpenIDSecurity openidsec : this.openid) {
            if (!openidsec.isEnabled()) continue;
            OidcConfiguration config = new OidcConfiguration();
            config.setClientId(openidsec.getClientId());
            config.setSecret(openidsec.getSecret());
            config.setDiscoveryURI(openidsec.getDiscoveryURI());
            config.setResponseType(openidsec.getResponseType());
            config.setResponseMode(openidsec.getResponseMode());
            config.setScope(openidsec.getScope());
            config.setUseNonce(openidsec.isUseNonce());
            config.setClientAuthenticationMethod(new ClientAuthenticationMethod(openidsec.getClientAuthenticationMethod()));
            config.setMaxClockSkew(openidsec.getMaxClockSkew());
            config.setExpireSessionWithToken(openidsec.isExpireSessionWithToken());
            config.setTokenExpirationAdvance(openidsec.getTokenExpirationAdvance());
            config.setAllowUnsignedIdTokens(openidsec.isAllowUnsignedIdTokens());
            OidcClient c = new OidcClient(config);
            this.setBaseClientConfig((BaseClient)c, (BaseSecurity)openidsec);
            ExtendedOidcProfileCreator profileCreator = new ExtendedOidcProfileCreator(config, c);
            c.setProfileCreator((ProfileCreator)profileCreator);
            openidClients.add((OrderedClient<IndirectClient>)new OrderedClient(openidsec.getOrder(), (BaseClient)c));
        }
        return openidClients;
    }

    @Bean
    public List<OrderedClient<IndirectClient>> getOauthClients() {
        ArrayList<OrderedClient<IndirectClient>> oauthClients = new ArrayList<OrderedClient<IndirectClient>>();
        if (this.oauth == null || this.oauth.length == 0) {
            return oauthClients;
        }
        for (OAuthSecurity oauthsec : this.oauth) {
            if (!oauthsec.isEnabled()) continue;
            OAuth20Configuration config = new OAuth20Configuration();
            if (oauthsec.getApi() == null || oauthsec.getApi().isBlank()) {
                log.warn("No OAuth API specified, security client not configured", (Object)oauthsec.getApi());
            } else if (oauthsec.getApi().equals("github")) {
                config.setApi((Object)GitHubApi.instance());
                config.setProfileDefinition((OAuthProfileDefinition)new GitHubProfileDefinition());
            } else {
                log.warn("Unknown OAuth API: {}, security client not configured", (Object)oauthsec.getApi());
            }
            config.setScope(oauthsec.getScope());
            config.setKey(oauthsec.getClientId());
            config.setSecret(oauthsec.getSecret());
            OAuth20Client c = new OAuth20Client();
            this.setBaseClientConfig((BaseClient)c, (BaseSecurity)oauthsec);
            c.setConfiguration(config);
            c.setProfileCreator((ProfileCreator)new ExtendedOAuthProfileCreator(config, c));
            oauthClients.add((OrderedClient<IndirectClient>)new OrderedClient(oauthsec.getOrder(), (BaseClient)c));
        }
        return oauthClients;
    }

    @Bean
    public List<OrderedClient<IndirectClient>> getSamlClient() throws URISyntaxException {
        ArrayList<OrderedClient<IndirectClient>> samlClients = new ArrayList<OrderedClient<IndirectClient>>();
        if (!this.saml.isEnabled()) {
            return samlClients;
        }
        SAML2Configuration cfg = new SAML2Configuration();
        cfg.setKeyStoreAlias(this.saml.getKeystore().getAlias());
        cfg.setKeystorePath(this.saml.getKeystore().getPath());
        cfg.setPrivateKeyPassword(this.saml.getKeystore().getAliaspass());
        cfg.setKeystorePassword(this.saml.getKeystore().getPass());
        cfg.setIdentityProviderMetadataPath(this.saml.getMetadata().getUrl());
        if (this.saml.getSp().getMetadataResource() != null) {
            if (!Files.exists(Paths.get(this.saml.getSp().getMetadataResource(), new String[0]), new LinkOption[0])) {
                log.warn("Configured SP metadata resource does not exist", (Throwable)new FileNotFoundException(this.saml.getSp().getMetadataResource()));
            } else {
                cfg.setServiceProviderMetadataPath(this.saml.getSp().getMetadataResource());
            }
        } else {
            log.info("SP metadata resource is not configured (auth.saml.sp.metadataResource); metadata will be generated and served in-memory");
        }
        cfg.setMaximumAuthenticationLifetime((long)this.saml.getSp().getMaxAuthAge());
        cfg.setSignatureAlgorithms(this.saml.getSp().getSigningMethods());
        cfg.setSignatureReferenceDigestMethods(this.saml.getSp().getDigestMethods());
        if (this.saml.getSp().getEntityId() != null) {
            cfg.setServiceProviderEntityId(this.saml.getSp().getEntityId());
        } else {
            cfg.setServiceProviderEntityId(this.baseUrl().getUrl());
        }
        cfg.setSpLogoutRequestSigned(this.saml.getSp().isLogoutRequestSigned());
        cfg.setWantsAssertionsSigned(this.saml.getSp().isWantsAssertionsSigned());
        cfg.setWantsResponsesSigned(this.saml.getSp().isWantsResponsesSigned());
        cfg.setAuthnRequestSigned(this.saml.getSp().isAuthnRequestSigned());
        cfg.setSignMetadata(this.saml.getSp().isSignMetadata());
        cfg.setSupportedProtocols(this.saml.getSp().getSupportedProtocols());
        cfg.setHttpClient(this.saml.getSp().getHttpClient());
        cfg.setMappedAttributes(this.saml.getSp().getMappedAttributesNameMap());
        CustomSAML2Client c = new CustomSAML2Client(cfg, this.saml);
        this.setBaseClientConfig((BaseClient)c, (BaseSecurity)this.saml);
        c.setProfileCreator((ProfileCreator)new SamlProfileCreator(cfg, (SAML2Client)c, (BaseSecurityConfig)this));
        samlClients.add((OrderedClient<IndirectClient>)new OrderedClient(this.saml.getOrder(), (BaseClient)c));
        return samlClients;
    }

    private void setBaseClientConfig(BaseClient client, BaseSecurity config) {
        client.setCustomProperties(new HashMap());
        if (config.getText() != null) {
            client.getCustomProperties().put("text", config.getText());
        }
        if (config.getText() != null) {
            client.getCustomProperties().put("image", config.getImage());
        }
        client.setName(config.getAuthorizerName());
    }

    private void addClients(List<OrderedClient<? extends Client>> clients) {
        if (clients == null) {
            return;
        }
        for (OrderedClient<? extends Client> c : clients) {
            if (IndirectClient.class.isAssignableFrom(c.getClient().getClass())) {
                this.enabledIndirectClients.put(c.getClient().getName(), c.getClient());
                continue;
            }
            this.enabledDirectClients.put(c.getClient().getName(), c.getClient());
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public String getIndirectStartClientName() {
        return this.indirectStartClientName;
    }

    public String getDirectClientNames() {
        return this.directClientNames;
    }
}

