/*
 * Decompiled with CFR 0.152.
 */
package de.uniba.minf.auth.spring.authentication;

import de.uniba.minf.auth.config.local.LocalUser;
import java.util.HashSet;
import java.util.Optional;
import org.pac4j.core.context.CallContext;
import org.pac4j.core.credentials.Credentials;
import org.pac4j.core.credentials.UsernamePasswordCredentials;
import org.pac4j.core.credentials.authenticator.Authenticator;
import org.pac4j.core.exception.CredentialsException;
import org.pac4j.core.profile.CommonProfile;
import org.pac4j.core.profile.UserProfile;
import org.pac4j.core.util.CommonHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.crypto.password.PasswordEncoder;

public class LocalUsernamePasswordAuthenticator
implements Authenticator {
    private static final Logger log = LoggerFactory.getLogger(LocalUsernamePasswordAuthenticator.class);
    private LocalUser[] localUserConfigurations;
    private PasswordEncoder encoder;

    public Optional<Credentials> validate(CallContext context, Credentials credentials) {
        try {
            if (credentials == null || !UsernamePasswordCredentials.class.isAssignableFrom(credentials.getClass())) {
                throw new CredentialsException("No or invalid type of credential");
            }
            UsernamePasswordCredentials usernamePasswordCredentials = (UsernamePasswordCredentials)UsernamePasswordCredentials.class.cast(credentials);
            if (CommonHelper.isBlank((String)usernamePasswordCredentials.getUsername())) {
                throw new CredentialsException("Username cannot be blank");
            }
            if (CommonHelper.isBlank((String)usernamePasswordCredentials.getPassword())) {
                throw new CredentialsException("Password cannot be blank");
            }
            CommonProfile profile = this.getProfile(usernamePasswordCredentials.getUsername(), usernamePasswordCredentials.getPassword());
            if (profile != null) {
                credentials.setUserProfile((UserProfile)profile);
                return Optional.of(credentials);
            }
            throw new CredentialsException("Invalid username/password combination");
        }
        catch (CredentialsException e) {
            log.info("Local authentication failed: {}", (Object)e.getMessage());
            throw e;
        }
    }

    private CommonProfile getProfile(String username, String password) {
        for (LocalUser cnf : this.localUserConfigurations) {
            if (!cnf.getUsername().equals(username)) continue;
            if (this.encoder.matches((CharSequence)password, cnf.getPasshash())) {
                CommonProfile profile = new CommonProfile();
                profile.setId(username);
                profile.addAttribute("username", (Object)username);
                if (cnf.getRoles() == null) {
                    profile.setRoles(new HashSet(0));
                } else {
                    profile.setRoles(cnf.getRoles());
                }
                log.info("Local authentication succeeded [{}]", (Object)profile.toString());
                return profile;
            }
            throw new CredentialsException("Invalid username/password combination");
        }
        return null;
    }

    public LocalUser[] getLocalUserConfigurations() {
        return this.localUserConfigurations;
    }

    public PasswordEncoder getEncoder() {
        return this.encoder;
    }

    public void setLocalUserConfigurations(LocalUser[] localUserConfigurations) {
        this.localUserConfigurations = localUserConfigurations;
    }

    public void setEncoder(PasswordEncoder encoder) {
        this.encoder = encoder;
    }
}

