/*
 * Decompiled with CFR 0.152.
 */
package de.uniba.minf.auth.spring.authentication;

import de.uniba.minf.auth.ProfileActionHandler;
import de.uniba.minf.auth.profile.AuthProfile;
import java.util.LinkedHashMap;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.context.session.SessionStore;
import org.pac4j.core.profile.ProfileManager;
import org.pac4j.core.profile.UserProfile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomProfileManager
extends ProfileManager {
    private static final Logger log = LoggerFactory.getLogger(CustomProfileManager.class);
    private final ProfileActionHandler postprocessor;

    public CustomProfileManager(WebContext context, SessionStore sessionStore, ProfileActionHandler postprocessor) {
        super(context, sessionStore);
        this.postprocessor = postprocessor;
    }

    public void removeProfiles() {
        if (this.postprocessor != null) {
            LinkedHashMap profiles = super.retrieveAll(true);
            for (UserProfile p : profiles.values()) {
                this.postprocessor.handleLogout(this.castOrConvert(p));
            }
        }
    }

    protected LinkedHashMap<String, UserProfile> retrieveAll(boolean readFromSession) {
        LinkedHashMap profiles = super.retrieveAll(readFromSession);
        if (this.postprocessor == null) {
            return profiles;
        }
        for (UserProfile p : profiles.values()) {
            this.postprocessor.handleActivity(this.castOrConvert(p));
        }
        return profiles;
    }

    protected void saveAll(LinkedHashMap<String, UserProfile> profiles, boolean saveInSession) {
        super.saveAll(profiles, saveInSession);
        if (this.postprocessor == null) {
            return;
        }
        for (UserProfile p : profiles.values()) {
            this.postprocessor.handleLogin(this.castOrConvert(p));
        }
    }

    private AuthProfile castOrConvert(UserProfile p) {
        if (AuthProfile.class.isAssignableFrom(p.getClass())) {
            return (AuthProfile)AuthProfile.class.cast(p);
        }
        log.error("Expected AuthProfile for processing, but received {}", (Object)p.getClass().getSimpleName());
        return null;
    }
}

