let vocabularyTable;

$(document).ready(function() {
	vocabularyTable = new VocabularyTable({
		url: __util.composeUrl("api/v1/" + $("#entity-table").data("api-url") + "/"),
		definition: $("#entity-table").data("definition"),
		isRemote: $("#entity-table").data("remote-vocabulary")
	});
});


class VocabularyTable extends BaseTable {
    constructor(options) {
		super($.extend(true, {
	            containerSelector: "#entity-table-container",
	            selector: "#entity-table",
	            initMaxColumns: 5,
	            includeExportButtons: true,
	            includeSearchPane: false,
	            includeColumnReorder: true,
	            clickRowEvent: true,
	            buttons: [],
	            isRemote: false
	        }, options),
	        	[
					"view.dialog.generic.entry_added",
	        		"view.dialog.vocabulary_entry.clear_vocabulary",
            		"view.model.action.new_vocabulary_entry",
            		"view.model.action.fetch_vocabulary_entry",
            		"view.model.action.clear_vocabulary",
            		"view.dialog.vocabulary_entry.fetch_vocabulary_entry",
            		"view.dialog.vocabulary_entry.vocabulary_cleared"
            	]
	        );
	        
        const _this = this;
        this.initTranslations(function() {
			_this.addButtons();
			_this.applyBaseSettings();
            _this.createTable();
        });
    }
    
    addButtons() {
		const _this = this;
		if (__auth.isAuthenticated()) {
			if (_this.options.isRemote) {
				this.options.buttons.push([{
	                text: this.renderButtonTitle('add', "view.model.action.fetch_vocabulary_entry"),
	                className: 'btn btn-primary',
	                action: function() {
	                    _this.fetchEntry();
	                }
	            }, {
	                text: this.renderButtonTitle('remove', "view.model.action.clear_vocabulary"),
	                className: 'btn btn-danger',
	                action: function() {
	                	_this.clearVocabulary();
	                }
	            }]);
			} /*else {
	            this.options.buttons.push({
	                text: this.renderButtonTitle('add', "view.model.action.new_vocabulary_entry"),
	                className: 'btn btn-primary',
	                action: function() {
	                    window.location = __util.composeUrl("entry/new/" + _this.options.definition + "/");
	                }
	            });
            }*/
        }
	}
        
    handleRowClick(data) {
		//window.location = __util.composeUrl("entry/" + data.uniqueId + "/");
	}
	
    fetchEntry() {
        const _this = this;
        bootbox.prompt({
            title: __translator.translate('view.dialog.vocabulary_entry.fetch_vocabulary_entry'),
            locale: "current",
            callback: function(result) {
                if (result) {
                    $.ajax({
			            url: __util.composeUrl("api/v1/v/" + _this.options.definition + "/fetch"),
			            type: "POST",
			            data: { key: result },
			            success: function(data) {
							__util.showAlert("success", __translator.translate("view.dialog.generic.entry_added") + (data?.item?.key ? (": " + data.item.key) : ''));
			                _this.refresh();
			            },
						error: function(jqXHR) {
							if (jqXHR?.responseJSON!==undefined) {
								__util.showErrorResponse(jqXHR.responseJSON, "danger");
							}
							_this.refresh();
						}
			        });
                }
            }
        });
        
       
    }
    clearVocabulary() {
        const _this = this;
        bootbox.confirm({
            message: __translator.translate('view.dialog.vocabulary_entry.clear_vocabulary'),
            locale: "current",
            callback: function(result) {
                if (result) {
                    $.ajax({
                        url: __util.composeUrl("api/v1/v/" + _this.options.definition + "/clear"),
                        type: "POST",
                        success: function(data) {
							__util.showAlert("success", __translator.translate("view.dialog.vocabulary_entry.vocabulary_cleared"));
                            _this.refresh();
                        },
						error: function(jqXHR) {
							if (jqXHR?.responseJSON!==undefined) {
								__util.showErrorResponse(jqXHR.responseJSON, "danger");
							}
							_this.refresh();
						}
                    });
                }
            }
        });

    }
}