let profileEditor;

$(document).ready(function() {
	const userId = $("#userId").val();
	profileEditor = new ProfileEditor({
		url: __util.composeUrl("api/v1/users/" + userId),
		userId: userId
	});
});


class ProfileEditor {
    constructor(options) {
		this.options = options;
		
		__translator.addTranslations([
			"view.model.user.profile_updated",
			"view.model.user.profile_update_failed",
		]);
		__translator.getTranslations();
	}
    
    submitProfile() {
		const _this = this;
		
		const profile = {
			firstName: $("#firstName").val(),
			email: $("#email").val(),
			lastName: $("#lastName").val()
		}
		
		$.ajax({
            type: "POST",
            url: _this.options.url,
            contentType: "application/json; charset=UTF-8",
            data: JSON.stringify(profile),
            success: function(data) {
                __util.showAlert("success", __translator.translate("view.model.user.profile_updated", data.item.uniqueId));
            },
            error: function(jqXHR, textStatus, errorThrown) {
                if (jqXHR?.responseJSON) {
                    __util.showAlert("danger", __translator.translate("view.model.user.profile_update_failed", textStatus));
                }
            },
            dataType: "json"
        });
	}
}

