let notesTable;

$(document).ready(function() {
	notesTable = new NotesTable({
		containerSelector: "#notes-table-container",
		selector: "#notes-table"
	});
});

class NotesTable extends BaseTable {
    constructor(options) {
		super($.extend(true, {
	            initMaxColumns: -1,
	            buttons: [],
	        }, options),
	        	[
					"view.dialog.save",
		            "view.dialog.cancel",
		            "view.dialog.note.edit_note",
		            "view.model.note.action.create_new",
		            "view.dialog.note.delete_note",
		            "view.dialog.note.note_deletion_failed",
		            "view.dialog.note.note_save_failed"
            	]
	        );
	    
        const _this = this;
        this.initTranslations(function() {
			_this.addButtons();
			_this.applyBaseSettings();
            _this.createTable();
        });
    }
    
    addButtons() {
		const _this = this;
		if (__auth.isAuthenticated()) {
            this.options.buttons.push({
                text: this.renderButtonTitle('add', "view.model.note.action.create_new"),
                className: 'btn btn-primary',
                action: function() {
                    _this.triggerEditNote();
                }
            });
        }
	}
	
	triggerDeleteNote(button) {
        bootbox.confirm({
            message: __translator.translate('view.dialog.note.delete_note'),
            locale: "current",
            callback: function(result) {
                if (result) {
                     $.ajax({
			            type: "DELETE",
			            url: __util.composeUrl("notes/note/" + $(button).data("uniqueid")),
			            success: function() {
			                location.reload();
			            },
			            error: function(jqXHR) {
			                if (jqXHR?.responseJSON) {
			                    __util.showAlert("danger", __translator.translate("view.dialog.note.note_deletion_failed"));
			                }
			            },
			            dataType: "json"
			        });
                }
            }
        });
    }

	triggerEditNote(button) {
		const _this = this;
		const uniqueIdUrlSuffix = button==undefined ? "" : "/" + $(button).data("uniqueid");
		// Load note edit form
		$.ajax({
            type: "GET",
            url: __util.composeUrl("notes/forms/edit" + uniqueIdUrlSuffix),
            success: function(data) {
				_this.showEditForm(uniqueIdUrlSuffix, data)
            }
        });
	}

	showEditForm(uniqueIdUrlSuffix, form) {
		const _this = this;
		const html = $(form);
		// Prepare date pickers
		$(html).find(".datepicker").each(function() {
			const value = $(this).val();
			$(this).datepicker();
			$(this).datepicker("option", "dateFormat", "yy-mm-dd");
			$(this).datepicker("setDate", value);
		}) 
		
        bootbox.dialog({
            title: __translator.translate("view.dialog.note.edit_note"),
            message: html,
            size: 'large',
            locale: 'current',
            buttons: {
				cancel: {
					label: __translator.translate("view.dialog.cancel"),
					className: 'btn-tertiary'
				},
				ok: {
					label: __translator.translate("view.dialog.save"),
					className: 'btn-primary',
					callback: function(result) {
						let form = $(result.delegateTarget).find("form");
						let is_valid = form.get(0).reportValidity();
						if (!is_valid) {
							return false;
						}
						_this.submitNote(uniqueIdUrlSuffix, form);
					}
				}
			}
        });
	}
	
	submitNote(uniqueIdUrlSuffix, form) {
		const note = {
			enabled: $(form).find("#editnote-enabled").prop('checked'),
			name: $(form).find("#editnote-name").val(),
			localDisplayDate: $(form).find("#editnote-display-date").val(),
			localExpirationDate: $(form).find("#editnote-expiration-date").val(),
			localizedTexts: {}
		}								
		$(form).find(".editnote-texts textarea").each(function() {
			note.localizedTexts[$(this).data("lang")] = $(this).val();
		});

		$.ajax({
            type: "POST",
            url: __util.composeUrl("notes/note" + uniqueIdUrlSuffix),
            contentType: "application/json; charset=UTF-8",
            data: JSON.stringify(note),
            success: function() {
                location.reload();
            },
            error: function(jqXHR, textStatus) {
                if (jqXHR?.responseJSON) {
                    __util.showAlert("danger", __translator.translate("view.dialog.note.note_save_failed", textStatus));
                }
            },
            dataType: "json"
        });
        return false;
	}
}