let importedEntitiesTable;

$(document).ready(function() {
	const importId = $("#entity-table").data("importid");
	importedEntitiesTable = new ImportedEntitiesTable({
		url: __util.composeUrl("api/v1/e/i/" + importId + "/"),
		importId: importId
	});
});

class ImportedEntitiesTable extends BaseTable {
    constructor(options) {
		super($.extend(true, {
	            containerSelector: "#entity-table-container",
	            selector: "#entity-table",
	            initMaxColumns: -1,
	            clickRowEvent: true,
	            buttons: [],
	            importId: undefined
	        }, options),
	        	[
					"view.dialog.false",
		            "view.dialog.true",
		            "view.dialog.na",
		            "view.dialog.import.delete_import_readonly",
		            "view.dialog.import.delete_import_full",
		            "view.dialog.import.import_deletion_failed",
		            "view.model.import.action.delete_import"
            	]
	        );
	        
	    this.importActions = new ImportActions({
            owner: this,
            successCallback: function(data) { _this.handleDeletion(data); },
            errorCallback: function(error) { _this.handleDeletionError(error); }
        });
	        
        const _this = this;
        this.initTranslations(function() {
			_this.addButtons();
			_this.applyBaseSettings();
            _this.createTable();
        });
    }
    
    addButtons() {
		const _this = this;
		if (__auth.isAuthenticated()) {
            this.options.buttons.push({
                text: this.renderButtonTitle('remove', "view.model.import.action.delete_import"),
                className: 'btn btn-danger',
                action: function() {
                    _this.importActions.triggerDeleteImport(_this.options.importId);
                }
            });
        }
	}
    
    /*renderValueColumn(label, row, type, val, meta) {
		// Is current version if no nextVersionUniqueId is set 
		if (label!="nextVersionUniqueId") {
			return undefined;
		}
		return __translator.translate("view.dialog." + !(row.nextVersionUniqueId && row.nextVersionUniqueId.length>0));
	}*/
        
    handleRowClick(data) {
		window.location = __util.composeUrl("entity/" + data.uniqueId + "/");
	}
	
    handleDeletion() {
        window.location.replace(__util.composeUrl("imports"));
    }
    
    handleDeletionError() {
        __util.showAlert("danger", __translator.translate("view.dialog.import.import_deletion_failed"));
    }
}

