let importTable;

$(document).ready(function() {
	
	const sourceEntityId = $("#imports-table").data("entity");
	
	importTable = new ImportTable({
		url: __util.composeUrl("api/v1/imports" + (sourceEntityId ? "/source/" + sourceEntityId : "") ),
		containerSelector: "#imports-table-container",
		selector: "#imports-table"
	});
});

class ImportTable extends BaseTable {
    constructor(options) {
		super($.extend(true, {
	            containerSelector: "#entity-table-container",
	            selector: "#entity-table",
	            initMaxColumns: -1,
	            buttons: [],
	        }, options),
	        	[
					"view.dialog.false",
		            "view.dialog.true",
		            "view.dialog.na",
		            "view.dialog.import.import_deletion_failed",
		            "view.dialog.import.import_deleted_full",
		            "view.dialog.import.import_deleted_readonly",
		            "view.model.import.action.create_new"
            	]
	        );
	    
	    this.importActions = new ImportActions({
            owner: this,
            successCallback: function(data) { _this.handleDeletion(data); },
            errorCallback: function(error) { _this.handleDeletionError(error); }
        });    
	    
        const _this = this;
        this.initTranslations(function() {
			_this.applyBaseSettings();
            _this.createTable();
        });
    }
        
    renderSpecialColumn(name, row, type, val, meta) {
        if (type !== "display") {
            return "";
        } else {
            return '<div class="btn-group">' +
                '<a href="' + __util.composeUrl("imports/" + row.uniqueId + "/entities/") + '" class="btn btn-primary btn-sm"><i class="bi bi-database"></i></a>' +
                '<button class="btn btn-danger btn-sm btn-delete"><i class="bi bi-trash"></i></button>' +
                '</div>';
        }
    }
    
    assignTableEvents() {
		super.assignTableEvents();
		const _this = this;
		$('#imports-table tbody').on('click', 'button.btn-delete', function() {
            const data = _this.table.row($(this).parents('tr')).data();            
            _this.importActions.triggerDeleteImport(data.uniqueId);
            _this.refresh();
        });
	}
	
	handleRowClick(data) {
		window.location = __util.composeUrl("imports/" + data.uniqueId + "/entities/");
	}
    
    handleDeletion(data) {
        __util.showAlert("info", __translator.translate('view.dialog.import.import_deleted_readonly'));
        this.refresh();
    }
    
    handleDeletionError(error) {
        __util.showAlert("danger", __translator.translate("view.dialog.import.import_deletion_failed"));
    }
}
