class ImportActions {
	constructor(options) {
		this.options = $.extend(true, {
				owner: undefined,
				successCallback: undefined,
				errorCallback: undefined
			}, 
			options);
		
		__translator.addTranslations([
			"view.dialog.import.delete_import_readonly",
			"view.dialog.import.delete_import_full"
		]);
    }
    
	triggerDeleteImport(id) {
		const _this = this;
		bootbox.confirm({
			message: __translator.translate('view.dialog.import.delete_import_readonly'),
			locale: "current",
			callback: function(result) {
				if (result) {
					_this.deleteImport(id);
				}
			}
		});
	};

	deleteImport(id) {
		const _this = this;
		$.ajax({
			type: "DELETE",
			url: __util.composeUrl("api/v1/imports/" + id),
			success: function(data) {
				if (_this.options.successCallback != undefined && typeof _this.options.successCallback == 'function') {
					_this.options.successCallback(data);
				}
			},
			error: function(jqXHR, textStatus, errorThrown) {
				if (jqXHR !== undefined && jqXHR.responseJSON !== undefined) {
					if (_this.options.errorCallback != undefined && typeof _this.options.errorCallback == 'function') {
						_this.options.errorCallback(jqXHR.responseJSON);
					}
				}
			},
			dataType: "json"
		});
	};

}