class ImportMappingTable extends BaseTable {
    constructor(options) {
		super($.extend(true, {
	            containerSelector: "#mapping-table-container",
	            selector: "#mapping-table",
	            initMaxColumns: -1,
	            includeExportButtons: true,
                paginate: true,
	            buttons: [],
	            url: null	            
	        }, options), [
				"view.data_tables.btn.import_csv",
				"view.dialog.import_value_mappings.add_mapping",
				"view.dialog.import_value_mappings.edit_mapping",
				"model.import.value_mapping.allocation",
				"model.import.value_mapping.value",
				"model.import.value_mapping.prevent_resolve",
				"view.dialog.import_value_mappings.import_mappings_csv.title",
				"view.dialog.import_value_mappings.import_mappings_csv.message",
				"view.dialog.import_value_mappings.added_or_modified",
				"view.dialog.import_value_mappings.removed",
				"view.dialog.import_value_mappings.imported",
				"view.dialog.true",
				"view.dialog.false",
				"view.dialog.import_value_mappings.nothing_to_import"
			] );
        const _this = this;
        this.initTranslations(function() {
			_this.addButtons();
			_this.applyBaseSettings();
            _this.createTable();
        });
    }
    
    addButtons() {
		const _this = this;
		if (__auth.isAuthenticated()) {
			this.options.buttons.push({
                text: this.renderButtonTitle('add'),
                className: 'btn btn-primary',
                action: function() { _this.triggerAddRow(); }
            });
            this.options.buttons.push({
                text: this.renderButtonTitle('csv', "view.data_tables.btn.import_csv"),
                className: 'btn btn-outline-primary',
                action: function() { _this.triggerImportData(); }
            });
        }
	}
    
    renderSpecialColumn(special, row, type, val, meta) {
		if (type !== "display") {
            return "";
        } else if (special=="actions") {
            return '<div class="btn-group">' +
		                   '<button class="btn btn-primary btn-sm btn-edit"><i class="bi bi-pencil"></i></button>' +
		                   '<button class="btn btn-danger btn-sm btn-delete"><i class="bi bi-trash"></i></button>' +
		               '</div>';
        }
	}
    
    assignTableEvents() {
		super.assignTableEvents();
		const _this = this;
		$(this.options.selector + ' tbody').on('click', 'button.btn-edit', function() {
            _this.triggerEditRow(this);
            return false;
        });
        $(this.options.selector + ' tbody').on('click', 'button.btn-delete', function() {
			_this.triggerDeleteRow(this);
            return false;
        });
	}
	
	triggerImportData() {
		const _this = this;
        bootbox.prompt({
            title: __translator.translate("view.dialog.import_value_mappings.import_mappings_csv.title"),
            message: __translator.translate("view.dialog.import_value_mappings.import_mappings_csv.message"),
            locale: 'current',
            inputType: 'textarea',
            callback: function(result) {
                if (result==null || result.length==0) {
                   return;
                }
                _this.importMappings(result);
            }
        });
	}
	
	importMappings(data) {
		const parsed = parse(data)
		if (parsed.length>0) {
			for (let i=1; i<parsed.length; i++) {
				this.setOrAddMapping(parsed[i]);
			}		
			this.table.draw(false);
			__util.showAlert("success", __translator.translate("view.dialog.import_value_mappings.imported"), this.options.containerSelector + " .notifications-area");
		} else {
			__util.showAlert("warning", __translator.translate("view.dialog.import_value_mappings.nothing_to_import"), this.options.containerSelector + " .notifications-area");
		}
	}
		
	triggerAddRow(value, allocation, preventResolve, callback) {
		const _this = this;
		
		let htmlMessage = "<div id='modalform-new-entry'>";
		if (!value) {
			htmlMessage += "<div class='mb-3'>" +
							"<label for='modalform-new-entry-value' class='form-label'>" + 
								__translator.translate("model.import.value_mapping.value") +
							"</label>" +
    						"<input type='text' class='form-control value' id='modalform-new-entry-value'>" +
    					"</div>";
		} else {
			htmlMessage += "<input type='hidden' class='value' value='" + value + "'>";
		}
		htmlMessage += "<div class='mb-3'>" +
							"<label for='modalform-new-entry-allocation' class='form-label'>" +
								__translator.translate("model.import.value_mapping.allocation") +
							"</label>" +
    						"<input type='text' class='form-control allocation' id='modalform-new-entry-allocation'" + (allocation ? " value='" + allocation + "'" : "") + ">" +
    					"</div>" +
    					"<div class='mb-3 form-check'>" +
							"<input class='form-check-input preventResolve' type='checkbox' id='modalform-new-entry-preventResolve'" + (preventResolve===true ? " checked" : "") + "> " +
							"<label for='modalform-new-entry-preventResolve' class='form-label'>" +
								__translator.translate("model.import.value_mapping.prevent_resolve") +
							"</label>" +
    					"</div>" +
					 "</div>";
		
        let box = bootbox.confirm({
			title: value	? __translator.translate("view.dialog.import_value_mappings.edit_mapping", value) 
							: __translator.translate("view.dialog.import_value_mappings.add_mapping"),
			message: htmlMessage, 
			locale: 'current',
		    callback: function(result) {
		        if(result) {
					const value = $('#modalform-new-entry .value').val();
					const allocation = $('#modalform-new-entry .allocation').val();
					const preventResolve = $('#modalform-new-entry .preventResolve').is(':checked');
					if (value) {
						_this.setOrAddMapping([value, allocation, preventResolve]);
						__util.showAlert("success", __translator.translate("view.dialog.import_value_mappings.added_or_modified", value), _this.options.containerSelector + " .notifications-area");
					}
					if (callback != undefined && typeof callback == 'function') {
						callback(value, allocation);
					}
				}
			}
		});
		// Enter accepts the confirm dialog
		box.on("keyup", "input", function(event) {
			if (event.keyCode === 13) {
				event.preventDefault();
				box.find('.bootbox-accept').trigger('click');
			}
		});
		// Focus first input element on opening the modal
		box.on('shown.bs.modal',function(){
		    $("#modalform-new-entry :input:not([type=hidden])").first().focus();
		});
	}
	
	triggerEditRow(button) {
		let row = this.table.row($(button).parents('tr'));
        let data = row.data();
        
        this.triggerAddRow(data["value"], data["assignment"], data["preventResolve"]);
	}
	
	triggerDeleteRow(button) {
		const _this = this;
		
		let row = this.table.row($(button).parents('tr'));
    	let data = row.data();
    	
		$.ajax({
			type: "DELETE",
			url: _this.options.url,
			data: JSON.stringify([data["value"]]),
			contentType: "application/json; charset=UTF-8",
			success: function(data) {
				__util.showAlert("success", __translator.translate("view.dialog.import_value_mappings.removed", data?.item?.value), _this.options.containerSelector + " .notifications-area");
				_this.refresh();
			},
			dataType: "json"
		});
	}
	
	setOrAddMapping(entry) {
		const _this = this;
		$.ajax({
			type: "POST",
			url: _this.options.url,
			data: JSON.stringify(entry),
			contentType: "application/json; charset=UTF-8",
			success: function(data) {
				_this.refresh();
			},
			dataType: "json"
		});
	}
}