let importForm;
$(document).ready(function() {
	importForm = new ImportForm();
});

const ImportForm = function() {
	const _this = this;
	this.sourceEntityId = $("#entity-form").data("entity");
	
	__translator.addTranslations([
		"view.import.messages.import_data_required",
		"view.import.messages.target_entity_required",
		"view.import.messages.validation_result_valid",
		"view.import.messages.no_change_no_save",
		"view.import.messages.empty_record",
		"view.import.messages.validation_result",
		"view.import.messages.validation_result.validated",
		"view.import.messages.validation_result.successful",
		"view.import.messages.validation_result.unknown_properties",
		"view.import.messages.validation_result.validation_errors",
		"view.import.messages.validation_result.id_issues",
		"view.import.messages.import_result",
		"view.import.messages.import_result.imported",
		"view.import.messages.import_result.successful",
		"view.import.messages.import_result.unknown_properties",
		"view.import.messages.import_result.validation_errors",
		"view.import.messages.import_result.id_issues",
		"view.import.messages.import_result.vocabulary.matched_and_set_candidate",
		"view.import.messages.import_result.vocabulary.too_many_candidates",
		"view.import.messages.import_result.vocabulary.no_candidates_to_choose_from",
		"view.dialog.import_value_mappings.changed_reload",
		"view.import.messages.import_result.vocabulary.resolution_prevented",
		"view.import.messages.import_result.no_recent_import",
		"view.import.labels.validation_started",
		"view.import.labels.import_started",
		"view.timestamp"
	]);
	__translator.getTranslations();
	
	$("#import-form").on("submit", function(event) { _this.submit(true); event.preventDefault(); });
	
	this.mappingTable = new ImportMappingTable({
		url: __util.composeUrl("api/v1/vm/" + this.sourceEntityId),
	});
	this.refreshImportResponse(__util.composeUrl("api/v1/imports/state/source/" + this.sourceEntityId), function(data) {
		if (data.serverStatus=="BUSY") {
			_this.showImportInProgressMessage(data["_serverData"]?.importType==="IMPORT", data["_serverData"]?.timestamp);
		}
	});
};


ImportForm.prototype.submit = function(doImport) {
	$(".hide-while-loading").addClass("disabled");
	$(".show-while-loading").removeClass("d-none");
	
	$("#import-result").hide();
	
	$("#import-validation-errors ul").text("");
	$("#import-unknown-properties ul").text("");
	$("#import-resolved-values ul").text("");
	$("#imported-resources").text("");
	
	const _this = this;
	$.ajax({
		type: "GET",
		url: __util.composeUrl("api/v1/e/" + this.sourceEntityId),
		success: function(data) {
			const entity = data?.properties?.target_entity["@value"] || data?.properties?.target_entity["@reference"]; 
			
			$.ajax({
				type: "POST",
				url: __util.composeUrl("api/v1/e/" + entity + (doImport ? "/import" : "/validate")),
				data: JSON.stringify({ 
					sourceEntityId: _this.sourceEntityId
				}),
				contentType: "application/json; charset=UTF-8",
				success: function(data) {
					_this.showImportInProgressMessage(doImport, data.timestamp);
					setTimeout(function() { _this.refreshImportResponse(data.action, doImport); }, 3000);
				},
				error: function(jqXHR) {
					if (jqXHR?.responseJSON!==undefined) {
						__util.showErrorResponse(jqXHR.responseJSON, "danger", "#notifications-area-import");
					}
					$(".hide-while-loading").removeClass("disabled");
					$(".show-while-loading").addClass("d-none");
				},
				dataType: "json"
			});
		},
		dataType: "json"
    });
};

ImportForm.prototype.showImportInProgressMessage = function(doImport, timestamp) {
	let alertMessage = '<h4 class="alert-heading">' + __translator.translate(doImport ? "view.import.labels.import_started" : "view.import.labels.validation_started") + '</h4>';
	let alertType = "success";
	
	if (timestamp) {
		alertMessage += __translator.translate("view.timestamp") + ": " + timestamp;
	}
	
	__util.showAlert(alertType, alertMessage, "#notifications-area-import");
}

ImportForm.prototype.refreshImportResponse = function(url, callback) {
    const _this = this;
    $("#hint-no-recent-import-data").addClass("d-none");
    $.ajax({
		type: "GET",
		url: url,
		success: function(data) {
			if (data.serverStatus=="BUSY") {
				setTimeout(function() { _this.refreshImportResponse(data.action); }, 3000);
				$(".hide-while-loading").addClass("disabled");
				$(".show-while-loading").removeClass("d-none");
			} else if (data.serverStatus=="NONE") {
				$("#hint-no-recent-import-data").removeClass("d-none");
				$(".hide-while-loading").removeClass("disabled");
				$(".show-while-loading").addClass("d-none");
			} else {
				_this.processResponse(data);
				$(".hide-while-loading").removeClass("disabled");
				$(".show-while-loading").addClass("d-none");
			}
			if (callback!==null && callback!==undefined && typeof callback==='function') {
        		callback(data);
        	}
		},
		error: function(jqXHR) {},
		dataType: "json"
    });
}

ImportForm.prototype.processResponse = function(data) {
	let doImport;
	if (data["_serverData"]?.importType=="IMPORT") {
		doImport = true;
		$("#import-result-type").text(__translator.translate("view.import.messages.import_result"));
	} else {
		doImport = false;
		$("#import-result-type").text(__translator.translate("view.import.messages.validation_result"));
	}
	
	this.processOverallResult(data, doImport);
	this.showImportResult();
	if (importTable) {
		importTable.refresh();
	}
}

ImportForm.prototype.processOverallResult = function(data, doImport) {
	let result = {
		importPerformed: data.action=="UPDATED" || data.action=="CREATED",
		validationPerformed: data.action=="UNCHANGED" && !doImport,
		noResults: data.action=="UNCHANGED" && doImport,
		hasItems: data.items?.length>0 || false,
		items: data.items || [],
		unknownProperties: data._serverData?.unknownProperties || [],
		validationErrors: data._serverData?.validationErrors || [],
		resolvedVocabularyEntries: data._serverData?.resolvedVocabularyEntries || [],
		externalIdIssues: data._serverData?.externalIdIssues || false
	};
	
	result.hasValidationErrors = result.validationErrors.some(p => Array.isArray(p) && p.length>0);
	result.hasUnknownProperties = result.unknownProperties.some(p => Array.isArray(p) && p.length>0);
	result.hasResolvedVocabularyEntries = result.resolvedVocabularyEntries.some(p => Array.isArray(p) && p.length>0);
			
	let alertMessage;
	let alertType = "success";
	let messages = [];
	
	// Some or all data was saved
	if (result.importPerformed) {
		alertMessage = '<h4 class="alert-heading">' + __translator.translate("view.import.messages.import_result.imported") + '</h4>';
	
		// Some records have validation errors
		if (result.hasValidationErrors) {
			messages.push(__translator.translate("view.import.messages.import_result.validation_errors"));
			alertType = "warning";
		}
		// No validation errors, but some records have unknown properties
		if (result.hasUnknownProperties) {
			messages.push(__translator.translate("view.import.messages.import_result.unknown_properties"));
			alertType = (alertType != "warning") ? "info" : alertType;
		}
		// There are issues with external ids
		if (result.externalIdIssues) {
			messages.push(__translator.translate("view.import.messages.import_result.id_issues"));
			alertType = "danger";
		}
		// So warnings or messages at all
		if (messages.length==0) {
			messages.push(__translator.translate("view.import.messages.import_result.successful"));
		}
	}
	// Validation performed
	else if (result.validationPerformed) {
		alertMessage = '<h4 class="alert-heading">' + __translator.translate("view.import.messages.validation_result.validated") + '</h4>';
		
		// Some records have validation errors
		if (result.hasValidationErrors) {
			messages.push(__translator.translate("view.import.messages.validation_result.validation_errors"));
			alertType = "warning";
		}
		// No validation errors, but some records have unknown properties
		if (result.hasUnknownProperties) {
			messages.push(__translator.translate("view.import.messages.validation_result.unknown_properties"));
			alertType = (alertType != "warning") ? "info" : alertType;
		}
		// There are issues with external ids
		if (result.externalIdIssues) {
			messages.push(__translator.translate("view.import.messages.validation_result.id_issues"));
			alertType = "danger";
		}
		// So warnings or messages at all
		if (messages.length==0) {
			messages.push(__translator.translate("view.import.messages.validation_result.successful"));
		}
	}
	// Import attempted, but no changes => no items detected
	else if (result.noResults) {
		messages.push(__translator.translate("view.import.messages.no_change_no_save"));
		alertType = "warning";
	}
		
	if (messages.length==1) {
		alertMessage = __translator.translate("view.import.messages.validation_result.successful")
	} else {
		alertMessage += "<ul>";
		for (let msg of messages) {
			alertMessage += "<li>" + msg + "</li>";
		}
		alertMessage += "</ul>";
	}
	
	this.result = result;
	__util.showAlert(alertType, alertMessage, "#notifications-area-import");
}

ImportForm.prototype.showImportResult = function() {
	if (this.result.items==undefined || this.result.items.length==0) {
		$("#import-result").hide();
	} else {
		this.showItem(0);
		$("#import-result").show();
	} 
	$(window).scrollTop(0);
};

ImportForm.prototype.showItem = function(index) {
	$("#import-result legend").removeClass("bg-success").removeClass("bg-warning").removeClass("bg-danger").removeClass("bg-info");
	$("#import-result").removeClass("border-success").removeClass("border-warning").removeClass("border-danger").removeClass("border-info");
	$("#import-result-icon").html('');
	
	$("#import-success").html('');
	$("#import-messages-container ul").html('');
	$("#import-validation-violations").html('');
	$("#imported-resources").html('');
	
	$("#import-messages-container .accordion-item").hide();
	$("#import-messages-container .accordion-body").text('');	
	
	let state = "success";		
	if (this.result?.unknownProperties[index].length+this.result?.validationErrors[index].length+this.result?.resolvedVocabularyEntries[index].length==0) {
		$("#import-success").show();
		$("#import-result-icon").html('<i class="bi bi-check-circle"></i>');
	} else {
		$("#import-success").hide();
		if (this.result?.validationErrors[index].length>0) {
			$("#import-result-icon").html('<i class="bi bi-exclamation-triangle"></i>');
			state = "warning";
		} else {
			$("#import-result-icon").html('<i class="bi bi-question-circle"></i>');
			state = "info";	
		}
		this.showValidationViolations(this.result?.validationErrors[index]);
		this.showUnknownFields(this.result?.unknownProperties[index]);
		this.showResolvedVocabularyEntries(this.result?.resolvedVocabularyEntries[index]);
	}
	
	// Show record properties
	if (this.result.items[index].properties==undefined || this.result.items[index].properties.length==0) {
		if (state=="success") {
			state = "info";
		}
		$("#imported-resources").html(__translator.translate("view.import.messages.empty_record"));
	} else {
		$("#imported-resources").html(this.showItemProperties(this.result.items[index].properties, null, this.result?.validationErrors[index], this.result?.resolvedVocabularyEntries[index]));
	}
	
	$("#import-result legend").addClass("bg-" + state);
	$("#import-result").addClass("border-" + state);
	
	$('[data-bs-toggle="tooltip"]').tooltip();
		
	this.handleItemNavigation(index);
};

ImportForm.prototype.showItemProperties = function(properties, path, validationErrors, resolvedVocabularyEntries) {
	const list = $("<div class='import-result-list'>");
	if (properties) {
		this.showItemPropertyEntries(list, properties, path, validationErrors, resolvedVocabularyEntries)
	}
	return list;
};

ImportForm.prototype.showItemPropertyEntries = function(list, properties, path, validationErrors, resolvedVocabularyEntries) {
	// Iterate over all properties of the imported entity
	for (const [key, value] of Object.entries(properties)) { 
		let propPath = (path==null ? key : (path + "." + key));
		
		let li = $("<div class='d-flex'>");
		let content = $("<div class='property flex-grow-1' id='" + propPath + "'>");
		$(content).data("path", propPath);
		
		$(content).append("<span class='property-label'>" + key + "</span>: ");
		
		// Multiple values for the property -> in divs to stack vertically
		if (Array.isArray(value)) {
			let valueSublist = $("<div class='property-values ps-3'>");
			for (let j=0; j<value.length; j++) {
				let propValuePath = propPath + "[" + j + "]";
				let valueSublistItem = $("<div class='property-value'>");
				$(valueSublistItem).prop("id", propValuePath);
				$(valueSublistItem).data("path", propValuePath);
				this.showItemPropertyValue(valueSublistItem, value[j], propValuePath, validationErrors, resolvedVocabularyEntries, j);
				
				// Status for the property value in an array
				this.handleItemPropertyStatus(propValuePath, valueSublistItem, validationErrors, resolvedVocabularyEntries);
				$(valueSublist).append(valueSublistItem);
			}
			$(content).append(valueSublist);
		} 
		
		// Single value for the property -> in span to show inline
		else {
			let valueSublistItem = $("<span class='property-value'>");
			$(valueSublistItem).prop("id", propPath)
			$(valueSublistItem).data("path", propPath);
			this.showItemPropertyValue(valueSublistItem, value, propPath, validationErrors, resolvedVocabularyEntries);
			
			//this.handleItemPropertyStatus(propPath, valueSublistItem, validationErrors, resolvedVocabularyEntries);
			$(content).append(valueSublistItem);
		}
		
		// Status for the whole property
		this.handleItemPropertyStatus(propPath, content, validationErrors, resolvedVocabularyEntries);
		
		$(li).append(content);
		
		$(list).append(li);
	}
}

ImportForm.prototype.showItemPropertyValue = function(li, value, path, validationErrors, resolvedVocabularyEntries, index) {
	
	// Null values (should not occur)
	if (value == null) {
		$(li).append("NULL");
	} 
	// Object wrapped values (@value or @reference with optional @lang)
	else if (typeof value === 'object' && !Array.isArray(value) && (value.hasOwnProperty('@value') || value.hasOwnProperty('@reference'))) {
		let label;
		if (value.hasOwnProperty('@value')) {
			label = value["@value"];
		} else if (value.hasOwnProperty('@reference')) {
			label = value["@reference"];
		}
		$(li).append(__util.asLinkIfLink(label, ' <i class="bi bi-box-arrow-up-right"></i>', "_BLANK"));
		li.data("value", label);
		if (value.hasOwnProperty('@lang')) {
			$(li).append(" <span class='badge rounded-pill text-bg-primary'>" + value["@lang"] + "</span>");
		}
	} 
	// Object without @value or @reference -> hierarchical property 
	else if (typeof value === 'object' && !Array.isArray(value)) {
		const list = $("<div class='hierarchy-sublist ps-3'>");
		// Show index if we are in an array of hierarchical objects 
		if (index!==undefined) {
			$(li).append("<span class='property-label'>[" + index + "]</span>: ");
		}
		this.showItemPropertyEntries(list, value, path, validationErrors, resolvedVocabularyEntries);
		$(li).append(list);
	} 
	// Simple value
	else {
		$(li).append(__util.asLinkIfLink(value, ' <i class="bi bi-box-arrow-up-right"></i>', "_BLANK"));
		li.data("value", value);
	}
}

ImportForm.prototype.handleItemPropertyStatus = function(path, listItem, validationErrors, resolvedVocabularyEntries) {
	let check = true; 
	for (const res of resolvedVocabularyEntries) {
		if (res.path==path) {
			this.showResolvedVocabularyEntry(res, listItem);
			check = false;
		}
	}
	
	for (const err of validationErrors) {
		if (err.name==path) {
			check = false;
			$(listItem).prepend('<i class="bi bi-exclamation-triangle text-danger pe-1" ' + 
									'data-bs-toggle="tooltip" data-bs-placement="top" data-bs-custom-class="custom-tooltip-danger" ' + 
									'data-bs-title="' + err.message + '"></i>');
									
			$(listItem).addClass("text-danger");							
		}
	}
	
	if (check) {
		$(listItem).prepend('<i class="bi bi-check-circle pe-1"></i>');
	}
}

ImportForm.prototype.triggerManualResolve = function(control) {
	const li = $(control).closest("li");
	
	const vocabulary = $(li).data("resolve-vocabulary");
	const value = $(li).data("resolve-query");
	const allocation = $(li).data("resolve-key");
	
	this.mappingTable.triggerAddRow(value, allocation, function(v, a) {
		const li = $("#import-form li").filter( function(){ return $(this).data('resolve-query')==v });
		
		if (li.find(".bi bi-arrow-clockwise").length==0) {
			const i = $('<i class="bi bi-arrow-clockwise" ' + 
									'data-bs-toggle="tooltip" data-bs-placement="top" ' + 
									'data-bs-title="' + __translator.translate("view.dialog.import_value_mappings.changed_reload") + '"></i> ');
			li.prepend(i);
			$(i).tooltip();
		}
		li.find(".property-resolved-value").html(__util.asLinkIfLink(a, ' <i class="bi bi-box-arrow-up-right"></i>', "_BLANK"));
	});
}

ImportForm.prototype.handleItemNavigation = function(index) {
	$("#curr-item").text((index+1) + " / " + this.result.items.length);
	
	if (index==0) {
		$("#btn-prev-item").data("nav-index", index).html('<i class="bi bi-caret-left"></i>');
	} else {
		$("#btn-prev-item").data("nav-index", index-1).html('<i class="bi bi-caret-left-fill"></i>');
	}
	if (index<this.result.items.length-1) {
		$("#btn-next-item").data("nav-index", index+1).html('<i class="bi bi-caret-right-fill"></i>');
	} else {
		$("#btn-next-item").data("nav-index", this.result.items.length-1).html('<i class="bi bi-caret-right"></i>');
	}
};

ImportForm.prototype.showValidationViolations = function(violations) {
	if (violations.length>0) {
		$("#import-validation-errors").parent(".accordion-item")
			.show()
			.find(".message-count").text(violations.length);
		
		for (const violation of violations) {
			$("#import-validation-errors ul").append("<li><i class='bi bi-exclamation-triangle text-danger'></i> " + violation.message + " (" + violation.name + ")</li>");
		}
	}
};

ImportForm.prototype.showUnknownFields = function(fields) {
	if (fields.length>0) {
		$("#import-unknown-properties").parent(".accordion-item")
			.show()
			.find(".message-count").text(fields.length);
		var unknown = [];
		for (const field of fields) {
			if (!unknown.includes(field.path)) {
				unknown.push(field.path);
			}
		}
		for (const u of unknown) {
			$("#import-unknown-properties ul").append("<li><i class='bi bi-question-circle text-info'></i> " + u);
		}
	}
};

ImportForm.prototype.showResolvedVocabularyEntries = function(resolvedEntries) {
	if (resolvedEntries.length>0) {		
		let warning = false;
		for (const res of resolvedEntries) {
			let listItem = $("<li>");
			listItem.append("<span class='property-value'>" + __util.asLinkIfLink(res.resolvedKey ? res.resolvedKey : res.query, ' <i class="bi bi-box-arrow-up-right"></i>', "_BLANK") + "</span>");
			warning = this.showResolvedVocabularyEntry(res, listItem) || warning;

			listItem.append(" (" + res.path + ")");

			$("#import-resolved-values ul").append(listItem);
		}
		$("#import-resolved-values").parent(".accordion-item").find(".accordion-header .bi").addClass("text-" + (warning ? "warning" : "info") );
		
		$("#import-resolved-values").parent(".accordion-item")
			.show()
			.find(".message-count").text(resolvedEntries.length).removeClass("bg-info").removeClass("bg-warning").addClass("bg-" + (warning ? "warning" : "info"));
	}
}

ImportForm.prototype.showResolvedVocabularyEntry = function(res, listItem) {
	let message;
	let color;
	if (res.resolved) {
		message = __translator.translate("view.import.messages.import_result.vocabulary.matched_and_set_candidate");
		$(listItem).append("<span class='property-resolved-value'>" + res.query + "</span> &rarr; ");
		color = "info";
	} else if (res.resolutionPrevented) {
		message = __translator.translate("view.import.messages.import_result.vocabulary.resolution_prevented");
		$(listItem).append(" &rarr; <span class='property-resolved-value'>" + __translator.translate("view.import.messages.import_result.vocabulary.resolution_prevented") + "</span>");
		color = "info";
	} else if (res.candidateCount > 0) {
		message = __translator.translate("view.import.messages.import_result.vocabulary.too_many_candidates");
		$(listItem).append(" &rarr; <span class='property-resolved-value'>" + __translator.translate("view.import.messages.import_result.vocabulary.too_many_candidates") + "</span>");
		color = "warning";
	} else {
		message = __translator.translate("view.import.messages.import_result.vocabulary.no_candidates_to_choose_from");
		$(listItem).append(" &rarr; <span class='property-resolved-value'>" + __translator.translate("view.import.messages.import_result.vocabulary.no_candidates_to_choose_from") + "</span>");
		color = "warning";
	}

	$(listItem).prepend('<i class="bi bi-database cursor-hand text-' + color + '" pe-1' + 
							'onclick="importForm.triggerManualResolve(this);return false;"' +
							'data-bs-toggle="tooltip" data-bs-placement="top" data-bs-custom-class="custom-tooltip-' + color + '" ' + 
							'data-bs-title="' + message + '"></i>');
							
	$(listItem).addClass("text-" + color);					
							
	$(listItem).data("resolve-vocabulary", res.vocabulary);
	$(listItem).data("resolve-query", res.query);
	$(listItem).data("resolve-candidates", res.candidateCount);
	$(listItem).data("resolve-resolved", res.resolved);
	if (res.resolvedKey) {
		$(listItem).data("resolve-key", res.resolvedKey);
	}
	return color=="warning";
}