var entityTable;

$(document).ready(function() {
	const lang = $("html").prop("lang");
	
	entityTable = new EntityTable({
		url: __util.composeUrl("api/v1/" + $("#entity-table").data("api-url") + "/?lang=" + lang + "&includeDrafts=true"),
		definition: $("#entity-table").data("definition"),
		drafts: $("#entity-table").data("drafts"),
		templates: $("#entity-table").data("templates"),
		creationAllowed: $("#entity-table").data("creationAllowed"),
		compositionAllowed: $("#entity-table").data("compositionAllowed")
	});
});


class EntityTable extends BaseTable {
	constructor(options) {
		super($.extend(true, {
				containerSelector: "#entity-table-container",
				selector: "#entity-table",
				initMaxColumns: 5,
				includeExportButtons: true,
				includeSearchPane: true,
				includeColumnReorder: true,
				clickRowEvent: true,
				buttons: []
			}, options),
	        	[
	        		"view.dialog.na",
					"view.dialog.true",
					"view.dialog.false",
					"model.generic.state.readOnly",
					"model.generic.state.draft",
					"model.generic.state.imported",
					"model.generic.state.deleted",
					"model.generic.state.published",
					"model.generic.state.template",
					"view.model.action.new_entity",
					"view.model.action.remove_own_drafts",
					"view.dialog.drafts.remove_own_drafts",
					
					"view.dialog.generic.delete_succeeded",
					"view.dialog.generic.delete_failed",
					
					"view.model.entity.hint.template",
					"view.model.entity.hint.draft",
					"view.model.entity.hint.published",
					"view.model.entity.hint.lock",
					"view.model.entity.hint.deleted",
					"view.model.entity.hint.composite",
					"view.model.entity.hint.source",
					"view.model.entity.hint.layer"
            	]
	        );
        
        const _this = this;
        this.initTranslations(function() {
			_this.addButtons();
			_this.applyBaseSettings();
            _this.createTable();
        });
    }
    
    addButtons() {
		const _this = this;
		if (__auth.isAuthenticated() && this.options.definition && this.options.creationAllowed) {
			this.options.buttons.push({
				text: this.renderButtonTitle('add', "view.model.action.new_entity"),
				className: 'btn btn-primary',
				action: function(e, dt, node, config) {
					window.location = __util.composeUrl("entity/new/" + _this.options.definition + "/");
				}
			})
		}
		if (__auth.isAuthenticated() && this.options.drafts) {
			this.options.buttons.push({
				text: this.renderButtonTitle('remove', "view.model.action.remove_own_drafts"),
				className: 'btn btn-danger',
				action: function(e, dt, node, config) {
					_this.deleteDrafts();
				}
			})
		}
	}
    
    deleteDrafts() {
		const _this = this;
		bootbox.confirm({
            message: __translator.translate('view.dialog.drafts.remove_own_drafts'),
            locale: "current",
            callback: function(result) {
                if (result) {
                    $.ajax({
			            type: "DELETE",
			            url: __util.composeUrl("api/v1/drafts"),
			            success: function() {
			                __util.showAlert("info", __translator.translate("view.dialog.generic.delete_succeeded"));
			                _this.refresh();
			            },
			            error: function(jqXHR, textStatus, errorThrown) {
			                if (jqXHR?.responseJSON) {
			                    __util.showAlert("danger", __translator.translate("view.dialog.generic.delete_failed"));
			                }
			            },
			            dataType: "json"
			        });
                }
            }
        });
	}
    
	createTable() {
		const _this = this;
		let columns;
		if (this.options.url) {
	        columns = this.createDynamicColumns({
				"targets": [0],
				"data": function(row, type, val, meta) { return _this.renderStateColumn(row, type, val, meta); },
			});
        } 
        this.createDatatable(columns);
    }
	
	handleRowClick(data) {
		window.location = __util.composeUrl("entity/" + data.entityId + "/");
	}
	
	handleRefresh(oSettings) {
		super.handleRefresh(oSettings);
		
		if (this.table==null) {
			return;
		}
		var data = this.table.rows().data();
        var totalDrafts = 0;
        var totalPublished = 0;
        var totalRemote = 0;
        var totalLocal = 0;
        var totalComposed = 0;
        var sourceLabels = new Map();
        var rowCount = data.length;

        for (var i = 0; i < rowCount; i++) {
			totalDrafts += data[i].draft===true ? 1 : 0;
			totalPublished += data[i].published===true ? 1 : 0;
			totalComposed += data[i].composite===true ? 1 : 0;

			if (data[i].sourceLabel!==undefined && data[i].sourceLabel!==null) {
				let sourceCount;
				if (sourceLabels.has(data[i].sourceLabel)) {
					sourceCount = sourceLabels.get(data[i].sourceLabel)+1;
				} else {
					sourceCount = 1;
				}
				sourceLabels.set(data[i].sourceLabel, sourceCount);
				totalRemote++;
			} else {
				totalLocal++;
			}
			
			if (data[i].layers!==undefined && data[i].layers!==null) {
				for (const layer of data[i].layers) {
					let sourceCount;
					if (sourceLabels.has(layer["@value"])) {
						sourceCount = sourceLabels.get(layer["@value"])+1;
					} else {
						sourceCount = 1;
					}
					sourceLabels.set(layer["@value"], sourceCount);
				}
			}
        }

        this.updateCounter("#table-draft-counter", totalDrafts);
        this.updateCounter("#table-published-counter", totalPublished);
        
        // TODO: Helpful or cluttering?
        //this.updateCounter("#table-remote-counter", totalRemote);
        //this.updateCounter("#table-composite-counter", totalComposed);
        //this.updateCounter("#table-local-counter", totalLocal);
        this.updateSources(sourceLabels);
    }
    
    updateCounter(selector, count) {
		if (count>0) {
			$(selector).removeClass("d-none");
		} else {
			$(selector).addClass("d-none");
		}
		$(selector).find(".count").text(count);
	}
    
    updateSources(sourceLabels) {
		if (sourceLabels.size==0) {
			$("#table-sources").text("").addClass("d-none");
		} else {
			let sources = "";
			sourceLabels.forEach(function(value, key, map) {
				sources += '<span class="badge bg-primary" onclick="entityTable.filterData(undefined, undefined, undefined, \'' + key + '\');">' + key + ': <strong class="count">' + value + '</strong></span> ';
			});
			$("#table-sources").html(sources).removeClass("d-none");
		}
	}
	
	filterData(all, published, draft, source) {
        if (all===true) {
			$("#table-reset-quickfilter").addClass("d-none");
			this.table.ajax.reload(null, false);
			return;
		}
		var filteredData = [];
        this.table.rows().every(function() {
            var data = this.data();
            if (published===true && data.published) {
                filteredData.push(data);
            } else if (draft===true && data.draft) {
				filteredData.push(data);
			}
			if (source) {
				if (data.sourceLabel===source) {
					filteredData.push(data);
				} else if (data.layers) {
					for (let layer of data.layers) {
						if (layer.hasOwnProperty("@value") && layer["@value"]===source) {
							filteredData.push(data);
							break;
						}
					}	
				}
			}
        });

		$("#table-reset-quickfilter").removeClass("d-none");
        this.table.clear().rows.add(filteredData).draw();
	}
	
	renderStateColumn(row, type, val, meta) {
		const _this = this;
		let properties = [
			   { property: "template", type: "primary", icon: "bi bi-file-earmark", tooltip: "view.model.entity.hint.template" }, 
			   { property: "draft", type: "warning", icon: "bi bi-file-earmark-text", tooltip: "view.model.entity.hint.draft" }, 
			   { property: "published", type: "success", icon: "bi bi-check", tooltip: "view.model.entity.hint.published" },
			   { property: "lock", type: "primary", icon: "bi bi-lock-fill", render: function(row) { return row.readOnly && !_this.options.compositionAllowed }, tooltip: "view.model.entity.hint.lock" },
			   { property: "deleted", type: "danger", icon: "bi bi-trash", tooltip: "view.model.entity.hint.deleted" }, 
			   { property: "composite", type: "primary", icon: "bi bi-layers", tooltip: "view.model.entity.hint.composite" }
		]
		
		if (row.hasOwnProperty("sourceLabel")) {
			properties.push({ property: "source", type: "primary", render: true, text: row["sourceLabel"], tooltip: "view.model.entity.hint.source" })
		}
		if (row.layers) {
			for (let layer of row.layers) {
				if (layer.hasOwnProperty("@value")) {
					properties.push({ property: "layer", type: "primary", render: true, text: layer["@value"], tooltip: "view.model.entity.hint.layer" })
				}
			}	
		}
		
		return this.renderStateProperties(properties, row, type=="display");
	}
	
	renderStateProperties(properties, row, display) {
		let result = "";
		for (let prop of properties) {
			const render = prop.render && ((typeof prop.render == 'function' && prop.render(row)) || prop.render===true);

			if (render || (row.hasOwnProperty(prop.property)) && row[prop.property]===true) {
				if (display) {
					// TODO: Tooltips are missing at least for non-text
					// If we render text -> show in badge				
					if (prop.text) {
						result += '<span class="badge bg-' + prop.type + '"' + (prop.tooltip ? ' data-bs-toggle="tooltip" data-bs-placement="right" data-bs-title="' + __translator.translate(prop.tooltip) + '"' : '') + '>';
					}
					// If there is an icon -> show; if there is no text -> set icon color
					if (prop.icon) {
						result += '<i class="' + (prop.text ? "" : "text-" + prop.type + " ") + prop.icon + '"' + (prop.tooltip ? ' data-bs-toggle="tooltip" data-bs-placement="right" data-bs-title="' + __translator.translate(prop.tooltip) + '"' : '') + '></i> ';
					} 
					// Render text and close badge
					if (prop.text) {
						result += (prop.text===true ? __translator.translate("model.generic.state." + prop.property) : prop.text) + '</span> ';
					}
				} else {
					result += (prop.text===true ? __translator.translate("model.generic.state." + prop.property) : prop.text);
				}
			}
		}
		return result;
	}
};