var ValueList = function(options) {
	this.options = $.extend(true, 
			{
				// Should be overriden
				container: null, 
				owner: null,
				//listSelector: ".editor-list",
				newRowUrl: "?",
				newRowCallback: null,
				propertyName: "?",

				// Defaults should be ok
				listItemSelector: ".property-value-list-item",
				listReadonlyItemSelector: ".property-value-readonly-item",
				addButtonSelector: ".btn-valuelist-add",
				pushUpButtonSelector: ".btn-valuelist-push-up",
				pushDownButtonSelector: ".btn-valuelist-push-down",
				invalidFeedbackSelector: ".invalid-feedback",
			}, 
			options);
		
	this.container = this.options.container;
	
	this.sort();
}

ValueList.prototype.sort = function() {
	let _this = this;
	let list = $(this.container);
		
	let viewIndex = 0;
	let dataIndex = 0;
	let lastItem = null;
	list.find(this.options.listItemSelector).each(function() {
		let countItem = false;
		
		$(this).find(_this.options.pushDownButtonSelector).addClass("disabled");
		if (viewIndex==0) {
			$(this).find(_this.options.pushUpButtonSelector).addClass("disabled");
		} else {
			$(this).find(_this.options.pushUpButtonSelector).removeClass("disabled");
		}
		if (lastItem!=null) {
			$(lastItem).find(_this.options.pushDownButtonSelector).removeClass("disabled");
		}
		lastItem = $(this);
		
		// In general: iterate over all submitted form elements and number according to their index	
		$(this).find(".form-body-element").not(".tt-hint").each(function() {
			let subprop = $(this).data("subprop");
			let name = function(includeIndex) { return _this.options.propertyName + (includeIndex ? ("[" + dataIndex + "]") : '') + (subprop ? '#' + subprop : ''); };	
			let id = _this.options.propertyName + viewIndex + (subprop ? '#' + subprop : '');
			
			$(this).attr("id", id);
			
			// Values of unchecked checkboxes (we are presenting all vocabulary entries)
			//  are not submitted => remove id/name and skip in indexing  
			if ($(this).hasClass("form-vocabulary-select-item")) {
	
				// Update value from free-text input before submitting
				let valInput = $(this).next(".form-vocabulary-select-label").find("input");
				if (valInput && valInput.length>0) {
					$(this).val($(valInput).val());
				}
				
				// Update label for attr to possibly new id
				$(this).next(".form-vocabulary-select-label").find("label").attr("for", id);
				
				// Unchecked form-vocabulary-select-items can be skipped
				if ($(this).is(':checked')) {
					// Options are not indexed as no multivalues are allowed => same names for every option 
					if ($(this).attr("type")=="radio") {
						$(this).attr("name", name(false));
						countItem = true;
					} else if ($(this).val()) {
						$(this).attr("name", name(true));
						countItem = true;
					} else {
						// Skip empty values on checkboxes
						$(this).removeAttr("name");
					}
				} else {
					$(this).removeAttr("name");
				}
			} else if ($(this).val()) {
				$(this).attr("name", name(true));
				countItem = true;
			} else {
				$(this).removeAttr("name");		
			}			
		});
		if (countItem) {
			dataIndex++;
		}
		viewIndex++;
	});
}

ValueList.prototype.updateValue = function(input) {
	let valCheck = $(input).closest(".property-value-list-item").find(".form-vocabulary-select-item");
	$(valCheck).val($(input).val());
	
	// Uncheck other radio buttons
	if ($(valCheck).attr("type")=="radio") {
		$(input).closest(".property-value-list").find(".form-vocabulary-select-item").prop("checked", false);
	}	
	$(valCheck).prop("checked", true);
};

ValueList.prototype.triggerAddListElementIfListEmpty = function() {
	let itemcount = 0;
	itemcount += $(this.container).find(this.options.listItemSelector).length;
	itemcount += $(this.container).find(this.options.listReadonlyItemSelector).length;
	if (itemcount==0) {
		this.triggerAddListElement();
	}
}


ValueList.prototype.triggerAddListElement = function(data, preNewRowCallback) {
	const _this = this;

	const list = $(this.container);
	
	const queryInputs = list.find(".form-body-element.typeahead:not(.language-typeahead)");
	if (queryInputs.length>0) {
		queryInputs.focus();
		return;
	}

	const strictVocabHasFreetext = list.find("input[type='radio']").length>0 && list.find("input[type='text']").length>0;
	if (strictVocabHasFreetext) {
		list.find("input[type='text']").focus();
		return;
	}
		
	$.ajax({
        url: _this.options.newRowUrl,
        type: "GET",
        data: $.extend(true, { 
			path: _this.options.propertyName
			}, data),
        dataType: "html",
        success: function(data) {
        	let r = $(data);
        	if (preNewRowCallback!==null && preNewRowCallback!==undefined && typeof preNewRowCallback==='function') {
        		preNewRowCallback(r);
        	}
        	_this.addNewEntry(r);
        	if (_this.options.newRowCallback!==null && _this.options.newRowCallback!==undefined && 
        			typeof _this.options.newRowCallback==='function') {
        		_this.options.newRowCallback(r);
        	}
        	
        	if (_this.options.owner!=undefined && _this.options.owner!=null) {
				_this.options.owner.handleInputChange(r);
			}
        },
        error: function(textStatus) { }
	});
};

ValueList.prototype.addNewEntry = function(item) {
	//this.container.append(item);
	this.container.children(this.options.invalidFeedbackSelector).before(item);
	this.sort();
}

ValueList.prototype.removeAll = function() {
	const list = $(this.container);
	
	this.clear(list, this.options.listItemSelector, true);
	this.clear(list, this.options.listReadonlyItemSelector, true);
	
	this.sort();
	if (this.options.owner!=undefined && this.options.owner!=null) {
		this.options.owner.handleInputChange(list);
	}
};

ValueList.prototype.clearAll = function() {
	const list = $(this.container);
	
	this.clear(list, this.options.listItemSelector);
	this.clear(list, this.options.listReadonlyItemSelector);
	
	this.sort();
	if (this.options.owner!=undefined && this.options.owner!=null) {
		this.options.owner.handleInputChange(list);
	}
};

ValueList.prototype.clear = function(list, selector, forceRemove) {
	const _this = this;
	list.find(selector).each(function() {
		// If list item has remove button -> trigger remove
		if (forceRemove || $(this).find(".btn-valuelist-push-remove").length>0) {
			_this.removeEntry(this, selector);
		}
		// -> uncheck selected radio
		else if ($(this).find(":radio").length>0) {
			$(this).find(":radio").prop("checked", false);
			// Freetext entry -> remove
			if ($(this).find("input[type='text']").length>0) {
				_this.removeEntry(this, selector);
			}
		}
		// -> uncheck all checkboxes
		else if ($(this).find(":checkbox").length>0) {
			$(this).find(":checkbox").prop("checked", false);
			// Freetext entry -> remove
			if ($(this).find("input[type='text']").length>0) {
				_this.removeEntry(this, selector);
			}
		} 
		// -> remove list item anyway if nothing else applied 
		else {
			_this.removeEntry(this, selector);
		}
	});
}

ValueList.prototype.removeEntry = function(btn, selector, addNewIfEmpty) {
	var _this = this;
	
	let container = $(btn).closest(".property-value-list");
	
	if (selector==undefined) {
		selector = this.options.listItemSelector;
	}
	$(btn).closest(selector).remove();	
	
	if (addNewIfEmpty) {
		this.triggerAddListElementIfListEmpty();
	}
	
	if (_this.options.owner!=undefined && _this.options.owner!=null) {
		_this.options.owner.handleInputChange(container);
	}
	this.sort();
};

ValueList.prototype.pushEntryUp = function(btn) {
	var _this = this;
	var prevEntry = $(btn).closest(this.options.listItemSelector).prev();
	
	if (prevEntry.length>0) {
		prevEntry.before($(btn).closest(this.options.listItemSelector).detach());
		if (_this.options.owner!=undefined && _this.options.owner!=null) {
			_this.options.owner.handleInputChange(btn);
		}
		this.sort();
	}
};

ValueList.prototype.pushEntryDown = function(btn) {
	var _this = this;
	var nextEntry = $(btn).closest(this.options.listItemSelector).next();
	
	if (nextEntry.length>0) {
		nextEntry.after($(btn).closest(this.options.listItemSelector).detach());		
		if (_this.options.owner!=undefined && _this.options.owner!=null) {
			_this.options.owner.handleInputChange(btn);
		}
		this.sort();
	}
};