let definitionTable;
$(document).ready(function() {
	definitionTable = new DefinitionTable({
		url: __util.composeUrl("api/v1/" + $("#entity-table").data("api-url")),
		definitionType: $("#entity-table").data("definition-type")
	});
});


class DefinitionTable extends BaseTable {
	constructor(options) {
		super($.extend(true, {
				containerSelector: "#entity-table-container",
				selector: "#entity-table",
				initMaxColumns: -1,
				includeExportButtons: true,
				includeSearchPane: true,
				clickRowEvent: true,
				buttons: [],
				definitionType: "entityDefinitions"
			}, options),
	        	[
					"model.generic.state.system",
					"model.generic.state.remote",
					"model.generic.state.local"
            	]
	        );
        
        const _this = this;
        this.initTranslations(function() {
			_this.applyBaseSettings();
            _this.createTable();
        });
    }
	
	handleRowClick(data) {
		window.location = __util.composeUrl(this.options.definitionType + "/" + data.name + "/");
	}
	
	renderSpecialColumn(special, row, type, val, meta) {
		let result = "";
		if (type=="display") {
			result += row.remote ? '<span class="badge bg-primary">' + __translator.translate("model.generic.state.remote") + '</span> '
			                     : '<span class="badge bg-primary">' + __translator.translate("model.generic.state.local") + '</span> ';        
			result += row.system ? '<span class="badge bg-info">' + __translator.translate("model.generic.state.system") + '</span> ' : ' ';
		} else {
			result += row.remote ? __translator.translate("model.generic.state.remote") + ' '
			                     : __translator.translate("model.generic.state.local") + ' ';        
			result += row.system ? __translator.translate("model.generic.state.system") + ' ' : ' ';
		}
		return result;
	}
};