/*
 * Decompiled with CFR 0.152.
 */
package de.uniba.minf.registry.view.model;

import de.uniba.minf.registry.model.Property;
import de.uniba.minf.registry.model.PropertyValue;
import de.uniba.minf.registry.model.TextPropertyValue;
import de.uniba.minf.registry.model.definition.PropertyDefinition;
import de.uniba.minf.registry.view.model.BasePropertyViewItem;
import de.uniba.minf.registry.view.model.VocabularyPropertyViewItem;
import java.util.ArrayList;
import java.util.List;

public class SimplePropertyViewItem
extends BasePropertyViewItem {
    private VocabularyPropertyViewItem langPropertyViewItem;

    public SimplePropertyViewItem(PropertyDefinition definition, Property property) {
        super(definition, property);
    }

    public SimplePropertyViewItem(PropertyDefinition definition, Property property, VocabularyPropertyViewItem langPropertyViewItem) {
        super(definition, property);
        this.langPropertyViewItem = langPropertyViewItem;
    }

    public String getValueAsText() {
        if (this.getProperty() == null || this.getProperty().getValue() == null) {
            return null;
        }
        return this.getProperty().getValue().asText();
    }

    public List<PropertyValue> valuesAsList() {
        if (this.getProperty() != null && this.getProperty().getValue() != null) {
            return this.getProperty().valuesAsList();
        }
        return new ArrayList<PropertyValue>(1);
    }

    public List<String> valuesAsStringList() {
        return this.valuesAsList().stream().map(v -> v.asText()).toList();
    }

    public List<PropertyValue> valuesAsList(boolean includeEmptyPlaceholder) {
        if (!includeEmptyPlaceholder || this.getProperty() != null && this.getProperty().getValue() != null) {
            return this.valuesAsList();
        }
        ArrayList<PropertyValue> emptyValuePlaceholderList = new ArrayList<PropertyValue>(1);
        emptyValuePlaceholderList.add((PropertyValue)new TextPropertyValue(""));
        return emptyValuePlaceholderList;
    }

    public VocabularyPropertyViewItem getLangPropertyViewItem() {
        return this.langPropertyViewItem;
    }

    public void setLangPropertyViewItem(VocabularyPropertyViewItem langPropertyViewItem) {
        this.langPropertyViewItem = langPropertyViewItem;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SimplePropertyViewItem)) {
            return false;
        }
        SimplePropertyViewItem other = (SimplePropertyViewItem)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        VocabularyPropertyViewItem this$langPropertyViewItem = this.getLangPropertyViewItem();
        VocabularyPropertyViewItem other$langPropertyViewItem = other.getLangPropertyViewItem();
        return !(this$langPropertyViewItem == null ? other$langPropertyViewItem != null : !this$langPropertyViewItem.equals(other$langPropertyViewItem));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SimplePropertyViewItem;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        VocabularyPropertyViewItem $langPropertyViewItem = this.getLangPropertyViewItem();
        result = result * 59 + ($langPropertyViewItem == null ? 43 : $langPropertyViewItem.hashCode());
        return result;
    }

    public String toString() {
        return "SimplePropertyViewItem(super=" + super.toString() + ", langPropertyViewItem=" + this.getLangPropertyViewItem() + ")";
    }
}

