/*
 * Decompiled with CFR 0.152.
 */
package de.uniba.minf.registry.view.helper;

import de.uniba.minf.registry.model.Property;
import de.uniba.minf.registry.model.PropertyValue;
import de.uniba.minf.registry.model.definition.PropertyDefinition;
import de.uniba.minf.registry.view.helper.PropertyPreviewHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class PropertyPreviewHelper {
    private static PropertyPreviewHelper singleton = null;

    private PropertyPreviewHelper() {
    }

    public static PropertyPreviewHelper get() {
        if (singleton == null) {
            singleton = new PropertyPreviewHelper();
        }
        return singleton;
    }

    public List<PreviewProperty> extractSubproperties(List<PropertyDefinition> propertyDefinitions, List<Property> properties) {
        ArrayList<PreviewProperty> previewProperties = new ArrayList<PreviewProperty>();
        for (PropertyDefinition def : propertyDefinitions) {
            for (Property prop : properties) {
                if (!prop.getLabel().equals(def.getName())) continue;
                previewProperties.add(new PreviewProperty(this, prop, prop.getValue()));
            }
        }
        return previewProperties;
    }

    public String getDisplayString(List<PreviewProperty> previewProperties, String defaultText, Locale locale) {
        if (previewProperties == null || previewProperties.isEmpty()) {
            return defaultText;
        }
        StringBuilder displayBldr = new StringBuilder();
        for (PreviewProperty p : previewProperties) {
            List<Object> propertyDisplayValues;
            if (p.getValue() == null || p.getValue().valuesAsList().isEmpty()) continue;
            boolean langFilterMode = p.getValue().valuesAsList().stream().filter(v -> v.getLang() != null && !v.getLang().isBlank()).findAny().isPresent();
            if (!langFilterMode) {
                propertyDisplayValues = p.getValue().valuesAsList().stream().map(v -> v.asText()).toList();
            } else {
                propertyDisplayValues = new ArrayList();
                PropertyValue firstValue = null;
                for (PropertyValue v2 : p.getValue().valuesAsList()) {
                    if (firstValue == null) {
                        firstValue = v2;
                    }
                    if (v2.getLang() != null && !v2.getLang().isBlank()) {
                        if (!v2.getLang().equals(locale.getISO3Language())) continue;
                        propertyDisplayValues.add(v2.asText());
                        continue;
                    }
                    propertyDisplayValues.add(v2.asText());
                }
                if (propertyDisplayValues.isEmpty() && firstValue != null) {
                    propertyDisplayValues.add(firstValue.asText());
                }
            }
            for (int i = 0; i < propertyDisplayValues.size(); ++i) {
                if (displayBldr.length() > 0) {
                    displayBldr.append("; ");
                }
                displayBldr.append((String)propertyDisplayValues.get(i));
                if (i >= propertyDisplayValues.size() - 1) continue;
                displayBldr.append("; ");
            }
        }
        return displayBldr.toString();
    }
}

