/*
 * Decompiled with CFR 0.152.
 */
package de.uniba.minf.registry.view.controller;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.uniba.minf.registry.model.vocabulary.VocabularyDefinition;
import de.uniba.minf.registry.pojo.VocabularyDefinitionPojo;
import de.uniba.minf.registry.pojo.converter.VocabularyDefinitionConverter;
import de.uniba.minf.registry.repository.VocabularyDefinitionRepository;
import de.uniba.minf.registry.view.controller.BaseViewController;
import de.unibamberg.minf.core.web.controller.ResourceNotFoundException;
import java.util.Locale;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@RequestMapping(value={"/vocabularyDefinitions"})
public class VocabularyDefinitionViewController
extends BaseViewController {
    @Autowired
    private VocabularyDefinitionRepository vocabularyDefinitionRepo;
    @Autowired
    private VocabularyDefinitionConverter vocabularyDefinitionConverter;
    @Autowired
    @Qualifier(value="yamlMapper")
    private ObjectMapper yamlMapper;
    @Autowired
    @Qualifier(value="jsonMapper")
    private ObjectMapper jsonMapper;

    public VocabularyDefinitionViewController() {
        super("vocabularyDefinitions");
    }

    @GetMapping
    public String showDatamodels(Model model, Locale locale) {
        model.addAttribute("apiUrlPrefix", (Object)"def/vocabularies");
        model.addAttribute("definitionType", (Object)"vocabularyDefinitions");
        return "definitions/list";
    }

    @GetMapping(value={"/{definition}/"})
    public String showDefinition(@PathVariable(value="definition") String definition, Model model, Locale locale) throws JsonProcessingException {
        Optional<VocabularyDefinition> d = Optional.ofNullable(this.vocabularyDefinitionRepo.findCurrentByName(definition));
        if (d.isEmpty()) {
            throw new ResourceNotFoundException();
        }
        VocabularyDefinitionPojo p = this.vocabularyDefinitionConverter.convertPojo(d.get());
        model.addAttribute("def", (Object)p);
        model.addAttribute("definitionType", (Object)"vocabularyDefinitions");
        model.addAttribute("jsonDatamodel", (Object)this.jsonMapper.writeValueAsString((Object)d.get()));
        model.addAttribute("yamlDatamodel", (Object)this.yamlMapper.writeValueAsString((Object)d.get()));
        return "definitions/definition";
    }
}

