/*
 * Decompiled with CFR 0.152.
 */
package de.uniba.minf.registry.view.controller;

import de.uniba.minf.registry.view.controller.BaseViewController;
import jakarta.servlet.http.HttpServletRequest;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseStatus;

public class ViewExceptionHandler
extends BaseViewController {
    public static final String DEFAULT_ERROR_VIEW = "error";

    public ViewExceptionHandler() {
        super(DEFAULT_ERROR_VIEW);
    }

    @ExceptionHandler(value={Exception.class})
    public String defaultErrorHandler(Model model, HttpServletRequest req, Exception e) throws Exception {
        if (AnnotationUtils.findAnnotation(e.getClass(), ResponseStatus.class) != null) {
            throw e;
        }
        model.addAttribute("exception", (Object)e);
        model.addAttribute("url", (Object)req.getRequestURL());
        model.addAttribute("_auth", (Object)this.authInfoHelper.getAuth());
        model.addAttribute("status", (Object)500);
        return DEFAULT_ERROR_VIEW;
    }
}

