/*
 * Decompiled with CFR 0.152.
 */
package de.uniba.minf.registry.view.controller;

import de.uniba.minf.auth.spring.mvc.model.AuthPojo;
import de.uniba.minf.core.rest.exception.ApiItemNotFoundException;
import de.uniba.minf.core.rest.exception.ApiUnauthorizedException;
import de.uniba.minf.registry.repository.UserRepository;
import de.uniba.minf.registry.view.controller.BaseViewController;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@RequestMapping(value={"/user"})
public class UserController
extends BaseViewController {
    @Autowired
    private UserRepository userRepo;

    public UserController() {
        super("user");
    }

    @GetMapping
    public String redirectHome(HttpServletResponse response) throws IOException {
        response.sendRedirect("profile");
        return null;
    }

    @GetMapping(value={"/profile"})
    public String showProfile(Model model, HttpServletResponse response) throws ApiUnauthorizedException, ApiItemNotFoundException, IOException {
        AuthPojo authPojo = this.authInfoHelper.getAuth();
        if (authPojo.getUserId() == null) {
            response.sendRedirect("/startLogin");
            return null;
        }
        Optional user = this.userRepo.findById((Object)authPojo.getUserId());
        if (!user.isPresent()) {
            throw new ApiItemNotFoundException(authPojo.getUserId(), "user");
        }
        model.addAttribute("user", user.get());
        return "user/profile";
    }

    @GetMapping(value={"/tokens"})
    public String showTokens(Model model, HttpServletResponse response) throws ApiUnauthorizedException, ApiItemNotFoundException, IOException {
        AuthPojo authPojo = this.authInfoHelper.getAuth();
        if (authPojo.getUserId() == null) {
            response.sendRedirect("/startLogin");
            return null;
        }
        Optional user = this.userRepo.findById((Object)authPojo.getUserId());
        if (!user.isPresent()) {
            throw new ApiItemNotFoundException(authPojo.getUserId(), "user");
        }
        model.addAttribute("user", user.get());
        return "user/tokens";
    }

    @GetMapping(value={"/groups"})
    public String showUserGroups(Model model, HttpServletResponse response) throws ApiUnauthorizedException, ApiItemNotFoundException, IOException {
        AuthPojo authPojo = this.authInfoHelper.getAuth();
        if (authPojo.getUserId() == null) {
            response.sendRedirect("/startLogin");
            return null;
        }
        Optional user = this.userRepo.findById((Object)authPojo.getUserId());
        if (!user.isPresent()) {
            throw new ApiItemNotFoundException(authPojo.getUserId(), "user");
        }
        return "user/groups";
    }
}

