/*
 * Decompiled with CFR 0.152.
 */
package de.uniba.minf.registry.view.controller;

import de.uniba.minf.registry.model.definition.EntityDefinition;
import de.uniba.minf.registry.model.entity.Entity;
import de.uniba.minf.registry.view.controller.base.BaseEntityViewController;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Locale;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.server.ResponseStatusException;

@Controller
@RequestMapping(value={"/_source"})
public class SourceViewController
extends BaseEntityViewController {
    private static final Logger log = LoggerFactory.getLogger(SourceViewController.class);

    public SourceViewController() {
        super("_source");
    }

    @GetMapping(value={"{uniqueId}/"})
    public String showSource(@PathVariable(value="uniqueId") String uniqueId, Model model, Locale locale, HttpServletResponse response) throws IOException, URISyntaxException {
        Optional entity = this.entityService.findById(uniqueId, true);
        if (!entity.isPresent()) {
            entity = this.entityService.findLatestByEntityId(uniqueId, true);
        }
        if (!entity.isPresent()) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, "~entity not found");
        }
        EntityDefinition entityDefinition = this.entityDefinitionService.findCurrentByName(((Entity)entity.get()).getDefinitionName(), false);
        this.editEntity((Entity)entity.get(), entityDefinition, model, locale);
        return "entities/edit_source";
    }
}

