/*
 * Decompiled with CFR 0.152.
 */
package de.uniba.minf.registry.view.controller;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.uniba.minf.registry.model.definition.BaseDefinition;
import de.uniba.minf.registry.model.definition.EntityDefinition;
import de.uniba.minf.registry.pojo.EntityDefinitionPojo;
import de.uniba.minf.registry.pojo.converter.EntityDefinitionConverter;
import de.uniba.minf.registry.repository.EntityDefinitionRepository;
import de.uniba.minf.registry.repository.EntityRepository;
import de.uniba.minf.registry.view.controller.BaseViewController;
import de.unibamberg.minf.core.web.controller.ResourceNotFoundException;
import java.util.Locale;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@RequestMapping(value={"/entityDefinitions"})
public class EntityDefinitionViewController
extends BaseViewController {
    @Autowired
    private EntityDefinitionRepository entityDefinitionRepo;
    @Autowired
    private EntityDefinitionConverter entityDefinitionConverter;
    @Autowired
    private EntityRepository entityRepo;
    @Autowired
    @Qualifier(value="yamlMapper")
    private ObjectMapper yamlMapper;
    @Autowired
    @Qualifier(value="jsonMapper")
    private ObjectMapper jsonMapper;

    public EntityDefinitionViewController() {
        super("entityDefinitions");
    }

    @GetMapping
    public String listDefinitions(Model model, Locale locale) {
        model.addAttribute("apiUrlPrefix", (Object)"def/entities");
        model.addAttribute("definitionType", (Object)"entityDefinitions");
        return "definitions/list";
    }

    @GetMapping(value={"/{definition}/"})
    public String showDefinition(@PathVariable(value="definition") String definition, Model model, Locale locale) throws JsonProcessingException {
        Optional<EntityDefinition> d = Optional.ofNullable(this.entityDefinitionRepo.findCurrentByName(definition));
        if (d.isEmpty()) {
            throw new ResourceNotFoundException();
        }
        EntityDefinitionPojo p = (EntityDefinitionPojo)this.entityDefinitionConverter.convertPojo((BaseDefinition)d.get());
        p.setEntryCount(this.entityRepo.countByDefinition(definition, this.authInfoHelper.getAuth().isAuth()));
        model.addAttribute("def", (Object)p);
        model.addAttribute("definitionType", (Object)"entityDefinitions");
        model.addAttribute("jsonDatamodel", (Object)this.jsonMapper.writeValueAsString((Object)d.get()));
        model.addAttribute("yamlDatamodel", (Object)this.yamlMapper.writeValueAsString((Object)d.get()));
        return "definitions/definition";
    }
}

