/*
 * Decompiled with CFR 0.152.
 */
package de.uniba.minf.registry.service;

import de.uniba.minf.registry.model.BaseDefinedObject;
import de.uniba.minf.registry.model.BlockedPropertyValue;
import de.uniba.minf.registry.model.CompositePropertyImpl;
import de.uniba.minf.registry.model.Property;
import de.uniba.minf.registry.model.PropertyImpl;
import de.uniba.minf.registry.model.PropertyValue;
import de.uniba.minf.registry.model.PropertyValueList;
import de.uniba.minf.registry.model.definition.BaseDefinition;
import de.uniba.minf.registry.model.definition.EntityDefinition;
import de.uniba.minf.registry.model.definition.PropertyDefinition;
import de.uniba.minf.registry.model.entity.Entity;
import de.uniba.minf.registry.model.helper.PropertyDefinitionHelper;
import de.uniba.minf.registry.service.EntityCompositingService;
import de.uniba.minf.registry.service.EntityCompositingServiceImpl;
import de.uniba.minf.registry.service.EntityDefinitionService;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class EntityCompositingServiceImpl
implements EntityCompositingService {
    @Autowired
    private EntityDefinitionService entityDefinitionService;

    public Entity composeLayers(Entity e) {
        return this.composeLayers(e, CompositionMode.LOADING);
    }

    public Entity composeLayers(Entity e, CompositionMode compositionMode) {
        if (e.getLayers() == null || e.getLayers().isEmpty()) {
            return e;
        }
        EntityDefinition ed = this.entityDefinitionService.findByNameAndVersion(e.getDefinitionName(), e.getDefinitionVersion(), true);
        this.composeLayers(e, ed, compositionMode);
        return e;
    }

    public Collection<Entity> composeLayers(Collection<Entity> entities) {
        return this.composeLayers(entities, CompositionMode.LOADING);
    }

    public Collection<Entity> composeLayers(Collection<Entity> entities, CompositionMode compositionMode) {
        HashMap<CallSite, EntityDefinition> definitionMap = new HashMap<CallSite, EntityDefinition>();
        for (Entity e : entities) {
            EntityDefinition ed;
            if (e.getLayers() == null || e.getLayers().isEmpty()) continue;
            String definitionHash = e.getDefinitionName() + "#" + e.getDefinitionVersion();
            if (definitionMap.containsKey(definitionHash)) {
                ed = (EntityDefinition)definitionMap.get(definitionHash);
            } else {
                ed = this.entityDefinitionService.findByNameAndVersion(e.getDefinitionName(), e.getDefinitionVersion(), true);
                definitionMap.put((CallSite)((Object)definitionHash), ed);
            }
            this.composeLayers(e, ed, compositionMode);
        }
        return entities;
    }

    public void removeLayers(Entity e) {
        if (e.getLayersEntityIds() == null || e.getLayersEntityIds().isEmpty() || e.getProperties() == null || e.getProperties().isEmpty()) {
            return;
        }
        ArrayList<Object> entityProperties = new ArrayList<Object>();
        for (Property p : e.getProperties()) {
            if (!CompositePropertyImpl.class.isAssignableFrom(p.getClass())) {
                entityProperties.add(p);
                continue;
            }
            CompositePropertyImpl pComp = (CompositePropertyImpl)CompositePropertyImpl.class.cast(p);
            if (!pComp.isLayersOnly() && pComp.getPreferredLayerEntityId() == null) {
                PropertyImpl pFlat = new PropertyImpl();
                pFlat.setDefinition(pComp.getDefinition());
                pFlat.setLabel(pComp.getLabel());
                pFlat.setProperties(pComp.getProperties());
                if (pComp.getDefinition().isVocabulary()) {
                    pFlat.setValue(this.retainVocabularyValuesNotInLayers(pComp, e.getEntityId(), ((Property)pComp.getLayeredPropertyMap().get(e.getEntityId())).getValue().valuesAsList()));
                } else {
                    pFlat.setValue(((Property)pComp.getLayeredPropertyMap().get(e.getEntityId())).getValue());
                }
                pFlat.setPropertyKeyOrder(pComp.getPropertyKeyOrder());
                entityProperties.add(pFlat);
                continue;
            }
            if (pComp.getPreferredLayerEntityId() == null) continue;
            pComp.setValue(null);
            pComp.setProperties(null);
            entityProperties.add(pComp);
        }
        e.setProperties(entityProperties);
    }

    protected void composeProperty(String entityId, CompositePropertyImpl layeredProperty) {
        this.composeProperty(entityId, layeredProperty, CompositionMode.LOADING);
    }

    private void composeLayers(Entity e, EntityDefinition ed, CompositionMode compositionMode) {
        this.checkAndMergeWithDefinitions(e, ed);
        List<CompositePropertyImpl> layeredProperties = ed.getAllProperties().stream().map(pd -> this.collectPropertyLayers(e, pd)).filter(p -> p != null).toList();
        for (CompositePropertyImpl layeredProperty : layeredProperties) {
            this.composeProperty(e.getEntityId(), layeredProperty, compositionMode);
        }
        e.setProperties(new ArrayList<CompositePropertyImpl>(layeredProperties));
    }

    private PropertyValue retainVocabularyValuesNotInLayers(CompositePropertyImpl layeredProperty, String entityId, List<PropertyValue> entityValues) {
        List layerValues = this.collectVocabularyValuesForLayers(layeredProperty.getLayeredPropertyMap(), entityId, layeredProperty.blockedValues());
        ArrayList<PropertyValue> retainedValues = new ArrayList<PropertyValue>(entityValues.stream().filter(ev -> layerValues.stream().noneMatch(lv -> lv.asText().equals(ev.asText()))).toList());
        return this.createPropertyValueFromValueList(retainedValues, layeredProperty.getPropertyKeyOrder());
    }

    private List<PropertyValue> collectVocabularyValuesForLayers(Map<String, Property> layeredPropertyMap, String entityId, List<String> blockedValues) {
        ArrayList<PropertyValue> collectedValues = new ArrayList<PropertyValue>();
        layeredPropertyMap.entrySet().stream().filter(p -> !((String)p.getKey()).equals(entityId)).flatMap(p -> ((Property)p.getValue()).getValue().valuesAsList().stream()).filter(v -> !collectedValues.contains(v) && !blockedValues.contains(v.asText())).forEach(collectedValues::add);
        return collectedValues;
    }

    protected void composeProperty(String entityId, CompositePropertyImpl layeredProperty, CompositionMode compositionMode) {
        if (layeredProperty.getDefinition().isVocabulary()) {
            ArrayList collectedValues = new ArrayList();
            Property manualLayer = null;
            List blockedValues = layeredProperty.blockedValues();
            if (layeredProperty.getLayeredPropertyMap().containsKey(entityId)) {
                manualLayer = (Property)layeredProperty.getLayeredPropertyMap().get(entityId);
            }
            layeredProperty.getLayeredPropertyMap().entrySet().stream().filter(p -> !((String)p.getKey()).equals(entityId)).flatMap(p -> ((Property)p.getValue()).getValue().valuesAsList().stream()).filter(v -> !collectedValues.contains(v) && !blockedValues.contains(v.asText())).forEach(collectedValues::add);
            if (compositionMode.equals((Object)CompositionMode.PERSISTING) && manualLayer != null) {
                for (PropertyValue collectedValue : collectedValues) {
                    if (!manualLayer.valuesAsList().stream().filter(v -> v.asText().equals(collectedValue.asText())).findAny().isEmpty()) continue;
                    manualLayer.addValue((PropertyValue)new BlockedPropertyValue(collectedValue.asText()));
                }
                layeredProperty.setPropertyKeyOrder(manualLayer.getValue().valuesAsList().stream().filter(v -> !BlockedPropertyValue.class.isAssignableFrom(v.getClass())).map(v -> v.asText()).toList());
                layeredProperty.setValue(manualLayer.getValue());
                layeredProperty.getLayeredPropertyMap().put(entityId, manualLayer);
            } else {
                if (manualLayer != null) {
                    manualLayer.valuesAsList().stream().filter(v -> !collectedValues.contains(v)).forEach(collectedValues::add);
                }
                layeredProperty.setValue(this.createPropertyValueFromValueList(collectedValues, layeredProperty.getPropertyKeyOrder()));
            }
        } else {
            Property topProp = null;
            if (layeredProperty.getPreferredLayerEntityId() != null && layeredProperty.getLayeredPropertyMap().containsKey(layeredProperty.getPreferredLayerEntityId())) {
                topProp = (Property)layeredProperty.getLayeredPropertyMap().get(layeredProperty.getPreferredLayerEntityId());
            }
            if (topProp == null) {
                topProp = layeredProperty.getLayeredPropertyMap().values().stream().findFirst().orElse(null);
            }
            layeredProperty.setProperties(topProp.getProperties());
            layeredProperty.setValue(topProp.getValue());
        }
    }

    private PropertyValue createPropertyValueFromValueList(List<PropertyValue> collectedValues, List<String> propertyKeyOrder) {
        if (collectedValues.size() == 1) {
            return collectedValues.get(0);
        }
        if (collectedValues.size() > 1) {
            if (propertyKeyOrder != null && !propertyKeyOrder.isEmpty()) {
                HashMap<String, Integer> indexMap = new HashMap<String, Integer>();
                for (int i = 0; i < propertyKeyOrder.size(); ++i) {
                    indexMap.put(propertyKeyOrder.get(i), i);
                }
                Collections.sort(collectedValues, (item1, item2) -> {
                    Integer index1 = indexMap.getOrDefault(item1.asText(), Integer.MAX_VALUE);
                    Integer index2 = indexMap.getOrDefault(item2.asText(), Integer.MAX_VALUE);
                    return Integer.compare(index1, index2);
                });
            }
            return new PropertyValueList(collectedValues);
        }
        return null;
    }

    protected CompositePropertyImpl collectPropertyLayers(Entity entity, PropertyDefinition pd) {
        Optional<Property> entityProperty;
        CompositePropertyImpl layeredProperties = null;
        if (entity.getProperties() != null && (entityProperty = entity.getProperties().stream().filter(p -> p.getDefinition().equals((Object)pd)).findAny()).isPresent()) {
            layeredProperties = this.createLayeredPropertyFromProperty(entity.getEntityId(), entityProperty.get(), pd);
        }
        for (Entity layer : entity.getLayers().values()) {
            Optional<Object> lProp = layer.getProperties() == null ? Optional.empty() : layer.getProperties().stream().filter(p -> p.getDefinition().equals((Object)pd)).findFirst();
            if (!lProp.isPresent()) continue;
            if (layeredProperties == null) {
                layeredProperties = this.createLayersOnlyProperty(pd);
            }
            layeredProperties.getLayeredPropertyMap().put(layer.getEntityId(), (Property)lProp.get());
        }
        return layeredProperties;
    }

    public CompositePropertyImpl createLayeredPropertyFromProperty(String entityId, Property property, PropertyDefinition pd) {
        CompositePropertyImpl composite = new CompositePropertyImpl();
        composite.setLabel(property.getLabel());
        composite.setDefinition(pd);
        composite.setLayeredPropertyMap(new LinkedHashMap());
        if (CompositePropertyImpl.class.isAssignableFrom(property.getClass())) {
            composite.setPreferredLayerEntityId(((CompositePropertyImpl)CompositePropertyImpl.class.cast(property)).getPreferredLayerEntityId());
            composite.setLayersOnly(true);
        } else {
            composite.getLayeredPropertyMap().put(entityId, property);
            composite.setValue(property.getValue());
            composite.setProperties(property.getProperties());
        }
        return composite;
    }

    public CompositePropertyImpl createLayersOnlyProperty(PropertyDefinition pd) {
        CompositePropertyImpl composite = new CompositePropertyImpl();
        composite.setLabel(pd.getName());
        composite.setDefinition(pd);
        composite.setLayersOnly(true);
        composite.setLayeredPropertyMap(new LinkedHashMap());
        return composite;
    }

    private void checkAndMergeWithDefinitions(Entity e, EntityDefinition ed) {
        if (e.getPropertyDefinitions() == null || e.getPropertyDefinitions().isEmpty()) {
            PropertyDefinitionHelper.mergeWithDefinition((BaseDefinedObject)e, (BaseDefinition)ed, (boolean)true);
        }
        if (e.getLayers() != null && !e.getLayers().isEmpty()) {
            e.getLayers().values().stream().forEach(l -> this.checkAndMergeWithDefinitions(l, ed));
        }
    }
}

