/*
 * Decompiled with CFR 0.152.
 */
package de.uniba.minf.registry.repository;

import de.uniba.minf.registry.model.entity.Entity;
import de.uniba.minf.registry.repository.EntityRepositoryCustom;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoOperations;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.aggregation.Aggregation;
import org.springframework.data.mongodb.core.aggregation.AggregationOperation;
import org.springframework.data.mongodb.core.aggregation.AggregationResults;
import org.springframework.data.mongodb.core.aggregation.ProjectionOperation;
import org.springframework.data.mongodb.core.index.IndexDefinition;
import org.springframework.data.mongodb.core.index.TextIndexDefinition;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.TextCriteria;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.data.mongodb.core.query.UpdateDefinition;

public class EntityRepositoryCustomImpl
implements EntityRepositoryCustom,
InitializingBean {
    @Autowired
    private MongoTemplate mongoTemplate;
    @Autowired
    private MongoOperations mongoOperations;

    public void afterPropertiesSet() throws Exception {
        this.mongoOperations.indexOps(Entity.class).ensureIndex((IndexDefinition)TextIndexDefinition.forAllFields());
    }

    public Optional<Entity> findLatestByEntityId(String entityId) {
        return this.findEarliestOrLatestByEntityId(entityId, Sort.Direction.DESC);
    }

    public Optional<Entity> findEarliestByEntityId(String entityId) {
        return this.findEarliestOrLatestByEntityId(entityId, Sort.Direction.ASC);
    }

    public Collection<Entity> findLatestByEntityIds(List<String> entityIds) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"entityId").in(entityIds).and("nextVersionUniqueId").isNull().and("deleted").is((Object)false));
        return this.mongoTemplate.find(query, Entity.class);
    }

    public List<String> findAllEntityIds() {
        ProjectionOperation projectionOperation = Aggregation.project((String[])new String[]{"entityId"});
        Aggregation aggregation = Aggregation.newAggregation((AggregationOperation[])new AggregationOperation[]{projectionOperation});
        AggregationResults aggregationResults = this.mongoTemplate.aggregate(aggregation, "entity", Entity.class);
        return aggregationResults.getMappedResults().stream().map(Entity::getEntityId).toList();
    }

    public Collection<Entity> findAllLatest(boolean includeDrafts) {
        if (includeDrafts) {
            return this.findLatestByCriteria(Criteria.where((String)"template").is((Object)false));
        }
        return this.findLatestByCriteria(Criteria.where((String)"template").is((Object)false).and("draft").is((Object)false));
    }

    public Collection<Entity> findLatestByDefinition(String definition, boolean includeDrafts) {
        if (includeDrafts) {
            return this.findLatestByCriteria(Criteria.where((String)"definitionName").is((Object)definition).and("template").is((Object)false));
        }
        return this.findLatestByCriteria(Criteria.where((String)"definitionName").is((Object)definition).and("template").is((Object)false).and("draft").is((Object)false));
    }

    public Collection<Entity> findLatestByCriteria(Criteria criteria) {
        Query query = new Query();
        if (criteria != null) {
            query.addCriteria((CriteriaDefinition)criteria);
        }
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"deleted").is((Object)false));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"nextVersionUniqueId").isNull());
        return this.mongoTemplate.find(query, Entity.class);
    }

    public long countLatestByCriteria(Criteria criteria) {
        Query query = new Query();
        if (criteria != null) {
            query.addCriteria((CriteriaDefinition)criteria);
        }
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"nextVersionUniqueId").isNull().and("deleted").is((Object)false));
        return this.mongoTemplate.count(query, Entity.class);
    }

    public Collection<Entity> findLatestByDefinitionAndQuery(String name, String query) {
        String[] queryTerms = query.split("\\s+");
        Query q = Query.query((CriteriaDefinition)Criteria.where((String)"definitionName").is((Object)name).and("template").is((Object)false).and("nextVersionUniqueId").isNull().and("deleted").is((Object)false));
        StringBuilder queryBuilder = new StringBuilder();
        for (int i = 0; i < queryTerms.length; ++i) {
            queryBuilder.append("\"").append(queryTerms[i]).append("\"");
            if (i >= queryTerms.length - 1) continue;
            queryBuilder.append(" AND ");
        }
        q.addCriteria((CriteriaDefinition)TextCriteria.forLanguage((String)"en").matching(queryBuilder.toString()));
        return this.mongoTemplate.find(q, Entity.class);
    }

    public void updateSourceInfo(Entity e) {
        this.mongoTemplate.update(Entity.class).matching((CriteriaDefinition)Criteria.where((String)"sourceEntityId").is((Object)e.getEntityId())).apply((UpdateDefinition)new Update().set("sourceLabel", e.get("short_title") == null ? null : e.get("short_title").getValue().asText())).all();
    }

    public void updateRelatedEntity(Collection<Entity> updateEntities, Entity relatedEntity) {
        if (updateEntities.isEmpty()) {
            return;
        }
        this.updateRelatedEntityIds(updateEntities.stream().map(Entity::getEntityId).toList(), relatedEntity);
    }

    public void updateRelatedEntityIds(Collection<String> updateEntityIds, Entity relatedEntity) {
        if (updateEntityIds.isEmpty()) {
            return;
        }
        this.mongoTemplate.update(Entity.class).matching((CriteriaDefinition)Criteria.where((String)"entityId").in(updateEntityIds)).apply((UpdateDefinition)new Update().set("relatedEntityCache." + relatedEntity.getEntityId(), (Object)relatedEntity)).all();
    }

    private Optional<Entity> findEarliestOrLatestByEntityId(String entityId, Sort.Direction direction) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"entityId").is((Object)entityId).and("deleted").is((Object)false));
        query.with(Sort.by((Sort.Direction)direction, (String[])new String[]{"creationInstant"}));
        return Optional.ofNullable((Entity)this.mongoTemplate.findOne(query, Entity.class));
    }

    public long countVersionsByEntityId(String entityId) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"entityId").is((Object)entityId).and("deleted").is((Object)false));
        return this.mongoTemplate.count(query, Entity.class);
    }

    public long countByDefinition(String definition, boolean includeDrafts) {
        return this.findLatestByDefinition(definition, includeDrafts).size();
    }

    public long countByImportId(String importId) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"importId").is((Object)importId).and("deleted").is((Object)false));
        return this.mongoTemplate.count(query, Entity.class);
    }

    public String findDefinitionNameById(String uniqueId) {
        Query q = Query.query((CriteriaDefinition)Criteria.where((String)"_id").is((Object)uniqueId));
        q.fields().include("definitionName");
        Entity e = (Entity)this.mongoTemplate.findOne(q, Entity.class);
        if (e != null) {
            return e.getDefinitionName();
        }
        return null;
    }

    public boolean getIsLatest(String uniqueId) {
        Query q = Query.query((CriteriaDefinition)Criteria.where((String)"_id").is((Object)uniqueId));
        q.fields().include("nextVersionUniqueId");
        Entity e = (Entity)this.mongoTemplate.findOne(q, Entity.class);
        return e != null && e.getNextVersionUniqueId() == null;
    }

    public Collection<Entity> findByImportId(String importId) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"importId").is((Object)importId));
        return this.mongoTemplate.find(query, Entity.class);
    }

    public long removeImportIdByImportId(String importId) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"importId").is((Object)importId));
        return this.mongoTemplate.updateMulti(query, (UpdateDefinition)new Update().unset("importId"), Entity.class).getModifiedCount();
    }
}

