/*
 * Decompiled with CFR 0.152.
 */
package de.uniba.minf.registry.pojo.converter.base;

import de.uniba.minf.registry.model.PersistedUser;
import de.uniba.minf.registry.model.definition.BaseDefinition;
import de.uniba.minf.registry.model.definition.HierarchicalPropertyDefinition;
import de.uniba.minf.registry.model.definition.PropertyDefinition;
import de.uniba.minf.registry.pojo.base.BaseDefinitionPojo;
import de.uniba.minf.registry.pojo.converter.base.BaseConverter;
import de.uniba.minf.registry.repository.UserRepository;
import java.util.Collection;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class BaseDefinitionConverter<T extends BaseDefinition, P extends BaseDefinitionPojo>
extends BaseConverter<T, P> {
    @Autowired
    private UserRepository userRepo;

    public P convertPojo(T d) {
        Optional u;
        BaseDefinitionPojo p = this.createPojo();
        p.setUniqueId(d.getUniqueId());
        p.setName(d.getName());
        p.setLabel(d.getName());
        p.setVersion(d.getVersion());
        p.setSystem(d.isSystem());
        p.setLatest(d.getNextVersionUniqueId() == null);
        p.setCreationInstant(d.getCreationInstant());
        p.setUserId(d.getUserUniqueId());
        p.setRemote(d.isRemote());
        if (d.getUserUniqueId() != null && (u = this.userRepo.findById((Object)d.getUserUniqueId())).isPresent()) {
            p.setUsername(((PersistedUser)u.get()).getUsername());
        }
        p.setFieldCount(this.countProperties(d));
        return (P)p;
    }

    protected abstract P createPojo();

    private int countProperties(T ed) {
        return this.countProperties((Collection)ed.getAllProperties());
    }

    private int countProperties(Collection<PropertyDefinition> pds) {
        int count = 0;
        for (PropertyDefinition pd : pds) {
            ++count;
            if (!pd.isHierarchical()) continue;
            count += this.countProperties((Collection)((HierarchicalPropertyDefinition)HierarchicalPropertyDefinition.class.cast(pd)).getProperties());
        }
        return count;
    }
}

