/*
 * Decompiled with CFR 0.152.
 */
package de.uniba.minf.registry.model.serialization;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import de.uniba.minf.auth.config.BaseUrl;
import de.uniba.minf.core.rest.model.Identifiable;
import de.uniba.minf.registry.RegistryConstants;
import de.uniba.minf.registry.model.ConfigurableEntity;
import de.uniba.minf.registry.model.DoublePropertyValue;
import de.uniba.minf.registry.model.IntegerPropertyValue;
import de.uniba.minf.registry.model.Property;
import de.uniba.minf.registry.model.PropertyList;
import de.uniba.minf.registry.model.PropertyValue;
import de.uniba.minf.registry.model.definition.PropertyDefinition;
import de.uniba.minf.registry.model.definition.SimplePropertyDefinition;
import de.uniba.minf.registry.model.definition.VocabularyPropertyDefinition;
import de.uniba.minf.registry.model.entity.Entity;
import de.uniba.minf.registry.model.serialization.exception.SerializationException;
import de.uniba.minf.registry.repository.EntityRepository;
import de.uniba.minf.registry.repository.VocabularyEntryRepository;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class EntitySerializer
extends StdSerializer<Identifiable> {
    private static final Logger log = LoggerFactory.getLogger(EntitySerializer.class);
    private static final long serialVersionUID = -6917667738353884153L;
    @Autowired
    private VocabularyEntryRepository vocabularyEntryRepository;
    @Autowired
    private EntityRepository entityRepository;
    private BaseUrl baseUrl;

    public EntitySerializer() {
        this(null);
    }

    public EntitySerializer(Class<Identifiable> c) {
        super(c);
    }

    public void serialize(Identifiable i, JsonGenerator gen, SerializerProvider provider) throws IOException {
        Entity e;
        String preferredLanguage = null;
        Map relatedEntitiesDisplayStrings = null;
        if (Entity.class.isAssignableFrom(i.getClass())) {
            e = (Entity)Entity.class.cast(i);
        } else if (ConfigurableEntity.class.isAssignableFrom(i.getClass())) {
            ConfigurableEntity ce = (ConfigurableEntity)ConfigurableEntity.class.cast(i);
            e = ce.getEntity();
            preferredLanguage = ce.getLang();
            relatedEntitiesDisplayStrings = ce.getEntityDisplayStrings();
        } else {
            return;
        }
        if (e.getPropertyDefinitions() == null || e.getPropertyDefinitions().isEmpty()) {
            String error = String.format("Entities must be merged with entity definition before serialization: %s, version: %s; aborting serialization", e.getDefinitionName() == null ? "NULL" : e.getDefinitionName(), e.getDefinitionVersion());
            log.error(error);
            throw new IOException((Throwable)new SerializationException(SerializationException.Direction.SERIALIZATION, e.getDefinitionName(), e.getDefinitionVersion(), error));
        }
        gen.writeStartObject();
        gen.writeStringField("entityId", e.getEntityId());
        gen.writeStringField("uniqueId", e.getUniqueId());
        if (e.getCreationInstant() != null) {
            gen.writeStringField("creation", RegistryConstants.SERIALIZATION_DATETIME_FORMATTER.format(e.getCreationInstant()));
        }
        gen.writeStringField("definition_name", e.getDefinitionName());
        if (e.getNextVersionUniqueId() != null) {
            gen.writeStringField("next_version", e.getNextVersionUniqueId());
            gen.writeBooleanField("current_version", false);
        } else {
            gen.writeBooleanField("current_version", true);
        }
        gen.writeNumberField("definition_version", e.getDefinitionVersion());
        gen.writeBooleanField("readOnly", e.isReadOnly());
        gen.writeBooleanField("published", !e.isDraft() && !e.isTemplate());
        gen.writeBooleanField("draft", e.isDraft());
        gen.writeBooleanField("template", e.isTemplate());
        gen.writeBooleanField("deleted", e.isDeleted());
        gen.writeBooleanField("composite", e.getLayersEntityIds() != null && !e.getLayersEntityIds().isEmpty());
        gen.writeBooleanField("imported", e.getSourceEntityId() != null);
        if (e.getSourceEntityId() != null) {
            gen.writeStringField("sourceId", e.getSourceEntityId());
        }
        if (e.getSourceLabel() != null) {
            gen.writeStringField("sourceLabel", e.getSourceLabel());
        }
        HashMap entityMap = new HashMap();
        try {
            gen.writeObjectFieldStart("properties");
            this.serializeProperties(gen, e.getProperties(), entityMap, preferredLanguage);
            gen.writeEndObject();
            this.serializeLayers(gen, e);
            this.serializeLinks(gen, e, entityMap);
        }
        catch (URISyntaxException ex) {
            throw new IOException(ex);
        }
        if (relatedEntitiesDisplayStrings != null) {
            gen.writeArrayFieldStart("relatedLocalizedStrings");
            for (Map.Entry relatedEntitiesDisplayString : relatedEntitiesDisplayStrings.entrySet()) {
                gen.writeStartObject();
                gen.writeStringField("entityId", (String)relatedEntitiesDisplayString.getKey());
                gen.writeStringField("@value", (String)relatedEntitiesDisplayString.getValue());
                gen.writeEndObject();
            }
            gen.writeEndArray();
        }
        gen.writeEndObject();
    }

    private void serializeLayers(JsonGenerator gen, Entity e) throws IOException {
        if (e.getLayers() != null && !e.getLayers().isEmpty()) {
            gen.writeArrayFieldStart("layers");
            for (Map.Entry layer : e.getLayers().entrySet()) {
                gen.writeStartObject();
                gen.writeStringField("@reference", (String)layer.getKey());
                if (((Entity)layer.getValue()).getSourceLabel() != null) {
                    gen.writeStringField("@value", ((Entity)layer.getValue()).getSourceLabel());
                }
                try {
                    gen.writeStringField("_links", this.baseUrl.getAbsoluteUrl("api/v1/e/%s", new String[]{(String)layer.getKey()}));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                gen.writeEndObject();
            }
            gen.writeEndArray();
        }
    }

    private void serializeLinks(JsonGenerator gen, Entity entity, Map<String, List<String>> entityMap) throws IOException, URISyntaxException {
        gen.writeObjectFieldStart("_links");
        if (entity.getEntityId() != null) {
            gen.writeStringField("self", this.baseUrl.getAbsoluteUrl("api/v1/e/%s", new String[]{entity.getEntityId()}));
        }
        if (entity.getLayersEntityIds() != null && !entity.getLayersEntityIds().isEmpty()) {
            gen.writeArrayFieldStart("layers");
            for (String layerId : entity.getLayersEntityIds()) {
                gen.writeString(this.baseUrl.getAbsoluteUrl("api/v1/e/%s", new String[]{layerId}));
            }
            gen.writeEndArray();
        }
        if (!entityMap.isEmpty()) {
            for (Map.Entry<String, List<String>> rel : entityMap.entrySet()) {
                gen.writeArrayFieldStart(rel.getKey());
                for (String link : rel.getValue()) {
                    gen.writeString(link);
                }
                gen.writeEndArray();
            }
        }
        gen.writeEndObject();
    }

    private void serializeProperties(JsonGenerator gen, List<Property> properties, Map<String, List<String>> entityMap, String preferredLanguage) throws IOException, URISyntaxException {
        if (properties == null) {
            return;
        }
        for (Property p : properties) {
            if (p.getProperties() != null && !p.getProperties().isEmpty()) {
                gen.writeFieldName(p.getLabel());
                if (p.getProperties().size() > 1 || p.getDefinition().isMultiple() || p.getDefinition().isMultilingual()) {
                    gen.writeStartArray();
                    this.serializePropertyList(gen, p.getProperties(), entityMap, preferredLanguage);
                    gen.writeEndArray();
                    continue;
                }
                this.serializePropertyList(gen, p.getProperties(), entityMap, preferredLanguage);
                continue;
            }
            List propertyValues = p.valuesAsList();
            if (propertyValues.isEmpty()) continue;
            this.preparePropertyDefinition(p.getDefinition());
            gen.writeFieldName(p.getLabel());
            if (propertyValues.size() > 1 || p.getDefinition().isMultiple() || p.getDefinition().isMultilingual()) {
                gen.writeStartArray();
                if (preferredLanguage != null) {
                    this.writeValuesWithLanguageFilter(gen, entityMap, p, preferredLanguage);
                } else {
                    this.writeValues(gen, entityMap, p);
                }
                gen.writeEndArray();
                continue;
            }
            this.writeValue(gen, p.getDefinition(), (PropertyValue)propertyValues.get(0), entityMap);
        }
    }

    private void writeValues(JsonGenerator gen, Map<String, List<String>> entityMap, Property p) throws IOException, URISyntaxException {
        for (PropertyValue v : p.getValue().valuesAsList()) {
            this.writeValue(gen, p.getDefinition(), v, entityMap);
        }
    }

    private void writeValuesWithLanguageFilter(JsonGenerator gen, Map<String, List<String>> entityMap, Property p, String preferredLanguage) throws IOException, URISyntaxException {
        boolean valuesWritten = false;
        PropertyValue firstValue = null;
        for (PropertyValue v : p.getValue().valuesAsList()) {
            if (firstValue == null) {
                firstValue = v;
            }
            if (v.getLang() != null && !v.getLang().isBlank()) {
                if (!v.getLang().equals(preferredLanguage)) continue;
                this.writeValue(gen, p.getDefinition(), v, entityMap);
                valuesWritten = true;
                continue;
            }
            this.writeValue(gen, p.getDefinition(), v, entityMap);
            valuesWritten = true;
        }
        if (!valuesWritten && firstValue != null) {
            this.writeValue(gen, p.getDefinition(), firstValue, entityMap);
        }
    }

    private void preparePropertyDefinition(PropertyDefinition definition) {
        if (definition.isVocabulary()) {
            VocabularyPropertyDefinition vpd = definition.asVocabulary();
            if (vpd.isEntity() && vpd.getEntryKeys() == null) {
                vpd.setEntryKeys(this.entityRepository.findAllEntityIds());
            } else if (!vpd.isEntity() && vpd.getEntryKeys() == null) {
                vpd.setEntryKeys(this.vocabularyEntryRepository.findKeysByDefinition(vpd.getVocabulary()));
            }
        }
    }

    private void writeValue(JsonGenerator gen, PropertyDefinition pd, PropertyValue pv, Map<String, List<String>> entityMap) throws IOException, URISyntaxException {
        if (pd.isMultilingual() || pd.isVocabulary()) {
            gen.writeStartObject();
            boolean referencesVocabularyEntry = false;
            if (pd.isVocabulary() && pd.asVocabulary().getEntryKeys().contains(pv.asText())) {
                gen.writeFieldName("@reference");
                referencesVocabularyEntry = true;
            } else {
                gen.writeFieldName("@value");
            }
            this.writePrimitive(gen, pd, pv);
            if (pd.isMultilingual()) {
                gen.writeStringField("@lang", pv.getLang());
            }
            if (pd.isVocabulary()) {
                gen.writeBooleanField("entryReference", referencesVocabularyEntry);
                if (referencesVocabularyEntry) {
                    this.writeVocabularyData(gen, pd.asVocabulary(), pv, entityMap);
                }
            }
            gen.writeEndObject();
        } else {
            this.writePrimitive(gen, pd, pv);
        }
    }

    private void writeVocabularyData(JsonGenerator gen, VocabularyPropertyDefinition pd, PropertyValue pv, Map<String, List<String>> entityMap) throws IOException, URISyntaxException {
        if (pd.isEntity()) {
            String linkUrl = this.baseUrl.getAbsoluteUrl("api/v1/e/%s", new String[]{pv.asText()});
            gen.writeStringField("entity", pd.getVocabulary());
            gen.writeObjectFieldStart("_links");
            gen.writeStringField("self", linkUrl);
            gen.writeEndObject();
            if (!entityMap.containsKey(pd.getVocabulary())) {
                entityMap.put(pd.getVocabulary(), new ArrayList());
            }
            if (!entityMap.get(pd.getVocabulary()).contains(linkUrl)) {
                entityMap.get(pd.getVocabulary()).add(linkUrl);
            }
        } else {
            gen.writeStringField("vocabulary", pd.getVocabulary());
            gen.writeStringField("_links", this.baseUrl.getAbsoluteUrl("api/v1/v/%s/e/%s", new String[]{pd.getVocabulary(), pv.asText()}));
        }
    }

    private void writePrimitive(JsonGenerator gen, PropertyDefinition pd, PropertyValue pv) throws IOException {
        if (pd.isSimple() && pd.asSimple().getType().equals((Object)SimplePropertyDefinition.SIMPLE_TYPES.BOOLEAN)) {
            gen.writeBoolean(pv.asBoolean());
        } else if (pd.isSimple() && pd.asSimple().getType().equals((Object)SimplePropertyDefinition.SIMPLE_TYPES.FLOAT)) {
            gen.writeNumber(((Double)((DoublePropertyValue)DoublePropertyValue.class.cast(pv)).getValue()).doubleValue());
        } else if (pd.isSimple() && pd.asSimple().getType().equals((Object)SimplePropertyDefinition.SIMPLE_TYPES.INT)) {
            gen.writeNumber(((Integer)((IntegerPropertyValue)IntegerPropertyValue.class.cast(pv)).getValue()).intValue());
        } else if (pv == null) {
            gen.writeNull();
        } else {
            gen.writeString(pv.asText());
        }
    }

    private void serializePropertyList(JsonGenerator gen, List<PropertyList> properties, Map<String, List<String>> entityMap, String preferredLanguage) throws IOException, URISyntaxException {
        for (PropertyList pl : properties) {
            gen.writeStartObject();
            this.serializeProperties(gen, pl.getProperties(), entityMap, preferredLanguage);
            gen.writeEndObject();
        }
    }

    public BaseUrl getBaseUrl() {
        return this.baseUrl;
    }

    public void setBaseUrl(BaseUrl baseUrl) {
        this.baseUrl = baseUrl;
    }
}

