/*
 * Decompiled with CFR 0.152.
 */
package de.uniba.minf.registry.model;

import de.uniba.minf.auth.profile.AuthProfile;
import de.uniba.minf.core.rest.model.Identifiable;
import java.time.LocalDateTime;
import java.util.Collection;
import org.springframework.data.annotation.Id;
import org.springframework.data.mongodb.core.mapping.Document;

@Document
public class PersistedUser
implements Identifiable {
    private static final long serialVersionUID = -7470824585266674170L;
    @Id
    private String uniqueId;
    private Collection<String> authorities;
    private String issuer;
    private String username;
    private String linkedId;
    private boolean expired;
    private String email;
    private boolean emailProtected;
    private String firstName;
    private String lastName;
    private String language;
    private LocalDateTime lastLogin;

    public PersistedUser(AuthProfile profile) {
        if (profile != null && profile.getId() != null) {
            profile.setId(this.getUniqueId());
        }
        this.setIssuer(profile.getIssuer());
        this.setLinkedId(profile.getLinkedId());
        this.setAuthorities((Collection)profile.getRoles());
        this.setUsername(profile.getUsername());
        if (profile.getEmail() != null && !profile.getEmail().isBlank()) {
            this.setEmail(profile.getEmail());
            this.setEmailProtected(true);
        }
        this.setFirstName(profile.getFirstName());
        this.setLastName(profile.getFamilyName() == null ? profile.getDisplayName() : profile.getFamilyName());
        profile.getEmail();
    }

    public String getUniqueId() {
        return this.uniqueId;
    }

    public Collection<String> getAuthorities() {
        return this.authorities;
    }

    public String getIssuer() {
        return this.issuer;
    }

    public String getUsername() {
        return this.username;
    }

    public String getLinkedId() {
        return this.linkedId;
    }

    public boolean isExpired() {
        return this.expired;
    }

    public String getEmail() {
        return this.email;
    }

    public boolean isEmailProtected() {
        return this.emailProtected;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public String getLanguage() {
        return this.language;
    }

    public LocalDateTime getLastLogin() {
        return this.lastLogin;
    }

    public void setUniqueId(String uniqueId) {
        this.uniqueId = uniqueId;
    }

    public void setAuthorities(Collection<String> authorities) {
        this.authorities = authorities;
    }

    public void setIssuer(String issuer) {
        this.issuer = issuer;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setLinkedId(String linkedId) {
        this.linkedId = linkedId;
    }

    public void setExpired(boolean expired) {
        this.expired = expired;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public void setEmailProtected(boolean emailProtected) {
        this.emailProtected = emailProtected;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public void setLastLogin(LocalDateTime lastLogin) {
        this.lastLogin = lastLogin;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PersistedUser)) {
            return false;
        }
        PersistedUser other = (PersistedUser)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.isExpired() != other.isExpired()) {
            return false;
        }
        if (this.isEmailProtected() != other.isEmailProtected()) {
            return false;
        }
        String this$uniqueId = this.getUniqueId();
        String other$uniqueId = other.getUniqueId();
        if (this$uniqueId == null ? other$uniqueId != null : !this$uniqueId.equals(other$uniqueId)) {
            return false;
        }
        Collection this$authorities = this.getAuthorities();
        Collection other$authorities = other.getAuthorities();
        if (this$authorities == null ? other$authorities != null : !((Object)this$authorities).equals(other$authorities)) {
            return false;
        }
        String this$issuer = this.getIssuer();
        String other$issuer = other.getIssuer();
        if (this$issuer == null ? other$issuer != null : !this$issuer.equals(other$issuer)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        String this$linkedId = this.getLinkedId();
        String other$linkedId = other.getLinkedId();
        if (this$linkedId == null ? other$linkedId != null : !this$linkedId.equals(other$linkedId)) {
            return false;
        }
        String this$email = this.getEmail();
        String other$email = other.getEmail();
        if (this$email == null ? other$email != null : !this$email.equals(other$email)) {
            return false;
        }
        String this$firstName = this.getFirstName();
        String other$firstName = other.getFirstName();
        if (this$firstName == null ? other$firstName != null : !this$firstName.equals(other$firstName)) {
            return false;
        }
        String this$lastName = this.getLastName();
        String other$lastName = other.getLastName();
        if (this$lastName == null ? other$lastName != null : !this$lastName.equals(other$lastName)) {
            return false;
        }
        String this$language = this.getLanguage();
        String other$language = other.getLanguage();
        if (this$language == null ? other$language != null : !this$language.equals(other$language)) {
            return false;
        }
        LocalDateTime this$lastLogin = this.getLastLogin();
        LocalDateTime other$lastLogin = other.getLastLogin();
        return !(this$lastLogin == null ? other$lastLogin != null : !((Object)this$lastLogin).equals(other$lastLogin));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PersistedUser;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isExpired() ? 79 : 97);
        result = result * 59 + (this.isEmailProtected() ? 79 : 97);
        String $uniqueId = this.getUniqueId();
        result = result * 59 + ($uniqueId == null ? 43 : $uniqueId.hashCode());
        Collection $authorities = this.getAuthorities();
        result = result * 59 + ($authorities == null ? 43 : ((Object)$authorities).hashCode());
        String $issuer = this.getIssuer();
        result = result * 59 + ($issuer == null ? 43 : $issuer.hashCode());
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        String $linkedId = this.getLinkedId();
        result = result * 59 + ($linkedId == null ? 43 : $linkedId.hashCode());
        String $email = this.getEmail();
        result = result * 59 + ($email == null ? 43 : $email.hashCode());
        String $firstName = this.getFirstName();
        result = result * 59 + ($firstName == null ? 43 : $firstName.hashCode());
        String $lastName = this.getLastName();
        result = result * 59 + ($lastName == null ? 43 : $lastName.hashCode());
        String $language = this.getLanguage();
        result = result * 59 + ($language == null ? 43 : $language.hashCode());
        LocalDateTime $lastLogin = this.getLastLogin();
        result = result * 59 + ($lastLogin == null ? 43 : ((Object)$lastLogin).hashCode());
        return result;
    }

    public String toString() {
        return "PersistedUser(uniqueId=" + this.getUniqueId() + ", authorities=" + this.getAuthorities() + ", issuer=" + this.getIssuer() + ", username=" + this.getUsername() + ", linkedId=" + this.getLinkedId() + ", expired=" + this.isExpired() + ", email=" + this.getEmail() + ", emailProtected=" + this.isEmailProtected() + ", firstName=" + this.getFirstName() + ", lastName=" + this.getLastName() + ", language=" + this.getLanguage() + ", lastLogin=" + this.getLastLogin() + ")";
    }

    public PersistedUser() {
    }
}

