/*
 * Decompiled with CFR 0.152.
 */
package de.uniba.minf.registry.model;

import de.uniba.minf.core.rest.model.Identifiable;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.Map;
import org.springframework.data.annotation.Id;
import org.springframework.data.mongodb.core.mapping.Document;

@Document
public class Note
implements Identifiable {
    private static final long serialVersionUID = 6529562480150099539L;
    @Id
    private String uniqueId;
    private String name;
    private boolean enabled;
    private Instant displayDate;
    private Instant expirationDate;
    private Map<String, String> localizedTexts;

    public LocalDate getLocalDisplayDate() {
        if (this.displayDate != null) {
            ZoneId zone = ZoneId.systemDefault();
            return LocalDate.ofInstant(this.displayDate, zone);
        }
        return null;
    }

    public LocalDate getLocalExpirationDate() {
        if (this.expirationDate != null) {
            ZoneId zone = ZoneId.systemDefault();
            return LocalDate.ofInstant(this.expirationDate, zone);
        }
        return null;
    }

    public void setLocalDisplayDate(LocalDate localDate) {
        this.displayDate = localDate.atStartOfDay(ZoneId.systemDefault()).toInstant();
    }

    public void setLocalExpirationDate(LocalDate localDate) {
        if (localDate != null) {
            this.expirationDate = localDate.atStartOfDay(ZoneId.systemDefault()).toInstant();
        }
    }

    public String getUniqueId() {
        return this.uniqueId;
    }

    public String getName() {
        return this.name;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public Instant getDisplayDate() {
        return this.displayDate;
    }

    public Instant getExpirationDate() {
        return this.expirationDate;
    }

    public Map<String, String> getLocalizedTexts() {
        return this.localizedTexts;
    }

    public void setUniqueId(String uniqueId) {
        this.uniqueId = uniqueId;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setDisplayDate(Instant displayDate) {
        this.displayDate = displayDate;
    }

    public void setExpirationDate(Instant expirationDate) {
        this.expirationDate = expirationDate;
    }

    public void setLocalizedTexts(Map<String, String> localizedTexts) {
        this.localizedTexts = localizedTexts;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Note)) {
            return false;
        }
        Note other = (Note)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.isEnabled() != other.isEnabled()) {
            return false;
        }
        String this$uniqueId = this.getUniqueId();
        String other$uniqueId = other.getUniqueId();
        if (this$uniqueId == null ? other$uniqueId != null : !this$uniqueId.equals(other$uniqueId)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        Instant this$displayDate = this.getDisplayDate();
        Instant other$displayDate = other.getDisplayDate();
        if (this$displayDate == null ? other$displayDate != null : !((Object)this$displayDate).equals(other$displayDate)) {
            return false;
        }
        Instant this$expirationDate = this.getExpirationDate();
        Instant other$expirationDate = other.getExpirationDate();
        if (this$expirationDate == null ? other$expirationDate != null : !((Object)this$expirationDate).equals(other$expirationDate)) {
            return false;
        }
        Map this$localizedTexts = this.getLocalizedTexts();
        Map other$localizedTexts = other.getLocalizedTexts();
        return !(this$localizedTexts == null ? other$localizedTexts != null : !((Object)this$localizedTexts).equals(other$localizedTexts));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Note;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isEnabled() ? 79 : 97);
        String $uniqueId = this.getUniqueId();
        result = result * 59 + ($uniqueId == null ? 43 : $uniqueId.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        Instant $displayDate = this.getDisplayDate();
        result = result * 59 + ($displayDate == null ? 43 : ((Object)$displayDate).hashCode());
        Instant $expirationDate = this.getExpirationDate();
        result = result * 59 + ($expirationDate == null ? 43 : ((Object)$expirationDate).hashCode());
        Map $localizedTexts = this.getLocalizedTexts();
        result = result * 59 + ($localizedTexts == null ? 43 : ((Object)$localizedTexts).hashCode());
        return result;
    }

    public String toString() {
        return "Note(uniqueId=" + this.getUniqueId() + ", name=" + this.getName() + ", enabled=" + this.isEnabled() + ", displayDate=" + this.getDisplayDate() + ", expirationDate=" + this.getExpirationDate() + ", localizedTexts=" + this.getLocalizedTexts() + ")";
    }
}

