/*
 * Decompiled with CFR 0.152.
 */
package de.uniba.minf.registry.importer;

import de.uniba.minf.core.rest.model.RestActionResponse;
import de.uniba.minf.registry.importer.ImportRunner;
import de.uniba.minf.registry.importer.ImportService;
import de.uniba.minf.registry.model.Import;
import de.uniba.minf.registry.model.ImportState;
import de.uniba.minf.registry.model.entity.Entity;
import de.uniba.minf.registry.repository.EntityRepository;
import de.uniba.minf.registry.repository.ImportRepository;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ImportServiceImpl
implements ImportService,
InitializingBean,
PropertyChangeListener {
    private static final Logger log = LoggerFactory.getLogger(ImportServiceImpl.class);
    @Autowired
    private EntityRepository entityRepo;
    @Autowired
    private ImportRepository importRepo;
    protected ExecutorService importExecutor;
    private int maxPoolSize = 5;
    private Map<String, ImportState> importRunnerIdStateMap;

    public void afterPropertiesSet() throws Exception {
        this.importExecutor = Executors.newFixedThreadPool(this.maxPoolSize);
        this.importRunnerIdStateMap = new ConcurrentHashMap();
    }

    public long deleteImport(String uniqueId) {
        Optional i = this.importRepo.findById((Object)uniqueId);
        if (i.isEmpty()) {
            return 0L;
        }
        return this.deleteImport((Import)i.get());
    }

    public long deleteImport(Import i) {
        long count = 0L;
        Collection entities = this.entityRepo.findByImportId(i.getUniqueId());
        for (Entity delE : entities) {
            Optional prevE = this.entityRepo.findbyNextVersionUniqueId(delE.getUniqueId());
            Optional nextE = Optional.empty();
            if (delE.getNextVersionUniqueId() != null) {
                nextE = this.entityRepo.findById((Object)delE.getNextVersionUniqueId());
            }
            if (prevE.isPresent()) {
                if (nextE.isPresent()) {
                    ((Entity)prevE.get()).setNextVersionUniqueId(((Entity)nextE.get()).getUniqueId());
                } else {
                    ((Entity)prevE.get()).setNextVersionUniqueId(null);
                }
                this.entityRepo.save((Object)((Entity)prevE.get()));
            }
            this.entityRepo.delete((Object)delE);
            ++count;
        }
        this.entityRepo.deleteAll((Iterable)entities);
        log.info("Deleting read-only import, deleted {} associated entites", (Object)count);
        this.importRepo.delete((Object)i);
        log.info("Deleted import: {}", (Object)i.getUniqueId());
        return count;
    }

    public RestActionResponse.ApiActionStatus getStatus(String runnerId) {
        if (runnerId == null || !this.importRunnerIdStateMap.containsKey(runnerId)) {
            return RestActionResponse.ApiActionStatus.NONE;
        }
        ImportState result = (ImportState)this.importRunnerIdStateMap.get(runnerId);
        if (result == null || !result.isDone() && !result.isFailed()) {
            return RestActionResponse.ApiActionStatus.BUSY;
        }
        return RestActionResponse.ApiActionStatus.DONE;
    }

    public ImportState getImportState(String runnerId) {
        if (runnerId == null || !this.importRunnerIdStateMap.containsKey(runnerId)) {
            return null;
        }
        return (ImportState)this.importRunnerIdStateMap.get(runnerId);
    }

    public void importAsync(ImportRunner ir) {
        ImportState res = new ImportState();
        res.setImportType(ir.isValidateOnly() ? ImportState.IMPORT_TYPES.VALIDATION_ONLY : ImportState.IMPORT_TYPES.IMPORT);
        res.setSourceEntityId(ir.getSourceEntityId());
        res.setCreation(ir.getCreation());
        this.importRunnerIdStateMap.put(ir.getSourceEntityId(), res);
        ir.addPropertyChangeListener((PropertyChangeListener)this);
        this.importExecutor.execute((Runnable)ir);
    }

    @Override
    public void propertyChange(PropertyChangeEvent arg0) {
        ImportRunner ir = (ImportRunner)ImportRunner.class.cast(arg0.getSource());
        ImportState result = arg0.getNewValue() == null ? null : (ImportState)ImportState.class.cast(arg0.getNewValue());
        this.importRunnerIdStateMap.put(ir.getSourceEntityId(), result);
    }
}

