/*
 * Decompiled with CFR 0.152.
 */
package de.uniba.minf.registry.importer;

import am.ik.yavi.core.ConstraintViolations;
import de.uniba.minf.registry.importer.ImportService;
import de.uniba.minf.registry.model.BaseDefinedObject;
import de.uniba.minf.registry.model.Import;
import de.uniba.minf.registry.model.ImportState;
import de.uniba.minf.registry.model.ValueMapping;
import de.uniba.minf.registry.model.definition.BaseDefinition;
import de.uniba.minf.registry.model.definition.EntityDefinition;
import de.uniba.minf.registry.model.entity.Entity;
import de.uniba.minf.registry.model.helper.PropertyDefinitionHelper;
import de.uniba.minf.registry.model.validation.exception.ValidationConfigurationException;
import de.uniba.minf.registry.repository.ImportRepository;
import de.uniba.minf.registry.repository.ImportResultRepository;
import de.uniba.minf.registry.service.EntityDefinitionService;
import de.uniba.minf.registry.service.EntityService;
import de.uniba.minf.registry.view.helper.EntityVocabularyHelper;
import de.uniba.minf.registry.view.model.ValidationViolationMessage;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.MessageSource;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class ImportRunner
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(ImportRunner.class);
    @Autowired
    private EntityService entityService;
    @Autowired
    private ImportService importService;
    @Autowired
    private EntityDefinitionService entityDefService;
    @Autowired
    private EntityVocabularyHelper entityVocabularyHelper;
    @Autowired
    private MessageSource messageSource;
    @Autowired
    private ImportResultRepository importResultRepo;
    @Autowired
    private ImportRepository importRepo;
    @Value(value="${baseUrl}")
    private String baseUrl;
    private PropertyChangeSupport support = new PropertyChangeSupport(this);
    private Locale locale;
    boolean validateOnly;
    boolean readOnly = true;
    private String sourceEntityId;
    private String template;
    private String format;
    private String body;
    private List<String> urls;
    private Instant creation;
    String userId;
    String definition;
    Map<String, ValueMapping> valueMap;
    ImportState result;

    public void addPropertyChangeListener(PropertyChangeListener pcl) {
        this.support.addPropertyChangeListener(pcl);
    }

    @Override
    public void run() {
        try {
            this.doImport();
        }
        catch (Exception e) {
            log.error("Failed to run importer", (Throwable)e);
            this.support.firePropertyChange("error", null, e);
        }
    }

    public void doImport() throws IllegalArgumentException, MalformedURLException, IOException {
        Optional templateEntity;
        this.result = new ImportState();
        this.result.setSourceEntityId(this.sourceEntityId);
        this.result.setImportType(this.validateOnly ? ImportState.IMPORT_TYPES.VALIDATION_ONLY : ImportState.IMPORT_TYPES.IMPORT);
        this.result.setCreation(this.getCreation());
        this.result.setDone(true);
        Optional source = this.entityService.findLatestByEntityId(this.sourceEntityId, false);
        ArrayList entities = new ArrayList();
        for (Object url : this.urls) {
            if (url != null && !((String)url).isBlank()) {
                entities.addAll(this.entityService.readEntitiesFromURL(new URL((String)url), this.definition));
                continue;
            }
            if (this.format.equals("JSON")) {
                entities.addAll(this.entityService.readEntitiesFromJson(this.body, this.definition));
                continue;
            }
            entities.addAll(this.entityService.readEntitiesFromYaml(this.body, this.definition));
        }
        if (entities == null || entities.isEmpty()) {
            this.support.firePropertyChange("result", null, this.result);
            this.importResultRepo.save((Object)this.result);
            return;
        }
        if (this.template != null && (templateEntity = this.entityService.findLatestByEntityId(this.getTemplate(), true)).isPresent()) {
            for (Object e : entities) {
                e.getProperties().addAll(((Entity)templateEntity.get()).getProperties());
            }
        }
        this.result.setEntities(entities);
        this.entityService.applyValueMappings(this.result.getEntities(), this.valueMap);
        EntityDefinition ed = this.entityDefService.findCurrentByName(this.definition, true);
        this.result.setUnknownPropertyLists(new ArrayList(this.result.getEntities().size()));
        this.result.setResolvedVocabularyEntries(new ArrayList(this.result.getEntities().size()));
        for (Object e : this.result.getEntities()) {
            this.result.getUnknownPropertyLists().add(PropertyDefinitionHelper.mergeWithDefinition((BaseDefinedObject)e, (BaseDefinition)ed, (boolean)true));
            this.result.getResolvedVocabularyEntries().add(this.entityVocabularyHelper.resolveVocabularyEntries((Entity)e));
            this.entityService.autopopulateVocabularyData((Entity)e, ed);
        }
        this.result.setValidationMessageLists(new ArrayList(this.result.getEntities().size()));
        try {
            List violations = this.entityService.validateEntities(ed, this.result.getEntities());
            for (ConstraintViolations v : violations) {
                ArrayList validationMessages = new ArrayList();
                if (!v.isValid()) {
                    v.forEach(x -> validationMessages.add(new ValidationViolationMessage(this.convertValidationConstraintNameToViewPropertyLabel(x.name()), x.messageKey(), this.messageSource.getMessage("validation.violation." + x.messageKey(), x.args(), this.locale), x.args()[x.args().length - 1])));
                }
                this.result.getValidationMessageLists().add(validationMessages);
            }
        }
        catch (ValidationConfigurationException ex) {
            log.error("Entity validation failed with ValidationConfigurationException", (Throwable)ex);
        }
        boolean idIssues = false;
        if (source.isPresent()) {
            List<String> externalIdentifiers = entities.stream().map(Entity::getExternalIdentifier).filter(id -> id != null).toList();
            for (int i = 0; i < entities.size(); ++i) {
                Entity e = (Entity)entities.get(i);
                e.setSourceEntityId(this.sourceEntityId);
                e.setSourceLabel(((Entity)source.get()).get("short_title").getValue().asText());
                if (e.getExternalIdentifier() == null || e.getExternalIdentifier().isBlank()) {
                    ((List)this.result.getValidationMessageLists().get(i)).add(new ValidationViolationMessage("_pid", "extid.missing", this.messageSource.getMessage("validation.violation.extid.missing", null, this.locale), null));
                    idIssues = true;
                    continue;
                }
                if (externalIdentifiers.stream().filter(id -> id.equals(e.getExternalIdentifier())).count() <= 1L) continue;
                ((List)this.result.getValidationMessageLists().get(i)).add(new ValidationViolationMessage("_pid", "extid.not_unique", this.messageSource.getMessage("validation.violation.extid.not_unique", null, this.locale), null));
                idIssues = true;
            }
        }
        this.result.setExternalIdIssues(idIssues);
        if (!this.validateOnly) {
            this.result.setIm(this.importEntities(this.result.getEntities(), this.result.getValidationMessageLists().stream().map(vl -> !vl.isEmpty()).toList(), ed, this.template));
        }
        this.importResultRepo.save((Object)this.result);
        this.support.firePropertyChange("result", null, this.result);
    }

    public Import importEntities(List<Entity> entities, List<Boolean> isDraft, EntityDefinition ed, String templateId) {
        Import im = new Import();
        im.setTemplateId(templateId);
        im.setUserUniqueId(this.userId);
        im.setCreationInstant(this.getCreation());
        im.setSourceEntityId(this.sourceEntityId);
        this.importRepo.save((Object)im);
        for (int i = 0; i < entities.size(); ++i) {
            Optional eExist;
            Entity e = entities.get(i);
            if (e.getSourceEntityId() != null && e.getExternalIdentifier() != null && !e.getExternalIdentifier().isBlank() && (eExist = this.entityService.findBySourceAndExternalIdentifier(ed, e.getSourceEntityId(), e.getExternalIdentifier())).isPresent()) {
                e.setEntityId(((Entity)eExist.get()).getEntityId());
            }
            e.setUserUniqueId(this.userId);
            e.setImportId(im.getUniqueId());
            e.setReadOnly(this.isReadOnly());
            e.setDraft(isDraft.get(i).booleanValue());
            this.entityService.setOrCreateRelatedEntities(e, ed);
            this.entityService.save(entities.get(i));
        }
        return im;
    }

    private String convertValidationConstraintNameToViewPropertyLabel(String name) {
        String[] nameParts = name.split("\\.");
        StringBuilder propertyLabelBuilder = new StringBuilder();
        for (String part : nameParts) {
            if (part.startsWith("_")) continue;
            if (!propertyLabelBuilder.isEmpty()) {
                propertyLabelBuilder.append(".");
            }
            propertyLabelBuilder.append(part);
        }
        return propertyLabelBuilder.toString();
    }

    public EntityService getEntityService() {
        return this.entityService;
    }

    public ImportService getImportService() {
        return this.importService;
    }

    public EntityDefinitionService getEntityDefService() {
        return this.entityDefService;
    }

    public EntityVocabularyHelper getEntityVocabularyHelper() {
        return this.entityVocabularyHelper;
    }

    public MessageSource getMessageSource() {
        return this.messageSource;
    }

    public ImportResultRepository getImportResultRepo() {
        return this.importResultRepo;
    }

    public ImportRepository getImportRepo() {
        return this.importRepo;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public PropertyChangeSupport getSupport() {
        return this.support;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public boolean isValidateOnly() {
        return this.validateOnly;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public String getSourceEntityId() {
        return this.sourceEntityId;
    }

    public String getTemplate() {
        return this.template;
    }

    public String getFormat() {
        return this.format;
    }

    public String getBody() {
        return this.body;
    }

    public List<String> getUrls() {
        return this.urls;
    }

    public Instant getCreation() {
        return this.creation;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getDefinition() {
        return this.definition;
    }

    public Map<String, ValueMapping> getValueMap() {
        return this.valueMap;
    }

    public ImportState getResult() {
        return this.result;
    }

    public void setEntityService(EntityService entityService) {
        this.entityService = entityService;
    }

    public void setImportService(ImportService importService) {
        this.importService = importService;
    }

    public void setEntityDefService(EntityDefinitionService entityDefService) {
        this.entityDefService = entityDefService;
    }

    public void setEntityVocabularyHelper(EntityVocabularyHelper entityVocabularyHelper) {
        this.entityVocabularyHelper = entityVocabularyHelper;
    }

    public void setMessageSource(MessageSource messageSource) {
        this.messageSource = messageSource;
    }

    public void setImportResultRepo(ImportResultRepository importResultRepo) {
        this.importResultRepo = importResultRepo;
    }

    public void setImportRepo(ImportRepository importRepo) {
        this.importRepo = importRepo;
    }

    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public void setSupport(PropertyChangeSupport support) {
        this.support = support;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public void setValidateOnly(boolean validateOnly) {
        this.validateOnly = validateOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public void setSourceEntityId(String sourceEntityId) {
        this.sourceEntityId = sourceEntityId;
    }

    public void setTemplate(String template) {
        this.template = template;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public void setUrls(List<String> urls) {
        this.urls = urls;
    }

    public void setCreation(Instant creation) {
        this.creation = creation;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public void setDefinition(String definition) {
        this.definition = definition;
    }

    public void setValueMap(Map<String, ValueMapping> valueMap) {
        this.valueMap = valueMap;
    }

    public void setResult(ImportState result) {
        this.result = result;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ImportRunner)) {
            return false;
        }
        ImportRunner other = (ImportRunner)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.isValidateOnly() != other.isValidateOnly()) {
            return false;
        }
        if (this.isReadOnly() != other.isReadOnly()) {
            return false;
        }
        EntityService this$entityService = this.getEntityService();
        EntityService other$entityService = other.getEntityService();
        if (this$entityService == null ? other$entityService != null : !this$entityService.equals(other$entityService)) {
            return false;
        }
        ImportService this$importService = this.getImportService();
        ImportService other$importService = other.getImportService();
        if (this$importService == null ? other$importService != null : !this$importService.equals(other$importService)) {
            return false;
        }
        EntityDefinitionService this$entityDefService = this.getEntityDefService();
        EntityDefinitionService other$entityDefService = other.getEntityDefService();
        if (this$entityDefService == null ? other$entityDefService != null : !this$entityDefService.equals(other$entityDefService)) {
            return false;
        }
        EntityVocabularyHelper this$entityVocabularyHelper = this.getEntityVocabularyHelper();
        EntityVocabularyHelper other$entityVocabularyHelper = other.getEntityVocabularyHelper();
        if (this$entityVocabularyHelper == null ? other$entityVocabularyHelper != null : !this$entityVocabularyHelper.equals(other$entityVocabularyHelper)) {
            return false;
        }
        MessageSource this$messageSource = this.getMessageSource();
        MessageSource other$messageSource = other.getMessageSource();
        if (this$messageSource == null ? other$messageSource != null : !this$messageSource.equals(other$messageSource)) {
            return false;
        }
        ImportResultRepository this$importResultRepo = this.getImportResultRepo();
        ImportResultRepository other$importResultRepo = other.getImportResultRepo();
        if (this$importResultRepo == null ? other$importResultRepo != null : !this$importResultRepo.equals(other$importResultRepo)) {
            return false;
        }
        ImportRepository this$importRepo = this.getImportRepo();
        ImportRepository other$importRepo = other.getImportRepo();
        if (this$importRepo == null ? other$importRepo != null : !this$importRepo.equals(other$importRepo)) {
            return false;
        }
        String this$baseUrl = this.getBaseUrl();
        String other$baseUrl = other.getBaseUrl();
        if (this$baseUrl == null ? other$baseUrl != null : !this$baseUrl.equals(other$baseUrl)) {
            return false;
        }
        PropertyChangeSupport this$support = this.getSupport();
        PropertyChangeSupport other$support = other.getSupport();
        if (this$support == null ? other$support != null : !this$support.equals(other$support)) {
            return false;
        }
        Locale this$locale = this.getLocale();
        Locale other$locale = other.getLocale();
        if (this$locale == null ? other$locale != null : !((Object)this$locale).equals(other$locale)) {
            return false;
        }
        String this$sourceEntityId = this.getSourceEntityId();
        String other$sourceEntityId = other.getSourceEntityId();
        if (this$sourceEntityId == null ? other$sourceEntityId != null : !this$sourceEntityId.equals(other$sourceEntityId)) {
            return false;
        }
        String this$template = this.getTemplate();
        String other$template = other.getTemplate();
        if (this$template == null ? other$template != null : !this$template.equals(other$template)) {
            return false;
        }
        String this$format = this.getFormat();
        String other$format = other.getFormat();
        if (this$format == null ? other$format != null : !this$format.equals(other$format)) {
            return false;
        }
        String this$body = this.getBody();
        String other$body = other.getBody();
        if (this$body == null ? other$body != null : !this$body.equals(other$body)) {
            return false;
        }
        List this$urls = this.getUrls();
        List other$urls = other.getUrls();
        if (this$urls == null ? other$urls != null : !((Object)this$urls).equals(other$urls)) {
            return false;
        }
        Instant this$creation = this.getCreation();
        Instant other$creation = other.getCreation();
        if (this$creation == null ? other$creation != null : !((Object)this$creation).equals(other$creation)) {
            return false;
        }
        String this$userId = this.getUserId();
        String other$userId = other.getUserId();
        if (this$userId == null ? other$userId != null : !this$userId.equals(other$userId)) {
            return false;
        }
        String this$definition = this.getDefinition();
        String other$definition = other.getDefinition();
        if (this$definition == null ? other$definition != null : !this$definition.equals(other$definition)) {
            return false;
        }
        Map this$valueMap = this.getValueMap();
        Map other$valueMap = other.getValueMap();
        if (this$valueMap == null ? other$valueMap != null : !((Object)this$valueMap).equals(other$valueMap)) {
            return false;
        }
        ImportState this$result = this.getResult();
        ImportState other$result = other.getResult();
        return !(this$result == null ? other$result != null : !this$result.equals(other$result));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ImportRunner;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isValidateOnly() ? 79 : 97);
        result = result * 59 + (this.isReadOnly() ? 79 : 97);
        EntityService $entityService = this.getEntityService();
        result = result * 59 + ($entityService == null ? 43 : $entityService.hashCode());
        ImportService $importService = this.getImportService();
        result = result * 59 + ($importService == null ? 43 : $importService.hashCode());
        EntityDefinitionService $entityDefService = this.getEntityDefService();
        result = result * 59 + ($entityDefService == null ? 43 : $entityDefService.hashCode());
        EntityVocabularyHelper $entityVocabularyHelper = this.getEntityVocabularyHelper();
        result = result * 59 + ($entityVocabularyHelper == null ? 43 : $entityVocabularyHelper.hashCode());
        MessageSource $messageSource = this.getMessageSource();
        result = result * 59 + ($messageSource == null ? 43 : $messageSource.hashCode());
        ImportResultRepository $importResultRepo = this.getImportResultRepo();
        result = result * 59 + ($importResultRepo == null ? 43 : $importResultRepo.hashCode());
        ImportRepository $importRepo = this.getImportRepo();
        result = result * 59 + ($importRepo == null ? 43 : $importRepo.hashCode());
        String $baseUrl = this.getBaseUrl();
        result = result * 59 + ($baseUrl == null ? 43 : $baseUrl.hashCode());
        PropertyChangeSupport $support = this.getSupport();
        result = result * 59 + ($support == null ? 43 : $support.hashCode());
        Locale $locale = this.getLocale();
        result = result * 59 + ($locale == null ? 43 : ((Object)$locale).hashCode());
        String $sourceEntityId = this.getSourceEntityId();
        result = result * 59 + ($sourceEntityId == null ? 43 : $sourceEntityId.hashCode());
        String $template = this.getTemplate();
        result = result * 59 + ($template == null ? 43 : $template.hashCode());
        String $format = this.getFormat();
        result = result * 59 + ($format == null ? 43 : $format.hashCode());
        String $body = this.getBody();
        result = result * 59 + ($body == null ? 43 : $body.hashCode());
        List $urls = this.getUrls();
        result = result * 59 + ($urls == null ? 43 : ((Object)$urls).hashCode());
        Instant $creation = this.getCreation();
        result = result * 59 + ($creation == null ? 43 : ((Object)$creation).hashCode());
        String $userId = this.getUserId();
        result = result * 59 + ($userId == null ? 43 : $userId.hashCode());
        String $definition = this.getDefinition();
        result = result * 59 + ($definition == null ? 43 : $definition.hashCode());
        Map $valueMap = this.getValueMap();
        result = result * 59 + ($valueMap == null ? 43 : ((Object)$valueMap).hashCode());
        ImportState $result = this.getResult();
        result = result * 59 + ($result == null ? 43 : $result.hashCode());
        return result;
    }

    public String toString() {
        return "ImportRunner(entityService=" + this.getEntityService() + ", importService=" + this.getImportService() + ", entityDefService=" + this.getEntityDefService() + ", entityVocabularyHelper=" + this.getEntityVocabularyHelper() + ", messageSource=" + this.getMessageSource() + ", importResultRepo=" + this.getImportResultRepo() + ", importRepo=" + this.getImportRepo() + ", baseUrl=" + this.getBaseUrl() + ", support=" + this.getSupport() + ", locale=" + this.getLocale() + ", validateOnly=" + this.isValidateOnly() + ", readOnly=" + this.isReadOnly() + ", sourceEntityId=" + this.getSourceEntityId() + ", template=" + this.getTemplate() + ", format=" + this.getFormat() + ", body=" + this.getBody() + ", urls=" + this.getUrls() + ", creation=" + this.getCreation() + ", userId=" + this.getUserId() + ", definition=" + this.getDefinition() + ", valueMap=" + this.getValueMap() + ", result=" + this.getResult() + ")";
    }
}

