/*
 * Decompiled with CFR 0.152.
 */
package de.uniba.minf.registry.controller.user;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import de.uniba.minf.auth.spring.mvc.model.AuthPojo;
import de.uniba.minf.core.rest.exception.ApiInsufficientPermissionsException;
import de.uniba.minf.core.rest.exception.ApiItemNotFoundException;
import de.uniba.minf.core.rest.model.Identifiable;
import de.uniba.minf.core.rest.model.RestItemResponse;
import de.uniba.minf.core.rest.model.RestItemsResponse;
import de.uniba.minf.core.rest.model.RestResponse;
import de.uniba.minf.registry.controller.user.BaseUserRestController;
import de.uniba.minf.registry.model.PersistedUser;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="Users", description="API methods on users")
@RestController
@RequestMapping(value={"/api/v1/users"})
public class UserRestController
extends BaseUserRestController {
    private static final String ITEM_TYPE = "user";

    public UserRestController() {
        super("/api/v1/users");
    }

    @GetMapping
    public RestResponse getUsers(HttpServletRequest request, Locale locale) throws ApiInsufficientPermissionsException, ApiItemNotFoundException {
        AuthPojo authPojo = this.authInfoHelper.getAuth();
        if (authPojo.getLevel() < 100) {
            Optional authUser = this.userRepo.findById((Object)authPojo.getUserId());
            if (authUser.isPresent()) {
                return this.getUserByUniqueId(((PersistedUser)authUser.get()).getUniqueId(), request, locale);
            }
            throw new ApiItemNotFoundException(ITEM_TYPE, authPojo.getUserId());
        }
        return this.getAllUsers(request, locale);
    }

    @GetMapping(value={"/{userUniqueId}"})
    public RestItemResponse getUserByUniqueId(@PathVariable(value="userUniqueId") String userUniqueId, HttpServletRequest request, Locale locale) throws ApiInsufficientPermissionsException, ApiItemNotFoundException {
        RestItemResponse itemResponse = new RestItemResponse();
        AuthPojo authPojo = this.authInfoHelper.getAuth();
        itemResponse.setItem(this.getUserItem(this.checkCanAccessUser(authPojo, userUniqueId), request.getRequestURL().toString(), false));
        itemResponse.setLinks((JsonNode)this.getLinks(request.getRequestURL().toString()));
        return itemResponse;
    }

    @PostMapping(value={"/{userUniqueId}"})
    public RestItemResponse saveUser(@PathVariable(value="userUniqueId") String userUniqueId, @RequestBody PersistedUser data, HttpServletRequest request, Locale locale) throws ApiInsufficientPermissionsException, ApiItemNotFoundException {
        AuthPojo authPojo = this.authInfoHelper.getAuth();
        if (!authPojo.getUserId().equals(userUniqueId)) {
            throw new ApiInsufficientPermissionsException();
        }
        Optional user = this.userRepo.findById((Object)userUniqueId);
        RestItemResponse itemResponse = new RestItemResponse();
        if (user.isPresent()) {
            if (!((PersistedUser)user.get()).isEmailProtected()) {
                ((PersistedUser)user.get()).setEmail(data.getEmail());
            }
            ((PersistedUser)user.get()).setFirstName(data.getFirstName());
            ((PersistedUser)user.get()).setLastName(data.getLastName());
            itemResponse.setAction(RestResponse.ApiActions.UPDATED);
            this.userRepo.save((Object)((PersistedUser)user.get()));
        }
        itemResponse.setItem(this.getUserItem(this.checkCanAccessUser(authPojo, userUniqueId), request.getRequestURL().toString(), false));
        itemResponse.setLinks((JsonNode)this.getLinks(request.getRequestURL().toString()));
        return itemResponse;
    }

    private RestItemsResponse getAllUsers(HttpServletRequest request, Locale locale) {
        RestItemsResponse response = new RestItemsResponse();
        List users = this.userRepo.findAll().stream().map(u -> u).collect(Collectors.toList());
        response.setSize((long)users.size());
        response.setLinks((JsonNode)this.getLinks(request.getRequestURL().toString()));
        response.setItems(this.getUserItems(users, request.getRequestURL().toString()));
        return response;
    }

    private ArrayNode getUserItems(List<PersistedUser> users, String requestUrl) {
        ArrayNode array = this.jsonMapper.createArrayNode();
        if (!users.isEmpty()) {
            for (PersistedUser user : users) {
                array.add(this.getUserItem(user, requestUrl, true));
            }
        }
        return array;
    }

    private JsonNode getUserItem(PersistedUser user, String requestUrl, boolean suffixUniqueId) {
        ObjectNode u = this.getItem((Identifiable)user);
        if (u.has("accessTokens")) {
            for (JsonNode t : (ArrayNode)u.path("accessTokens")) {
                ObjectNode objT = (ObjectNode)t;
                objT.set("_links", (JsonNode)this.getTokenLink(requestUrl, user.getUniqueId(), objT.get("uniqueId").textValue()));
            }
        }
        return u;
    }

    private TextNode getTokenLink(String requestUrl, String userUniqueId, String tokenUniqueId) {
        StringBuilder tokenLinkBuilder = new StringBuilder();
        tokenLinkBuilder.append(requestUrl).append("/").append("tokens");
        if (tokenUniqueId != null) {
            tokenLinkBuilder.append("/").append(tokenUniqueId);
        }
        return new TextNode(tokenLinkBuilder.toString());
    }
}

