/*
 * Decompiled with CFR 0.152.
 */
package de.uniba.minf.registry.controller;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import de.uniba.minf.core.rest.controller.BaseRestController;
import de.uniba.minf.core.rest.exception.ApiExecutionException;
import de.uniba.minf.core.rest.exception.ApiItemNotFoundException;
import de.uniba.minf.core.rest.model.Identifiable;
import de.uniba.minf.core.rest.model.RestItemResponse;
import de.uniba.minf.core.rest.model.RestItemsResponse;
import de.uniba.minf.core.rest.model.RestResponse;
import de.uniba.minf.registry.model.vocabulary.VocabularyDefinition;
import de.uniba.minf.registry.model.vocabulary.VocabularyEntry;
import de.uniba.minf.registry.model.vocabulary.VocabularyLookupException;
import de.uniba.minf.registry.model.vocabulary.VocabularyLookupService;
import de.uniba.minf.registry.repository.VocabularyDefinitionRepository;
import de.uniba.minf.registry.repository.VocabularyEntryRepository;
import de.uniba.minf.registry.view.helper.PropertyPreviewHelper;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="Vocabulary entries", description="Records forming the content of defined vocabularies")
@RestController
@RequestMapping(value={"/api/v1/v"})
public class VocabularyEntryController
extends BaseRestController {
    private static final Logger log = LoggerFactory.getLogger(VocabularyEntryController.class);
    @Autowired
    @Qualifier(value="yamlMapper")
    private ObjectMapper yamlMapper;
    @Autowired
    private VocabularyEntryRepository vocabularyRepo;
    @Autowired
    private VocabularyDefinitionRepository vocabularyDefinitionRepo;
    @Autowired
    private VocabularyLookupService vocabularyLookupService;

    public VocabularyEntryController() {
        super("/api/v1/v");
    }

    @PostMapping(consumes={"application/x-yaml", "text/yaml"})
    public void postYaml(@RequestBody String updatedApi, Locale locale) throws JsonMappingException, JsonProcessingException {
        VocabularyEntry e = (VocabularyEntry)this.yamlMapper.readValue(updatedApi, VocabularyEntry.class);
        this.vocabularyRepo.save((Object)e);
        log.debug(e.getDefinitionName());
    }

    @PostMapping(consumes={"application/json"})
    public void postJson(@RequestBody String updatedApi, Locale locale) throws JsonMappingException, JsonProcessingException {
        if (updatedApi.trim().startsWith("[")) {
            List vocabularyEntries = (List)this.jsonMapper.readValue(updatedApi, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            this.vocabularyRepo.saveOrUpdateAll(vocabularyEntries);
            log.debug("saved: " + vocabularyEntries.size());
        } else {
            VocabularyEntry e = (VocabularyEntry)this.jsonMapper.readValue(updatedApi, VocabularyEntry.class);
            this.vocabularyRepo.saveOrUpdate(e);
            log.debug(e.getDefinitionName());
        }
    }

    @GetMapping
    public RestItemsResponse get(HttpServletRequest request, Locale locale) {
        RestItemsResponse response = new RestItemsResponse();
        List entries = this.vocabularyRepo.findAll();
        response.setSize((long)entries.size());
        response.setLinks((JsonNode)this.getLinks(request.getRequestURL().toString()));
        response.setItems(this.getItems((Collection)entries));
        return response;
    }

    @GetMapping(value={"{id}"})
    public VocabularyEntry get(@PathVariable(value="id") String id, Locale locale) {
        return (VocabularyEntry)this.vocabularyRepo.findById((Object)id).get();
    }

    @GetMapping(value={"/{name}/"})
    public RestItemsResponse getByDefinition(@PathVariable(value="name") String name, HttpServletRequest request, Locale locale) {
        RestItemsResponse response = new RestItemsResponse();
        List entries = this.vocabularyRepo.findByDefinition(name);
        response.setSize((long)entries.size());
        response.setLinks((JsonNode)this.getLinks(request.getRequestURL().toString()));
        response.setItems(this.getItems((Collection)entries));
        return response;
    }

    @PostMapping(value={"/{name}/fetch"})
    public RestItemResponse fetchVocabularyEntry(@PathVariable(value="name") String name, String key, HttpServletRequest request, Locale locale) throws ApiItemNotFoundException {
        RestItemResponse response = new RestItemResponse();
        try {
            VocabularyEntry v = this.vocabularyLookupService.resolve(name, key);
            if (v == null) {
                throw new ApiItemNotFoundException("vocabularyEntry", name + ":" + key);
            }
            response.setLinks((JsonNode)this.getLinks(request.getRequestURL().toString()));
            response.setItem((JsonNode)this.getItem((Identifiable)v));
        }
        catch (VocabularyLookupException e) {
            log.error("Error while manually fetching vocabulary entry", (Throwable)e);
        }
        return response;
    }

    @PostMapping(value={"/{name}/clear"})
    public RestItemsResponse clearVocabularyEntries(@PathVariable(value="name") String name, HttpServletRequest request, Locale locale) {
        this.vocabularyRepo.deleteByVocabularyName(name);
        RestItemsResponse response = new RestItemsResponse();
        response.setAction(RestResponse.ApiActions.DELETED);
        return response;
    }

    @PostMapping(value={"/{name}/search"})
    public RestItemsResponse searchVocabularyEntry(@PathVariable(value="name") String name, @RequestBody(required=false) JsonNode body, HttpServletRequest request, Locale locale) throws ApiExecutionException {
        RestItemsResponse response = new RestItemsResponse();
        if (body == null || !body.has("query") || body.get("query").asText().isEmpty()) {
            throw new ApiExecutionException("No query provided");
        }
        try {
            List v = this.vocabularyLookupService.search(name, body.get("query").asText());
            VocabularyDefinition vd = this.vocabularyDefinitionRepo.findCurrentByName(name);
            response.setLinks((JsonNode)this.getLinks(request.getRequestURL().toString()));
            response.setItems(this.getItems((Collection)v, request.getRequestURL().toString(), vd, body.has("ui") && body.get("ui").asBoolean()));
        }
        catch (VocabularyLookupException e) {
            e.printStackTrace();
        }
        return response;
    }

    @GetMapping(value={"/{name}/e/{key}"})
    public RestItemResponse getVocabularyEntry(@PathVariable(value="name") String name, @PathVariable(value="key") String key, HttpServletRequest request, Locale locale) throws ApiItemNotFoundException {
        RestItemResponse response = new RestItemResponse();
        Optional v = this.vocabularyRepo.findByDefinitionAndKey(name, key);
        if (v.isEmpty()) {
            throw new ApiItemNotFoundException("vocabularyEntry", key);
        }
        response.setLinks((JsonNode)this.getLinks(request.getRequestURL().toString()));
        response.setItem((JsonNode)this.getItem((Identifiable)((VocabularyEntry)v.get())));
        return response;
    }

    @PostMapping(value={"/{name}/e"})
    public RestItemResponse postVocabularyEntry(@PathVariable(value="name") String name, @RequestBody(required=false) JsonNode body, HttpServletRequest request, Locale locale) throws ApiItemNotFoundException, ApiExecutionException {
        RestItemResponse response = new RestItemResponse();
        if (body == null || !body.has("key") || body.get("key").asText().isEmpty()) {
            throw new ApiExecutionException("Key not provided");
        }
        Optional v = this.vocabularyRepo.findByDefinitionAndKey(name, body.get("key").asText());
        if (v.isEmpty()) {
            throw new ApiItemNotFoundException("vocabularyEntry", name + ":" + body.get("key").asText());
        }
        VocabularyDefinition vd = this.vocabularyDefinitionRepo.findCurrentByName(name);
        response.setLinks((JsonNode)this.getLinks(request.getRequestURL().toString()));
        response.setItem((JsonNode)this.getItem((VocabularyEntry)v.get(), request.getRequestURL().toString(), true, vd, body.has("ui") && body.get("ui").asBoolean()));
        return response;
    }

    protected ArrayNode getItems(Collection<VocabularyEntry> items, String requestUrl, VocabularyDefinition vd, boolean addViewItems) {
        ArrayNode array = this.jsonMapper.createArrayNode();
        if (items != null) {
            for (VocabularyEntry rec : items) {
                array.add((JsonNode)this.getItem(rec, requestUrl, true, vd, addViewItems));
            }
        }
        return array;
    }

    protected ObjectNode getItem(VocabularyEntry item, String requestUrl, boolean suffixUniqueId, VocabularyDefinition vd, boolean addViewItems) {
        ObjectNode recNode = (ObjectNode)this.jsonMapper.valueToTree((Object)item);
        if (addViewItems) {
            List previewProperties = PropertyPreviewHelper.get().extractSubproperties(vd.getPreviewProperties(), item.getProperties());
            recNode.set("_view", this.jsonMapper.valueToTree((Object)previewProperties));
            recNode.set("_display", (JsonNode)new TextNode(item.getPrimaryValue() + " (" + item.getKey() + ")"));
        }
        recNode.set("_links", (JsonNode)this.getItemLinks((Identifiable)item, requestUrl, suffixUniqueId));
        return recNode;
    }
}

