/*
 * Decompiled with CFR 0.152.
 */
package de.uniba.minf.registry.controller;

import com.fasterxml.jackson.databind.JsonNode;
import de.uniba.minf.core.rest.controller.BaseRestController;
import de.uniba.minf.core.rest.model.Identifiable;
import de.uniba.minf.core.rest.model.RestItemResponse;
import de.uniba.minf.core.rest.model.RestItemsResponse;
import de.uniba.minf.core.rest.model.RestResponse;
import de.uniba.minf.registry.model.ValueMapping;
import de.uniba.minf.registry.model.id.ValueMappingId;
import de.uniba.minf.registry.repository.ValueMappingRepository;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="Source value mappings")
@RestController
@RequestMapping(value={"/api/v1/vm"})
public class ValueMappingController
extends BaseRestController {
    private static final Logger log = LoggerFactory.getLogger(ValueMappingController.class);
    @Autowired
    private ValueMappingRepository valueMappingRepository;

    public ValueMappingController() {
        super("/api/v1/vm");
    }

    @GetMapping(value={"/{entityId}"})
    public RestItemsResponse getValueMappings(@PathVariable(value="entityId") String entityId, HttpServletRequest request, Locale locale) {
        RestItemsResponse resp = new RestItemsResponse();
        List valueMappings = this.valueMappingRepository.findBySourceEntityId(entityId);
        resp.setSize((long)valueMappings.size());
        resp.setItems(this.getItems((Collection)valueMappings));
        resp.setLinks((JsonNode)this.getLinks(request.getRequestURL().toString()));
        return resp;
    }

    @PostMapping(value={"/{entityId}"}, consumes={"application/json"})
    public RestItemResponse postValueMapping(@PathVariable(value="entityId") String entityId, @RequestBody JsonNode formData, HttpServletRequest request, Locale locale) {
        RestItemResponse response = new RestItemResponse();
        response.setItem(formData);
        if (!formData.isArray() || formData.size() <= 1 || formData.get(0).asText().isBlank() || formData.get(1).asText().isBlank()) {
            response.setAction(RestResponse.ApiActions.UNCHANGED);
            return response;
        }
        ValueMappingId vmId = new ValueMappingId(entityId, formData.get(0).asText());
        Optional existVm = this.valueMappingRepository.findById((Object)vmId);
        if (existVm.isPresent() && ((ValueMapping)existVm.get()).getAssignment().equals(formData.get(1).asText()) && ((ValueMapping)existVm.get()).isPreventResolve() == formData.get(2).asBoolean()) {
            response.setAction(RestResponse.ApiActions.UNCHANGED);
        } else if (existVm.isPresent()) {
            ((ValueMapping)existVm.get()).setAssignment(formData.get(1).asText());
            ((ValueMapping)existVm.get()).setPreventResolve(formData.get(2).asBoolean());
            this.valueMappingRepository.save((Object)((ValueMapping)existVm.get()));
            response.setAction(RestResponse.ApiActions.UPDATED);
        } else {
            ValueMapping newMapping = new ValueMapping();
            newMapping.setValueMappingId(vmId);
            newMapping.setAssignment(formData.get(1).asText());
            newMapping.setPreventResolve(formData.get(2).asBoolean());
            this.valueMappingRepository.save((Object)newMapping);
            response.setAction(RestResponse.ApiActions.CREATED);
        }
        return response;
    }

    @DeleteMapping(value={"/{entityId}"}, consumes={"application/json"})
    public RestItemResponse deleteValueMapping(@PathVariable(value="entityId") String entityId, @RequestBody JsonNode formData, HttpServletRequest request, Locale locale) {
        RestItemResponse response = new RestItemResponse();
        if (!formData.isArray() || formData.size() < 1 || formData.get(0).asText().isBlank()) {
            response.setAction(RestResponse.ApiActions.UNCHANGED);
            return response;
        }
        ValueMappingId vmId = new ValueMappingId(entityId, formData.get(0).asText());
        Optional existVm = this.valueMappingRepository.findById((Object)vmId);
        if (existVm.isPresent()) {
            response.setItem((JsonNode)this.getItem((Identifiable)((ValueMapping)existVm.get())));
            this.valueMappingRepository.delete((Object)((ValueMapping)existVm.get()));
            response.setAction(RestResponse.ApiActions.DELETED);
        } else {
            response.setAction(RestResponse.ApiActions.UNCHANGED);
        }
        return response;
    }
}

