/*
 * Decompiled with CFR 0.152.
 */
package de.uniba.minf.registry.controller;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import de.uniba.minf.core.rest.controller.BaseRestController;
import de.uniba.minf.core.rest.exception.ApiInsufficientPermissionsException;
import de.uniba.minf.core.rest.exception.ApiItemNotFoundException;
import de.uniba.minf.core.rest.model.Identifiable;
import de.uniba.minf.core.rest.model.RestActionResponse;
import de.uniba.minf.core.rest.model.RestItemResponse;
import de.uniba.minf.core.rest.model.RestItemsResponse;
import de.uniba.minf.core.rest.model.RestResponse;
import de.uniba.minf.registry.importer.ImportService;
import de.uniba.minf.registry.model.Import;
import de.uniba.minf.registry.model.ImportState;
import de.uniba.minf.registry.model.helper.PropertyDefinitionHelper;
import de.uniba.minf.registry.pojo.converter.ImportConverter;
import de.uniba.minf.registry.repository.ImportRepository;
import de.uniba.minf.registry.view.helper.PropertyDefinitionHelperService;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="Import", description="Access to records on processed import tasks (actual imports of entities are available with the methods of the entities API methods)")
@RestController
@RequestMapping(value={"/api/v1/imports"})
public class ImportController
extends BaseRestController {
    private static final String ITEM_TYPE = "import";
    @Autowired
    private ImportRepository importRepo;
    @Autowired
    private ImportService importService;
    @Autowired
    private ImportConverter importConverter;
    @Autowired
    private PropertyDefinitionHelperService propertyDefinitionHelperService;
    @Autowired
    private ObjectMapper objectMapper;

    public ImportController() {
        super("/api/v1/imports");
    }

    @GetMapping
    public RestItemsResponse getAllImports(HttpServletRequest request, Locale locale) throws ApiInsufficientPermissionsException, ApiItemNotFoundException {
        RestItemsResponse resp = new RestItemsResponse();
        Collection imports = this.importConverter.convertPojos((Collection)this.importRepo.findAll());
        resp.setSize((long)imports.size());
        resp.setItems(this.getItems(imports));
        resp.setLinks((JsonNode)this.getLinks(request.getRequestURL().toString()));
        return resp;
    }

    @GetMapping(value={"/source/{sourceId}"})
    public RestItemsResponse getImportsForSource(@PathVariable(value="sourceId") String sourceId, HttpServletRequest request, Locale locale) throws ApiInsufficientPermissionsException, ApiItemNotFoundException {
        RestItemsResponse resp = new RestItemsResponse();
        Collection imports = this.importConverter.convertPojos((Collection)this.importRepo.findBySourceEntityId(sourceId));
        resp.setSize((long)imports.size());
        resp.setItems(this.getItems(imports));
        resp.setLinks((JsonNode)this.getLinks(request.getRequestURL().toString()));
        return resp;
    }

    @GetMapping(value={"/state/source/{sourceId}"})
    public RestResponse validateEntities(@PathVariable(value="sourceId") String importId, HttpServletRequest req) {
        RestActionResponse.ApiActionStatus status = this.importService.getStatus(importId);
        if (status == RestActionResponse.ApiActionStatus.NONE) {
            return new RestActionResponse(status, req.getRequestURI());
        }
        if (status == RestActionResponse.ApiActionStatus.BUSY) {
            RestActionResponse response = new RestActionResponse(status, req.getRequestURI());
            ImportState state = this.importService.getImportState(importId);
            ObjectNode serverData = this.objectMapper.createObjectNode();
            serverData.set("importType", (JsonNode)new TextNode(state.getImportType().toString()));
            serverData.set("timestamp", (JsonNode)new TextNode(state.getCreation().toString()));
            response.setServerData((JsonNode)serverData);
            return response;
        }
        ImportState result = this.importService.getImportState(importId);
        RestItemsResponse response = new RestItemsResponse();
        if (result == null || result.getIm() == null) {
            response.setAction(RestResponse.ApiActions.UNCHANGED);
        } else {
            response.setAction(RestResponse.ApiActions.CREATED);
        }
        if (result != null && result.getEntities() != null) {
            PropertyDefinitionHelper.removeDefinitionsFromEntities((List)result.getEntities());
        }
        this.propertyDefinitionHelperService.mergeWithDefinition((Collection)result.getEntities(), true);
        response.setItems(this.getItems((Collection)result.getEntities()));
        ObjectNode dataNode = this.jsonMapper.createObjectNode();
        dataNode.set("success", (JsonNode)BooleanNode.valueOf((boolean)(result.getValidationMessageLists() == null ? false : result.getValidationMessageLists().stream().anyMatch(vl -> !vl.isEmpty()))));
        dataNode.set("importType", (JsonNode)new TextNode(result.getImportType().toString()));
        dataNode.set("externalIdIssues", (JsonNode)(result.isExternalIdIssues() ? BooleanNode.TRUE : BooleanNode.FALSE));
        dataNode.set("validationErrors", this.jsonMapper.valueToTree((Object)result.getValidationMessageLists()));
        dataNode.set("unknownProperties", this.jsonMapper.valueToTree((Object)result.getUnknownPropertyLists()));
        dataNode.set("resolvedVocabularyEntries", this.jsonMapper.valueToTree((Object)result.getResolvedVocabularyEntries()));
        response.setServerData((JsonNode)dataNode);
        return response;
    }

    @DeleteMapping(value={"/{uniqueId}"})
    public RestItemResponse deleteImport(@PathVariable(value="uniqueId") String uniqueId, HttpServletRequest request, Locale locale) throws ApiInsufficientPermissionsException, ApiItemNotFoundException {
        Optional i = this.importRepo.findById((Object)uniqueId);
        if (i.isEmpty()) {
            throw new ApiItemNotFoundException(ITEM_TYPE, uniqueId);
        }
        this.importService.deleteImport((Import)i.get());
        return this.getItemResponse((Identifiable)this.importConverter.convertPojo((Import)i.get()), request, RestResponse.ApiActions.DELETED);
    }
}

