/*
 * Decompiled with CFR 0.152.
 */
package de.uniba.minf.registry.controller;

import am.ik.yavi.core.ConstraintViolations;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import de.uniba.minf.core.rest.controller.BaseRestController;
import de.uniba.minf.core.rest.exception.ApiExecutionException;
import de.uniba.minf.core.rest.exception.ApiItemNotFoundException;
import de.uniba.minf.core.rest.model.ErrorRestResponse;
import de.uniba.minf.core.rest.model.RestActionResponse;
import de.uniba.minf.core.rest.model.RestItemResponse;
import de.uniba.minf.core.rest.model.RestItemsResponse;
import de.uniba.minf.core.rest.model.RestResponse;
import de.uniba.minf.registry.config.WebConfig;
import de.uniba.minf.registry.importer.ImportRunner;
import de.uniba.minf.registry.importer.ImportService;
import de.uniba.minf.registry.model.BaseDefinedObject;
import de.uniba.minf.registry.model.ConfigurableEntity;
import de.uniba.minf.registry.model.Property;
import de.uniba.minf.registry.model.PropertyValue;
import de.uniba.minf.registry.model.definition.BaseDefinition;
import de.uniba.minf.registry.model.definition.EntityDefinition;
import de.uniba.minf.registry.model.entity.Entity;
import de.uniba.minf.registry.model.helper.PropertyDefinitionHelper;
import de.uniba.minf.registry.model.validation.exception.ValidationConfigurationException;
import de.uniba.minf.registry.repository.EntityDefinitionRepository;
import de.uniba.minf.registry.repository.EntityRepository;
import de.uniba.minf.registry.repository.ValueMappingRepository;
import de.uniba.minf.registry.service.EntityCompositingService;
import de.uniba.minf.registry.service.EntityCompositingServiceImpl;
import de.uniba.minf.registry.service.EntityDefinitionService;
import de.uniba.minf.registry.service.EntityService;
import de.uniba.minf.registry.view.helper.PropertyDefinitionHelperService;
import de.uniba.minf.registry.view.helper.PropertyPreviewHelper;
import de.uniba.minf.registry.view.model.ValidationViolationMessage;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.javers.core.diff.Diff;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.http.HttpStatus;
import org.springframework.util.StopWatch;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="Entities", description="Methods for reading and writing entities.")
@RestController
@RequestMapping(value={"/api/v1/e"})
public class EntityController
extends BaseRestController
implements ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(EntityController.class);
    @Autowired
    private EntityRepository entityRepo;
    @Autowired
    private EntityDefinitionRepository entityDefRepo;
    @Autowired
    private EntityDefinitionService entityDefService;
    @Autowired
    private PropertyDefinitionHelperService propertyDefinitionHelperService;
    @Autowired
    private EntityService entityService;
    @Autowired
    private ImportService importService;
    @Autowired
    private EntityCompositingService compositingService;
    @Autowired
    private ValueMappingRepository valueMappingRepository;
    @Autowired
    private WebConfig webConfig;
    private ApplicationContext appContext;

    public EntityController() {
        super("/api/v1/e");
    }

    public void setApplicationContext(ApplicationContext appContext) throws BeansException {
        this.appContext = appContext;
    }

    @GetMapping
    public RestItemsResponse get(HttpServletRequest request, Locale locale) {
        RestItemsResponse response = new RestItemsResponse();
        List entities = this.entityRepo.findAll();
        this.propertyDefinitionHelperService.mergeWithDefinition((Collection)entities, true);
        response.setSize((long)entities.size());
        response.setLinks((JsonNode)this.getLinks(request.getRequestURL().toString()));
        response.setItems(this.getItems((Collection)entities));
        return response;
    }

    @GetMapping(value={"/{id}"})
    public Entity get(@PathVariable(value="id") String id, Locale locale) {
        Optional entity = this.entityService.findLatestByEntityId(id, true);
        if (entity.isPresent()) {
            this.propertyDefinitionHelperService.mergeWithDefinition((BaseDefinedObject)entity.get(), true);
            return (Entity)entity.get();
        }
        return this.entityService.findById(id, true).orElse(null);
    }

    @GetMapping(value={"/{name}/"})
    public RestItemsResponse getByDefinition(@PathVariable(value="name") String name, @RequestParam(name="includeDrafts", defaultValue="false") boolean includeDrafts, @RequestParam(name="ui", defaultValue="false") boolean ui, @RequestParam(name="lang", required=false) String lang, HttpServletRequest request, Locale locale) {
        StopWatch sw = new StopWatch();
        sw.start("initial loading");
        RestItemsResponse response = new RestItemsResponse();
        List<Entity> entities = this.entityService.findLatestByDefinition(name, this.authInfoHelper.getAuth().isAuth() || includeDrafts, false);
        sw.stop();
        sw.start("further loading");
        List entityIds = entities.stream().filter(e -> e.getLayersEntityIds() != null).flatMap(e -> e.getLayersEntityIds().stream()).toList();
        entities = entities.stream().filter(e -> !entityIds.contains(e.getEntityId())).toList();
        this.entityService.loadLayers(entities);
        this.compositingService.composeLayers(entities);
        this.propertyDefinitionHelperService.mergeWithDefinition(entities, true);
        response.setSize((long)entities.size());
        response.setLinks((JsonNode)this.getLinks(request.getRequestURL().toString()));
        if (lang != null) {
            Map<String, EntityDefinition> definitions = this.entityDefService.findAllCurrent().stream().collect(Collectors.toMap(BaseDefinition::getName, ed -> ed));
            Locale l = Locale.forLanguageTag(lang.contains("_") ? lang.substring(0, lang.indexOf("_")) : lang);
            response.setItems(this.getItems(entities.stream().map(e -> {
                ConfigurableEntity confE = new ConfigurableEntity(e);
                confE.setLang(l.getISO3Language());
                if (e.getRelatedEntityCache() != null && !e.getRelatedEntityCache().isEmpty()) {
                    confE.setEntityDisplayStrings(new HashMap());
                    for (Entity relEntity : e.getRelatedEntityCache().values()) {
                        EntityDefinition ed = (EntityDefinition)definitions.get(relEntity.getDefinitionName());
                        List prevProperties = PropertyPreviewHelper.get().extractSubproperties(ed.getPreviewProperties(), relEntity.getProperties());
                        String displayString = PropertyPreviewHelper.get().getDisplayString(prevProperties, relEntity.getEntityId(), locale);
                        confE.getEntityDisplayStrings().put(relEntity.getEntityId(), displayString);
                    }
                }
                return confE;
            }).toList()));
        } else {
            response.setItems(this.getItems(entities));
        }
        sw.stop();
        log.debug("Loading and serializing entities took " + sw.prettyPrint());
        return response;
    }

    @GetMapping(value={"/i/{importId}/"})
    public RestItemsResponse getByImportId(@PathVariable(value="importId") String importId, HttpServletRequest request, Locale locale) {
        RestItemsResponse response = new RestItemsResponse();
        Collection entities = this.entityRepo.findByImportId(importId);
        this.propertyDefinitionHelperService.mergeWithDefinition(entities, true);
        response.setSize((long)entities.size());
        response.setLinks((JsonNode)this.getLinks(request.getRequestURL().toString()));
        response.setItems(this.getItems(entities));
        return response;
    }

    @PostMapping(value={"/{name}/search"})
    public RestItemsResponse searchEntries(@PathVariable(value="name") String name, @RequestBody(required=false) JsonNode body, HttpServletRequest request, Locale locale) throws ApiExecutionException {
        RestItemsResponse response = new RestItemsResponse();
        if (body == null || !body.has("query") || body.get("query").asText().isEmpty()) {
            throw new ApiExecutionException("No query provided");
        }
        EntityDefinition ed = this.entityDefRepo.findCurrentByName(name);
        ArrayList entities = new ArrayList();
        this.entityService.addAllNotContainingIdentifier(ed, entities, this.entityRepo.findLatestByDefinitionAndQuery(name, body.get("query").asText()));
        if (ed.hasAutoqueryProperties()) {
            this.entityService.addAllNotContainingIdentifier(ed, entities, (Collection)this.entityService.createEntitiesByAutoquery(name, body.get("query").asText()));
        }
        this.propertyDefinitionHelperService.mergeWithDefinition(entities, true);
        response.setSize((long)entities.size());
        response.setLinks((JsonNode)this.getLinks(request.getRequestURL().toString()));
        response.setItems(this.getItems(entities, ed, body.has("ui") && body.get("ui").asBoolean(), locale));
        return response;
    }

    @PostMapping(value={"/{name}/get"})
    public RestItemResponse getEntry(@PathVariable(value="name") String name, @RequestBody(required=false) JsonNode body, HttpServletRequest request, Locale locale) throws ApiItemNotFoundException, ApiExecutionException {
        RestItemResponse response = new RestItemResponse();
        String entityId = null;
        String uniqueId = null;
        if (body != null && body.has("entityId") && !body.get("entityId").asText().isEmpty()) {
            entityId = body.get("entityId").asText();
        } else if (body != null && body.has("uniqueId") && !body.get("uniqueId").asText().isEmpty()) {
            uniqueId = body.get("uniqueId").asText();
        } else {
            throw new ApiExecutionException("Neither EntityId or UniqueId provided");
        }
        Optional entity = entityId != null ? this.entityRepo.findLatestByEntityId(entityId) : this.entityRepo.findById((Object)uniqueId);
        if (entity.isEmpty()) {
            throw new ApiItemNotFoundException("entity", entityId == null ? uniqueId : entityId);
        }
        EntityDefinition ed = this.entityDefRepo.findCurrentByName(name);
        response.setLinks((JsonNode)this.getLinks(request.getRequestURL().toString()));
        response.setItem((JsonNode)this.getItem((Entity)entity.get(), ed, body.has("ui") && body.get("ui").asBoolean(), locale));
        return response;
    }

    @PostMapping(value={"/", "/{entityId}"}, consumes={"application/json"})
    public RestResponse postEntityForm(@PathVariable(required=false, value="entityId") String entityId, @RequestBody JsonNode formData, HttpServletRequest req, HttpServletResponse resp, Locale locale) throws ValidationConfigurationException, ApiExecutionException {
        boolean validateOnly = req.getHeader("Entity-Validate-Only") != null && req.getHeader("Entity-Validate-Only").equals("true");
        boolean changeToDraft = req.getHeader("Entity-Save-Draft") != null && req.getHeader("Entity-Save-Draft").equals("true");
        boolean changeToPublished = req.getHeader("Entity-Save-Published") != null && req.getHeader("Entity-Save-Published").equals("true");
        boolean copyAsTemplate = req.getHeader("Entity-Save-Template") != null && req.getHeader("Entity-Save-Template").equals("true");
        Entity e = this.entityService.prepareEntity(entityId, this.getEntityDefinitionFromDataArray(formData), copyAsTemplate, changeToDraft, changeToPublished);
        EntityDefinition ed = this.entityDefService.findCurrentByName(e.getDefinitionName(), true);
        if (!ed.isLocalCreation()) {
            throw new ApiExecutionException("Entity definition defined as localCreation: false -> no local entries");
        }
        this.entityService.fillEntityFromDataArray(e, formData);
        PropertyDefinitionHelper.mergeWithDefinition((BaseDefinedObject)e, (BaseDefinition)ed, (boolean)false);
        this.entityService.autopopulateVocabularyData(e, ed);
        if (ed.isCompositing()) {
            this.entityService.loadLayers(e);
            this.compositingService.composeLayers(e, EntityCompositingServiceImpl.CompositionMode.PERSISTING);
        }
        if (validateOnly || e.isPublished()) {
            try {
                ConstraintViolations violations = this.entityService.validateEntity(ed, e);
                if (!violations.isValid()) {
                    return this.buildValidationFailedResponse(violations, req, resp, locale);
                }
                if (validateOnly) {
                    return this.buildItemResponse(RestResponse.ApiActions.VALIDATED, e);
                }
                e.setValid(violations.isValid());
            }
            catch (ValidationConfigurationException e1) {
                log.error("Entity validation failed with ValidationConfigurationException", (Throwable)e1);
                throw e1;
            }
        }
        PropertyDefinitionHelper.mergeWithDefinition((BaseDefinedObject)e, (BaseDefinition)ed, (boolean)true);
        this.entityService.setOrCreateRelatedEntities(e, ed);
        this.compositingService.removeLayers(e);
        if (e.getEntityId() == null && (e.getProperties() != null && !e.getProperties().isEmpty() || e.getLayersEntityIds() != null && !e.getLayersEntityIds().isEmpty())) {
            return this.buildItemResponse(RestResponse.ApiActions.CREATED, this.entityService.save(e));
        }
        if (e.getEntityId() == null) {
            return this.buildItemResponse(RestResponse.ApiActions.UNCHANGED, e);
        }
        Diff diff = this.entityService.getChanges(e);
        if (diff.hasChanges() || changeToDraft || changeToPublished) {
            return this.buildItemResponse(RestResponse.ApiActions.UPDATED, this.entityService.save(e));
        }
        return this.buildItemResponse(RestResponse.ApiActions.UNCHANGED, e);
    }

    @DeleteMapping(value={"/{entityId}"})
    public RestResponse deleteEntity(@PathVariable(required=false, value="entityId") String entityId, HttpServletResponse resp, Locale locale) {
        Optional eExist = this.entityRepo.findLatestByEntityId(entityId);
        if (eExist.isPresent()) {
            ((Entity)eExist.get()).setDeleted(true);
            this.entityRepo.save((Object)((Entity)eExist.get()));
        }
        log.debug(entityId);
        RestItemResponse response = new RestItemResponse();
        response.setAction(RestResponse.ApiActions.DELETED);
        return response;
    }

    @PostMapping(value={"/{name}/validate"}, consumes={"application/json"})
    public RestResponse validateEntities(@PathVariable(value="name") String name, @RequestBody String body, HttpServletRequest req, HttpServletResponse resp, Locale locale) throws JsonProcessingException, ValidationConfigurationException, UnsupportedEncodingException, URISyntaxException {
        return this.validateOrImportEntities(name, body, req, resp, locale, true);
    }

    @PostMapping(value={"/{name}/import"}, consumes={"application/json"})
    public RestResponse importEntities(@PathVariable(value="name") String name, @RequestBody String body, HttpServletRequest req, HttpServletResponse resp, Locale locale) throws ValidationConfigurationException, JsonMappingException, JsonProcessingException, UnsupportedEncodingException, URISyntaxException {
        return this.validateOrImportEntities(name, body, req, resp, locale, false);
    }

    private RestResponse validateOrImportEntities(String name, String envelope, HttpServletRequest req, HttpServletResponse resp, Locale locale, boolean validateOnly) throws JsonMappingException, JsonProcessingException, UnsupportedEncodingException, URISyntaxException {
        Property pUrl;
        String sourceEntityId;
        JsonNode n = this.jsonMapper.readTree(envelope);
        String string = sourceEntityId = n.has("sourceEntityId") ? n.get("sourceEntityId").asText() : null;
        if (sourceEntityId == null) {
            return this.buildFailedWithExceptionResponse("source", "source_id_missing", this.messageSource.getMessage("view.import.messages.source_id_missing", null, locale), null, req, resp, locale);
        }
        Optional source = this.entityService.findLatestByEntityId(sourceEntityId);
        if (source.isEmpty()) {
            return this.buildFailedWithExceptionResponse(HttpStatus.NOT_FOUND, "source", "source_not_found", this.messageSource.getMessage("view.import.messages.source_not_found", null, locale), null, req, resp, locale);
        }
        ImportRunner ir = (ImportRunner)this.appContext.getBean(ImportRunner.class);
        ir.setFormat(((Entity)source.get()).get("format").getValue().asText());
        ir.setValidateOnly(validateOnly);
        ir.setDefinition(name);
        ir.setUserId(this.authInfoHelper.getUserId());
        ir.setReadOnly(true);
        ir.setSourceEntityId(sourceEntityId);
        ir.setCreation(Instant.now());
        Property pTemplate = ((Entity)source.get()).get("template");
        if (pTemplate != null && !pTemplate.isMissing()) {
            ir.setTemplate(pTemplate.getValue().asText());
        }
        if ((pUrl = ((Entity)source.get()).get("url")) == null || pUrl.valuesAsList().isEmpty()) {
            return this.buildFailedWithExceptionResponse("source", "url_missing", this.messageSource.getMessage("view.import.messages.url_missing", null, locale), null, req, resp, locale);
        }
        ir.setUrls(new ArrayList());
        for (PropertyValue pvUrl : pUrl.valuesAsList()) {
            if (pvUrl == null || pvUrl.asText().isBlank()) continue;
            try {
                URL u = new URL(pvUrl.asText());
                HttpURLConnection huc = (HttpURLConnection)u.openConnection();
                huc.setRequestMethod("HEAD");
                huc.setInstanceFollowRedirects(true);
                huc.connect();
                int code = huc.getResponseCode();
                if (code < 200 || code > 400) {
                    return this.buildFailedWithExceptionResponse(HttpStatus.valueOf((int)code), this.messageSource.getMessage("view.import.messages.url_invalid", null, locale), null, req, resp, locale);
                }
                ir.getUrls().add(pvUrl.asText());
            }
            catch (MalformedURLException e) {
                return this.buildFailedWithExceptionResponse("import-data-url", "import-data-url", this.messageSource.getMessage("view.import.messages.url_invalid", null, locale), (Exception)e, req, resp, locale);
            }
            catch (IOException e) {
                return this.buildFailedWithExceptionResponse(HttpStatus.BAD_REQUEST, this.messageSource.getMessage("view.import.messages.url_invalid", null, locale) + ": " + e.getLocalizedMessage(), null, req, resp, locale);
            }
        }
        ir.setValueMap(this.valueMappingRepository.findBySourceEntityId(sourceEntityId).stream().collect(Collectors.toMap(vm -> vm.getValue(), vm -> vm)));
        this.importService.importAsync(ir);
        return new RestActionResponse(RestActionResponse.ApiActionStatus.STARTED, this.webConfig.getBaseUrlObj().getAbsoluteUrl("/api/v1/imports/state/source/%s", new String[]{sourceEntityId}));
    }

    private String getEntityDefinitionFromDataArray(JsonNode formData) {
        for (JsonNode fieldNode : formData) {
            if (!fieldNode.get("name").asText().equals("_entity")) continue;
            return fieldNode.get("value").asText();
        }
        return null;
    }

    private RestItemResponse buildItemResponse(RestResponse.ApiActions action, Entity e) {
        RestItemResponse response = new RestItemResponse();
        response.setAction(action);
        response.setItem(this.jsonMapper.valueToTree((Object)e));
        return response;
    }

    private ErrorRestResponse buildValidationFailedResponse(ConstraintViolations violations, HttpServletRequest req, HttpServletResponse resp, Locale locale) {
        ErrorRestResponse response = new ErrorRestResponse(HttpStatus.BAD_REQUEST.value(), this.messageSource.getMessage("view.import.messages.validation_result_invalid", null, locale), req.getRequestURL().toString());
        ArrayList validationMessages = new ArrayList();
        violations.forEach(x -> validationMessages.add(new ValidationViolationMessage(this.convertValidationConstraintNameToViewPropertyLabel(x.name()), x.messageKey(), this.messageSource.getMessage("validation.violation." + x.messageKey(), x.args(), locale), x.args()[x.args().length - 1])));
        response.setErrorDetails(this.jsonMapper.valueToTree(validationMessages));
        resp.setStatus(HttpStatus.BAD_REQUEST.value());
        return response;
    }

    private ErrorRestResponse buildFailedWithExceptionResponse(HttpStatus code, String message, Exception ex, HttpServletRequest req, HttpServletResponse resp, Locale locale) {
        return this.buildFailedWithExceptionResponse(code, null, null, message, ex, req, resp, locale);
    }

    private ErrorRestResponse buildFailedWithExceptionResponse(String name, String key, String message, Exception ex, HttpServletRequest req, HttpServletResponse resp, Locale locale) {
        return this.buildFailedWithExceptionResponse(HttpStatus.BAD_REQUEST, name, key, message, ex, req, resp, locale);
    }

    private ErrorRestResponse buildFailedWithExceptionResponse(HttpStatus code, String name, String key, String message, Exception ex, HttpServletRequest req, HttpServletResponse resp, Locale locale) {
        ErrorRestResponse response = new ErrorRestResponse(code.value(), message, req.getRequestURL().toString());
        if (name != null || key != null) {
            ArrayList<ValidationViolationMessage> validationMessages = new ArrayList<ValidationViolationMessage>();
            validationMessages.add(new ValidationViolationMessage(name, key, ex == null ? this.messageSource.getMessage("view.import.messages.generic_exception", null, locale) : ex.getLocalizedMessage(), null));
            response.setErrorDetails(this.jsonMapper.valueToTree(validationMessages));
        }
        resp.setStatus(code.value());
        return response;
    }

    private String convertValidationConstraintNameToViewPropertyLabel(String name) {
        String[] nameParts = name.split("\\.");
        StringBuilder propertyLabelBuilder = new StringBuilder();
        for (String part : nameParts) {
            if (part.startsWith("_")) continue;
            if (!propertyLabelBuilder.isEmpty()) {
                propertyLabelBuilder.append(".");
            }
            propertyLabelBuilder.append(part);
        }
        return propertyLabelBuilder.toString();
    }

    private ArrayNode getItems(Collection<Entity> items, EntityDefinition ed, boolean addViewItems, Locale locale) {
        ArrayNode array = this.jsonMapper.createArrayNode();
        if (items != null) {
            for (Entity rec : items) {
                array.add((JsonNode)this.getItem(rec, ed, addViewItems, locale));
            }
        }
        return array;
    }

    private ObjectNode getItem(Entity item, EntityDefinition ed, boolean addViewItems, Locale locale) {
        ObjectNode recNode = (ObjectNode)this.jsonMapper.valueToTree((Object)item);
        if (addViewItems) {
            List previewProperties = PropertyPreviewHelper.get().extractSubproperties(ed.getPreviewProperties(), item.getProperties());
            recNode.set("_view", this.jsonMapper.valueToTree((Object)previewProperties));
            recNode.set("_display", this.jsonMapper.valueToTree((Object)PropertyPreviewHelper.get().getDisplayString(previewProperties, item.getEntityId(), locale)));
        }
        return recNode;
    }
}

