/*
 * Decompiled with CFR 0.152.
 */
package de.uniba.minf.registry.config.db;

import de.uniba.minf.auth.spring.mvc.AuthInfoHelper;
import de.uniba.minf.registry.model.vocabulary.VocabularyEntry;
import java.time.Instant;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.mongodb.core.mapping.event.AbstractMongoEventListener;
import org.springframework.data.mongodb.core.mapping.event.BeforeConvertEvent;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;

@Configuration
public class VocabularyEntryEventListener
extends AbstractMongoEventListener<VocabularyEntry> {
    @Autowired
    private AuthInfoHelper authinfoHelper;

    public void onBeforeConvert(BeforeConvertEvent<VocabularyEntry> event) {
        super.onBeforeConvert(event);
        RequestAttributes attrs = RequestContextHolder.getRequestAttributes();
        String userUniqueId = attrs != null ? this.authinfoHelper.getAuth().getUserId() : "_system";
        VocabularyEntry obj = (VocabularyEntry)event.getSource();
        obj.setCreationInstant(Instant.now());
        obj.setUserUniqueId(userUniqueId);
        obj.setScore(0.0);
    }
}

