/*
 * Decompiled with CFR 0.152.
 */
package de.uniba.minf.registry.config.db;

import de.uniba.minf.auth.spring.mvc.AuthInfoHelper;
import de.uniba.minf.registry.model.definition.BaseDefinition;
import de.uniba.minf.registry.model.definition.EntityDefinition;
import de.uniba.minf.registry.model.vocabulary.VocabularyDefinition;
import de.uniba.minf.registry.repository.EntityDefinitionRepository;
import de.uniba.minf.registry.repository.VocabularyDefinitionRepository;
import java.time.Instant;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.mapping.event.AbstractMongoEventListener;
import org.springframework.data.mongodb.core.mapping.event.AfterSaveEvent;
import org.springframework.data.mongodb.core.mapping.event.BeforeConvertEvent;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.data.mongodb.core.query.UpdateDefinition;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;

@Configuration
public class BaseDefinitionEventListener
extends AbstractMongoEventListener<BaseDefinition> {
    @Autowired
    private AuthInfoHelper authinfoHelper;
    @Autowired
    private VocabularyDefinitionRepository vocabularyDefinitionRepository;
    @Autowired
    private EntityDefinitionRepository entityDefinitionRepository;
    @Autowired
    private MongoTemplate mongoTemplate;

    public void onBeforeConvert(BeforeConvertEvent<BaseDefinition> event) {
        super.onBeforeConvert(event);
        RequestAttributes attrs = RequestContextHolder.getRequestAttributes();
        String userUniqueId = attrs != null ? this.authinfoHelper.getAuth().getUserId() : "_system";
        BaseDefinition def = (BaseDefinition)event.getSource();
        def.setCreationInstant(Instant.now());
        def.setUserUniqueId(userUniqueId);
        VocabularyDefinition cDef = null;
        if (VocabularyDefinition.class.isAssignableFrom(((BaseDefinition)event.getSource()).getClass())) {
            cDef = this.vocabularyDefinitionRepository.findCurrentByName(((BaseDefinition)event.getSource()).getName());
        } else if (EntityDefinition.class.isAssignableFrom(((BaseDefinition)event.getSource()).getClass())) {
            cDef = this.entityDefinitionRepository.findCurrentByName(((BaseDefinition)event.getSource()).getName());
        }
        if (cDef != null) {
            def.setVersion(cDef.getVersion() + 1L);
        } else {
            def.setVersion(1L);
        }
    }

    public void onAfterSave(AfterSaveEvent<BaseDefinition> event) {
        super.onAfterSave(event);
        this.mongoTemplate.updateMulti(Query.query((CriteriaDefinition)Criteria.where((String)"name").is((Object)((BaseDefinition)event.getSource()).getName()).and("nextVersionUniqueId").isNull().and("uniqueId").ne((Object)((BaseDefinition)event.getSource()).getUniqueId())), (UpdateDefinition)Update.update((String)"nextVersionUniqueId", (Object)((BaseDefinition)event.getSource()).getUniqueId()), VocabularyDefinition.class.isAssignableFrom(((BaseDefinition)event.getSource()).getClass()) ? VocabularyDefinition.class : EntityDefinition.class);
    }
}

