/*
 * Decompiled with CFR 0.152.
 */
package de.uniba.minf.registry.config;

import de.uniba.minf.auth.spring.config.SecurityConfig;
import org.pac4j.core.authorization.authorizer.RequireAnyRoleAuthorizer;
import org.pac4j.core.config.Config;
import org.pac4j.core.context.HttpConstants;
import org.pac4j.core.matching.matcher.HttpMethodMatcher;
import org.pac4j.springframework.annotation.AnnotationConfig;
import org.pac4j.springframework.component.ComponentConfig;
import org.pac4j.springframework.web.SecurityInterceptor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
@Import(value={ComponentConfig.class, AnnotationConfig.class})
public class WebSecurityConfig
implements WebMvcConfigurer {
    @Autowired
    private Config config;
    @Autowired
    private SecurityConfig securityConfig;

    public void addInterceptors(InterceptorRegistry registry) {
        if (!this.securityConfig.isEnabled()) {
            return;
        }
        registry.addInterceptor((HandlerInterceptor)this.buildInterceptor(this.securityConfig.getIndirectStartClientName())).addPathPatterns(new String[]{"/protected/**", "/imports/**"});
        registry.addInterceptor((HandlerInterceptor)this.buildInterceptor("saml")).addPathPatterns(new String[]{"/protected_saml/*"});
        SecurityInterceptor interceptor = SecurityInterceptor.build((Object[])new Object[]{this.config, this.securityConfig.getIndirectStartClientName(), new RequireAnyRoleAuthorizer(new String[]{"ROLE_ADMINISTRATOR"})});
        registry.addInterceptor((HandlerInterceptor)interceptor).addPathPatterns(new String[]{"/notes/**", "/admin/**"});
        SecurityInterceptor modifyingRestCallInterceptor = SecurityInterceptor.build((Object[])new Object[]{this.config, this.securityConfig.getDirectClientNames(), new HttpMethodMatcher(new HttpConstants.HTTP_METHOD[]{HttpConstants.HTTP_METHOD.DELETE, HttpConstants.HTTP_METHOD.POST, HttpConstants.HTTP_METHOD.PUT})});
        registry.addInterceptor((HandlerInterceptor)modifyingRestCallInterceptor).addPathPatterns(new String[]{"/api/**"});
    }

    private SecurityInterceptor buildInterceptor(String client) {
        return SecurityInterceptor.build((Object[])new Object[]{this.config, client});
    }
}

