/*
 * Decompiled with CFR 0.152.
 */
package de.uniba.minf.registry.config;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import de.uniba.minf.registry.config.WebConfig;
import de.uniba.minf.registry.model.ConfigurableEntity;
import de.uniba.minf.registry.model.definition.EntityDefinition;
import de.uniba.minf.registry.model.entity.Entity;
import de.uniba.minf.registry.model.serialization.EntityDefinitionDeserializer;
import de.uniba.minf.registry.model.serialization.EntityDefinitionSerializer;
import de.uniba.minf.registry.model.serialization.EntityDeserializer;
import de.uniba.minf.registry.model.serialization.EntitySerializer;
import de.uniba.minf.registry.model.serialization.VocabularyDefinitionDeserializer;
import de.uniba.minf.registry.model.serialization.VocabularyDefinitionSerializer;
import de.uniba.minf.registry.model.serialization.VocabularyEntryDeserializer;
import de.uniba.minf.registry.model.vocabulary.VocabularyDefinition;
import de.uniba.minf.registry.model.vocabulary.VocabularyEntry;
import org.apache.tika.Tika;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;

@Configuration
public class SerializationConfig {
    @Autowired
    private WebConfig webConfig;

    @Bean(value={"jsonMapper"})
    @Primary
    ObjectMapper jsonMapper(SimpleModule serializationModule) {
        ObjectMapper jsonMapper = new ObjectMapper();
        jsonMapper.registerModule((Module)serializationModule);
        jsonMapper.registerModule((Module)this.javaTimeModule());
        jsonMapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
        jsonMapper.setSerializationInclusion(JsonInclude.Include.NON_DEFAULT);
        return jsonMapper;
    }

    @Bean(value={"yamlMapper"})
    ObjectMapper yamlMapper(SimpleModule serializationModule) {
        ObjectMapper yamlMapper = new ObjectMapper((JsonFactory)new YAMLFactory());
        yamlMapper.registerModule((Module)serializationModule);
        yamlMapper.registerModule((Module)this.javaTimeModule());
        yamlMapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
        yamlMapper.setSerializationInclusion(JsonInclude.Include.NON_DEFAULT);
        return yamlMapper;
    }

    @Bean
    @Primary
    SimpleModule serializationModule(EntityDeserializer entityDeserializer, VocabularyEntryDeserializer vocabularyEntryDeserializer, EntitySerializer entitySerializer) {
        SimpleModule module = new SimpleModule();
        module.addDeserializer(Entity.class, (JsonDeserializer)entityDeserializer);
        module.addDeserializer(VocabularyEntry.class, (JsonDeserializer)vocabularyEntryDeserializer);
        module.addSerializer(Entity.class, (JsonSerializer)entitySerializer);
        module.addSerializer(ConfigurableEntity.class, (JsonSerializer)entitySerializer);
        module.addDeserializer(EntityDefinition.class, (JsonDeserializer)new EntityDefinitionDeserializer());
        module.addDeserializer(VocabularyDefinition.class, (JsonDeserializer)new VocabularyDefinitionDeserializer());
        module.addSerializer(EntityDefinition.class, (JsonSerializer)new EntityDefinitionSerializer());
        module.addSerializer(VocabularyDefinition.class, (JsonSerializer)new VocabularyDefinitionSerializer());
        return module;
    }

    @Bean
    EntityDeserializer entityDeserializer() {
        return new EntityDeserializer();
    }

    @Bean
    EntitySerializer entitySerializer() {
        EntitySerializer entitySerializer = new EntitySerializer();
        entitySerializer.setBaseUrl(this.webConfig.getBaseUrlObj());
        return entitySerializer;
    }

    @Bean
    VocabularyEntryDeserializer vocabularyEntryDeserializer() {
        return new VocabularyEntryDeserializer();
    }

    @Bean
    JavaTimeModule javaTimeModule() {
        return new JavaTimeModule();
    }

    @Bean
    Tika tika() {
        return new Tika();
    }
}

