/*
 * Decompiled with CFR 0.152.
 */
package de.uniba.minf.registry.config;

import com.mongodb.ConnectionString;
import com.mongodb.MongoClientSettings;
import jakarta.validation.Validator;
import java.util.Collection;
import java.util.Collections;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.mongodb.config.AbstractMongoClientConfiguration;
import org.springframework.data.mongodb.core.mapping.event.ValidatingMongoEventListener;
import org.springframework.data.mongodb.repository.config.EnableMongoRepositories;
import org.springframework.validation.beanvalidation.LocalValidatorFactoryBean;

@Configuration
@ConfigurationProperties(prefix="mongodb")
@EnableMongoRepositories(basePackages={"de.uniba.minf.registry.repository"})
public class BackendConfig
extends AbstractMongoClientConfiguration {
    private String host = "localhost";
    private String port = "27017";
    private String databaseName = "registry";
    private String username;
    private String password;
    private String authCollection;

    @Bean
    ValidatingMongoEventListener validatingMongoEventListener() {
        return new ValidatingMongoEventListener((Validator)this.validator());
    }

    @Bean
    LocalValidatorFactoryBean validator() {
        return new LocalValidatorFactoryBean();
    }

    protected void configureClientSettings(MongoClientSettings.Builder builder) {
        String uri = this.username != null && this.password != null ? (this.authCollection != null ? String.format("mongodb://%s:%s@%s:%s/%s?authSource=%s", this.username, this.password, this.host, this.port, this.databaseName, this.authCollection) : String.format("mongodb://%s:%s@%s:%s/%s", this.username, this.password, this.host, this.port, this.databaseName)) : String.format("mongodb://%s:%s/%s", this.host, this.port, this.databaseName);
        builder.applyConnectionString(new ConnectionString(uri));
    }

    protected boolean autoIndexCreation() {
        return true;
    }

    public Collection<String> getMappingBasePackages() {
        return Collections.singleton("de.uniba.minf.registry.model");
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getPort() {
        return this.port;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getAuthCollection() {
        return this.authCollection;
    }

    public void setAuthCollection(String authCollection) {
        this.authCollection = authCollection;
    }
}

