/*
 * Decompiled with CFR 0.152.
 */
package de.uniba.minf.registry.view.helper;

import de.uniba.minf.registry.model.BaseDefinedObject;
import de.uniba.minf.registry.model.definition.BaseDefinition;
import de.uniba.minf.registry.model.definition.EntityDefinition;
import de.uniba.minf.registry.model.helper.PropertyDefinitionHelper;
import de.uniba.minf.registry.repository.EntityDefinitionRepository;
import java.lang.invoke.CallSite;
import java.util.Collection;
import java.util.HashMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PropertyDefinitionHelperService {
    @Autowired
    private EntityDefinitionRepository entityDefRepo;

    public void mergeWithDefinition(Collection<? extends BaseDefinedObject> objects, boolean removeUnknown) {
        HashMap<CallSite, EntityDefinition> definitionMap = new HashMap<CallSite, EntityDefinition>();
        for (BaseDefinedObject baseDefinedObject : objects) {
            if (definitionMap.containsKey(baseDefinedObject.getDefinitionName() + "." + baseDefinedObject.getDefinitionVersion())) {
                PropertyDefinitionHelper.mergeWithDefinition((BaseDefinedObject)baseDefinedObject, (BaseDefinition)((BaseDefinition)definitionMap.get(baseDefinedObject.getDefinitionName() + "." + baseDefinedObject.getDefinitionVersion())), (boolean)true);
                continue;
            }
            EntityDefinition ed = this.entityDefRepo.findByNameAndVersion(baseDefinedObject.getDefinitionName(), baseDefinedObject.getDefinitionVersion());
            if (ed == null) {
                ed = this.entityDefRepo.findCurrentByName(baseDefinedObject.getDefinitionName());
            }
            definitionMap.put((CallSite)((Object)(baseDefinedObject.getDefinitionName() + "." + baseDefinedObject.getDefinitionVersion())), ed);
            PropertyDefinitionHelper.mergeWithDefinition((BaseDefinedObject)baseDefinedObject, (BaseDefinition)ed, (boolean)removeUnknown);
        }
    }

    public void mergeWithDefinition(BaseDefinedObject object, boolean removeUnknown) {
        EntityDefinition ed = this.entityDefRepo.findByNameAndVersion(object.getDefinitionName(), object.getDefinitionVersion());
        PropertyDefinitionHelper.mergeWithDefinition((BaseDefinedObject)object, (BaseDefinition)ed, (boolean)removeUnknown);
    }
}

