/*
 * Decompiled with CFR 0.152.
 */
package de.uniba.minf.registry.view.helper;

import de.uniba.minf.registry.model.BaseDefinedObject;
import de.uniba.minf.registry.model.Property;
import de.uniba.minf.registry.model.PropertyList;
import de.uniba.minf.registry.model.PropertyValue;
import de.uniba.minf.registry.model.TextPropertyValue;
import de.uniba.minf.registry.model.definition.BaseDefinition;
import de.uniba.minf.registry.model.definition.EntityDefinition;
import de.uniba.minf.registry.model.definition.PropertyDefinition;
import de.uniba.minf.registry.model.definition.VocabularyPropertyDefinition;
import de.uniba.minf.registry.model.entity.AutoqueryEntityLookupService;
import de.uniba.minf.registry.model.entity.Entity;
import de.uniba.minf.registry.model.helper.PropertyDefinitionHelper;
import de.uniba.minf.registry.model.vocabulary.VocabularyEntry;
import de.uniba.minf.registry.model.vocabulary.VocabularyLookupException;
import de.uniba.minf.registry.model.vocabulary.VocabularyLookupService;
import de.uniba.minf.registry.repository.EntityDefinitionRepository;
import de.uniba.minf.registry.service.EntityService;
import de.uniba.minf.registry.view.helper.ResolveCacheKey;
import de.uniba.minf.registry.view.helper.ResolvedVocabularyEntry;
import java.io.Serializable;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class EntityVocabularyHelper {
    private static final Logger log = LoggerFactory.getLogger(EntityVocabularyHelper.class);
    @Autowired
    private VocabularyLookupService vocabularyLookupService;
    @Autowired
    private AutoqueryEntityLookupService entityLookupService;
    @Autowired
    private EntityDefinitionRepository entityDefRepo;
    @Autowired
    private EntityService entityService;
    @Value(value="#{${debug}==true || ${debugging.resolution}==true}")
    private boolean debug;
    private Map<ResolveCacheKey, List<VocabularyEntry>> resolveCache = null;
    private Instant cacheCreation = null;

    public List<ResolvedVocabularyEntry> resolveVocabularyEntries(Entity e) {
        if (this.resolveCache == null || ChronoUnit.HOURS.between(this.cacheCreation, Instant.now()) > 24L) {
            this.resolveCache = new HashMap();
            this.cacheCreation = Instant.now();
        }
        if (this.debug) {
            StringBuilder strBldr = new StringBuilder();
            this.resolveCache.entrySet().stream().forEach(en -> {
                strBldr.append(((ResolveCacheKey)en.getKey()).getVocabulary());
                strBldr.append(" | ");
                strBldr.append(((ResolveCacheKey)en.getKey()).getQuery());
                strBldr.append(" => ");
                strBldr.append(((List)en.getValue()).size());
                strBldr.append(" candidate(s)\n");
            });
            log.debug("Current cache status\n" + strBldr.toString());
        }
        ArrayList<ResolvedVocabularyEntry> resolved = new ArrayList<ResolvedVocabularyEntry>();
        if (e.getProperties() == null) {
            return resolved;
        }
        if (e.getPropertyDefinitions() == null) {
            EntityDefinition ed = this.entityDefRepo.findCurrentByName(e.getDefinitionName());
            PropertyDefinitionHelper.mergeWithDefinition((BaseDefinedObject)e, (BaseDefinition)ed, (boolean)false);
        }
        this.resolveVocabularyEntries(e.getProperties(), e.getPropertyDefinitions(), resolved, null);
        return resolved;
    }

    private void resolveVocabularyEntries(List<Property> properties, List<PropertyDefinition> propertyDefinitions, List<ResolvedVocabularyEntry> resolved, String path) {
        for (PropertyDefinition pd : propertyDefinitions) {
            String subPath;
            if (pd.isSimple()) continue;
            List<Property> subProperties = properties.stream().filter(p -> p.getLabel().equals(pd.getName())).toList();
            String string = subPath = path == null ? pd.getName() : path + "." + pd.getName();
            if (pd.isVocabulary()) {
                this.resolveVocabularyEntries(subProperties, (VocabularyPropertyDefinition)VocabularyPropertyDefinition.class.cast(pd), resolved, path);
                continue;
            }
            if (!pd.isHierarchical()) continue;
            for (Property p2 : subProperties) {
                if (p2.getProperties() == null) continue;
                for (int i = 0; i < p2.getProperties().size(); ++i) {
                    this.resolveVocabularyEntries(((PropertyList)p2.getProperties().get(i)).getProperties(), ((PropertyList)p2.getProperties().get(i)).getPropertyDefinitions(), resolved, subPath + "[" + i + "]");
                }
            }
        }
    }

    private void resolveVocabularyEntries(List<Property> properties, VocabularyPropertyDefinition definition, List<ResolvedVocabularyEntry> resolved, String path) {
        path = path == null ? definition.getName() : "." + definition.getName();
        for (Property p : properties) {
            List values = p.valuesAsList();
            Object subpath = path;
            for (int i = 0; i < values.size(); ++i) {
                PropertyValue v = (PropertyValue)values.get(i);
                String query = v.asText();
                if (values.size() > 1) {
                    subpath = (String)path + "[" + i + "]";
                }
                if (TextPropertyValue.class.isAssignableFrom(v.getClass()) && ((TextPropertyValue)TextPropertyValue.class.cast(v)).isPreventResolution()) {
                    log.debug("Resolution prevention configured for value '{}'", (Object)query);
                    resolved.add(new ResolvedVocabularyEntry(definition.getVocabulary(), query, null, 0, (String)subpath, true));
                    continue;
                }
                try {
                    boolean fromCache = false;
                    List veCandidates = (ArrayList<VocabularyEntry>)this.resolveCache.get(ResolveCacheKey.get((String)definition.getVocabulary(), (String)query));
                    if (veCandidates != null) {
                        log.debug("From cache '{}' in vocabulary '{}'", (Object)query, (Object)definition.getVocabulary());
                        fromCache = true;
                    } else {
                        VocabularyEntry ve = null;
                        if (definition.isEntity()) {
                            Optional entity = this.entityService.findLatestByEntityId(query);
                            if (entity.isPresent()) {
                                ve = new VocabularyEntry();
                                ve.setKey(query);
                                ve.setPrimaryValue(query);
                            } else {
                                ve = this.entityLookupService.resolve(definition.getVocabulary(), query);
                            }
                        } else {
                            ve = this.vocabularyLookupService.resolve(definition.getVocabulary(), query);
                        }
                        if (ve != null) {
                            veCandidates = new ArrayList<VocabularyEntry>();
                            veCandidates.add(ve);
                        } else {
                            veCandidates = definition.isEntity() ? this.entityLookupService.search(definition.getVocabulary(), query) : this.vocabularyLookupService.search(definition.getVocabulary(), query);
                        }
                    }
                    if (veCandidates == null || veCandidates.isEmpty()) {
                        log.debug("Resolving '{}' against vocabulary '{}': No match found", (Object)query, (Object)definition.getVocabulary());
                        resolved.add(new ResolvedVocabularyEntry(definition.getVocabulary(), query, null, 0, (String)subpath, false));
                    } else if (veCandidates.size() == 1) {
                        String resolvedKey = ((VocabularyEntry)veCandidates.get(0)).getKey();
                        log.debug("Resolving '{}' against vocabulary '{}': One match found => set", (Object)query, (Object)definition.getVocabulary());
                        resolved.add(new ResolvedVocabularyEntry(definition.getVocabulary(), query, resolvedKey, 1, (String)subpath, false));
                        ((TextPropertyValue)TextPropertyValue.class.cast(v)).setValue((Serializable)((Object)resolvedKey));
                    } else if (((VocabularyEntry)veCandidates.get(0)).getScore() > 0.0 && ((VocabularyEntry)veCandidates.get(1)).getScore() > 0.0 && ((VocabularyEntry)veCandidates.get(0)).getScore() > 50.0 && ((VocabularyEntry)veCandidates.get(0)).getScore() / 3.0 > ((VocabularyEntry)veCandidates.get(1)).getScore()) {
                        log.debug("Resolving '{}' against vocabulary '{}': {} matches found => most probable chosen", new Object[]{query, definition.getVocabulary(), veCandidates.size()});
                        resolved.add(new ResolvedVocabularyEntry(definition.getVocabulary(), query, ((VocabularyEntry)veCandidates.get(0)).getKey(), veCandidates.size(), (String)subpath, false));
                        ((TextPropertyValue)TextPropertyValue.class.cast(v)).setValue((Serializable)((Object)((VocabularyEntry)veCandidates.get(0)).getKey()));
                    } else {
                        log.debug("Resolving '{}' against vocabulary '{}': {} matches found => unhandled", new Object[]{query, definition.getVocabulary(), veCandidates.size()});
                        resolved.add(new ResolvedVocabularyEntry(definition.getVocabulary(), query, null, veCandidates.size(), (String)subpath, false));
                    }
                    if (!fromCache) {
                        this.resolveCache.put(ResolveCacheKey.get((String)definition.getVocabulary(), (String)query), veCandidates);
                    }
                    log.debug("{} candidates identified", (Object)(veCandidates == null ? 0 : veCandidates.size()));
                    continue;
                }
                catch (VocabularyLookupException e) {
                    log.error("Failed to resolve vocabulary entry", (Throwable)e);
                }
            }
        }
    }
}

