/*
 * Decompiled with CFR 0.152.
 */
package de.uniba.minf.registry.view.controller.base;

import de.uniba.minf.registry.config.WebConfig;
import de.uniba.minf.registry.model.IntegerPropertyValue;
import de.uniba.minf.registry.model.PersistedUser;
import de.uniba.minf.registry.model.Property;
import de.uniba.minf.registry.model.PropertyImpl;
import de.uniba.minf.registry.model.PropertyValue;
import de.uniba.minf.registry.model.PropertyValueList;
import de.uniba.minf.registry.model.TextPropertyValue;
import de.uniba.minf.registry.model.definition.EntityDefinition;
import de.uniba.minf.registry.model.definition.PropertyDefinition;
import de.uniba.minf.registry.model.definition.SimplePropertyDefinition;
import de.uniba.minf.registry.model.definition.VocabularyPropertyDefinition;
import de.uniba.minf.registry.model.entity.Entity;
import de.uniba.minf.registry.repository.UserRepository;
import de.uniba.minf.registry.service.EntityCompositingService;
import de.uniba.minf.registry.service.EntityService;
import de.uniba.minf.registry.view.controller.BaseViewController;
import de.uniba.minf.registry.view.helper.PropertyPreviewHelper;
import de.uniba.minf.registry.view.helper.PropertyViewItemCombiner;
import de.uniba.minf.registry.view.model.EntityViewItem;
import de.uniba.minf.registry.view.model.PropertyBlockViewItem;
import de.uniba.minf.registry.view.model.SimplePropertyViewItem;
import de.uniba.minf.registry.view.model.VocabularyPropertyViewItem;
import java.net.MalformedURLException;
import java.net.URL;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.TimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.ui.Model;

public class BaseEntityViewController
extends BaseViewController {
    private static final Logger log = LoggerFactory.getLogger(BaseEntityViewController.class);
    @Autowired
    protected EntityService entityService;
    @Autowired
    protected EntityCompositingService compositingService;
    @Autowired
    protected PropertyViewItemCombiner propertyViewItemCombiner;
    @Autowired
    protected WebConfig webConfig;
    @Autowired
    private UserRepository userRepository;

    public BaseEntityViewController(String mainNavId) {
        super(mainNavId);
    }

    protected String editEntity(Entity entity, EntityDefinition entityDefinition, Model model, Locale locale) {
        this.compositingService.composeLayers(entity);
        model.addAttribute("entity", (Object)entity);
        model.addAttribute("def", (Object)entityDefinition);
        List propViewItems = this.propertyViewItemCombiner.getFromDefinitionBlocksAndEntity(entityDefinition.getPropertyBlocks(), entity.getProperties());
        propViewItems.add(this.getMetadataBlock(entity, entityDefinition, locale));
        model.addAttribute("propBlockViewItems", (Object)propViewItems);
        if (entity.getLayers() != null) {
            LinkedHashMap<String, EntityViewItem> entityViewItems = new LinkedHashMap<String, EntityViewItem>();
            for (Entity eLayer : entity.getLayers().values()) {
                EntityViewItem vi = new EntityViewItem();
                vi.setEntityId(eLayer.getEntityId());
                vi.setUniqueId(eLayer.getUniqueId());
                vi.setSourceLabel(eLayer.getSourceLabel());
                vi.setPreviewProperties(PropertyPreviewHelper.get().extractSubproperties(entityDefinition.getPreviewProperties(), eLayer.getProperties()));
                entityViewItems.put(eLayer.getEntityId(), vi);
            }
            model.addAttribute("layerEntityViewItems", entityViewItems);
        }
        return "entities/edit";
    }

    private PropertyBlockViewItem getMetadataBlock(Entity entity, EntityDefinition entityDefinition, Locale locale) {
        DateTimeFormatter formatter = DateTimeFormatter.ofLocalizedDateTime(FormatStyle.LONG, FormatStyle.MEDIUM).withLocale(locale).withZone(TimeZone.getTimeZone("Europe/Berlin").toZoneId());
        PropertyBlockViewItem adminMetadataBlock = new PropertyBlockViewItem();
        adminMetadataBlock.setIdentifier("model.generic.metadata");
        adminMetadataBlock.setMessageCode("model.generic.metadata");
        ArrayList<Object> adminMetadataItems = new ArrayList<Object>();
        URL versionURL = null;
        URL entityURL = null;
        try {
            versionURL = new URL(this.baseUrl + "entity/" + entity.getUniqueId() + "/");
            entityURL = new URL(this.baseUrl + "entity/" + entity.getEntityId() + "/");
        }
        catch (MalformedURLException e) {
            log.error("Failed to build entity URLs", (Throwable)e);
        }
        adminMetadataItems.add(this.getMetadataItem("entity_id", (PropertyValue)new TextPropertyValue(entity.getEntityId(), null, entityURL.toString())));
        adminMetadataItems.add(this.getMetadataItem("unique_id", (PropertyValue)new TextPropertyValue(entity.getUniqueId(), null, versionURL.toString())));
        if (entity.getNextVersionUniqueId() != null) {
            adminMetadataItems.add(this.getMetadataItem("next_unique_id", (PropertyValue)new TextPropertyValue(entity.getNextVersionUniqueId(), null, entityURL.toString())));
        }
        if (entity.getCreationInstant() != null) {
            adminMetadataItems.add(this.getMetadataItem("timestamp", (PropertyValue)new TextPropertyValue(formatter.format(entity.getCreationInstant()))));
        }
        Optional user = Optional.empty();
        if (entity.getUserUniqueId() != null && (user = this.userRepository.findById((Object)entity.getUserUniqueId())).isPresent()) {
            adminMetadataItems.add(this.getMetadataItem("user", (PropertyValue)new TextPropertyValue(((PersistedUser)user.get()).getUsername())));
        }
        if (entity.getEntityId() != null) {
            int versions = (int)this.entityRepository.countVersionsByEntityId(entity.getEntityId());
            Entity initialEntity = (Entity)this.entityRepository.findEarliestByEntityId(entity.getEntityId()).get();
            adminMetadataItems.add(this.getMetadataItem("version_count", (PropertyValue)new IntegerPropertyValue(Integer.valueOf(versions))));
            if (initialEntity.getCreationInstant() != null) {
                adminMetadataItems.add(this.getMetadataItem("created_timestamp", (PropertyValue)new TextPropertyValue(formatter.format(initialEntity.getCreationInstant()))));
            }
            if (initialEntity.getUserUniqueId() != null) {
                if (entity.getUserUniqueId() == null || !initialEntity.getUserUniqueId().equals(entity.getUserUniqueId())) {
                    user = this.userRepository.findById((Object)initialEntity.getUserUniqueId());
                }
                if (user.isPresent()) {
                    adminMetadataItems.add(this.getMetadataItem("initial_user", (PropertyValue)new TextPropertyValue(((PersistedUser)user.get()).getUsername())));
                }
            }
        }
        if (entityDefinition.isCompositing()) {
            adminMetadataItems.add(this.getLayerHierarchyItem(entity.getDefinitionName(), Optional.of(entity)));
        }
        adminMetadataBlock.setPropertyViewItems(adminMetadataItems);
        return adminMetadataBlock;
    }

    protected VocabularyPropertyViewItem getLayerHierarchyItem(String definitionName, Optional<Entity> e) {
        String label = "_layers";
        String code = "model.generic.layers";
        VocabularyPropertyDefinition layerHierarchyPd = new VocabularyPropertyDefinition();
        layerHierarchyPd.setMessageCode(code);
        layerHierarchyPd.setName(label);
        layerHierarchyPd.setIdentifier(code + "." + definitionName);
        layerHierarchyPd.setStrict(true);
        layerHierarchyPd.setQuery(true);
        layerHierarchyPd.setEntity(true);
        ArrayList<String> multiplicity = new ArrayList<String>();
        multiplicity.add("true");
        layerHierarchyPd.setMultiplicity(multiplicity);
        layerHierarchyPd.setVocabulary(definitionName);
        PropertyImpl property = new PropertyImpl();
        property.setLabel(code);
        if (e.isPresent() && e.get().getLayersEntityIds() != null) {
            property.setValue((PropertyValue)new PropertyValueList(e.get().getLayersEntityIds().stream().map(TextPropertyValue::new).toList()));
        }
        VocabularyPropertyViewItem viewItem = new VocabularyPropertyViewItem((PropertyDefinition)layerHierarchyPd, (Property)property);
        viewItem.setEntityViewItems(this.propertyViewItemCombiner.getEntityViewItems(viewItem, this.getPrimaryEntityDefinitions()));
        return viewItem;
    }

    private SimplePropertyViewItem getMetadataItem(String label, PropertyValue value) {
        String code = "model.generic.metadata." + label;
        SimplePropertyDefinition adminMetadataItemDefinition = new SimplePropertyDefinition();
        adminMetadataItemDefinition.setMessageCode(code);
        adminMetadataItemDefinition.setName(label);
        adminMetadataItemDefinition.setIdentifier(code);
        adminMetadataItemDefinition.setType(SimplePropertyDefinition.SIMPLE_TYPES.TEXT);
        adminMetadataItemDefinition.setMandatory(true);
        PropertyImpl property = new PropertyImpl();
        property.setLabel(code);
        property.setValue(value);
        SimplePropertyViewItem adminMetadataItem = new SimplePropertyViewItem((PropertyDefinition)adminMetadataItemDefinition, (Property)property);
        adminMetadataItem.setReadonly(true);
        return adminMetadataItem;
    }
}

