/*
 * Decompiled with CFR 0.152.
 */
package de.uniba.minf.registry.view.controller;

import de.uniba.minf.core.rest.model.RestItemResponse;
import de.uniba.minf.core.rest.model.RestResponse;
import de.uniba.minf.registry.model.Note;
import de.uniba.minf.registry.repository.NoteRepository;
import de.uniba.minf.registry.view.controller.BaseViewController;
import de.unibamberg.minf.core.web.init.LocaleAwareInitializationService;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/notes"})
public class NotesViewController
extends BaseViewController {
    @Autowired
    private NoteRepository noteRepository;
    @Autowired
    private LocaleAwareInitializationService initService;

    public NotesViewController() {
        super("notes");
    }

    @GetMapping
    public String showEntities(Model model, Locale locale) {
        model.addAttribute("messageCode", (Object)"view.notes");
        model.addAttribute("notes", (Object)this.noteRepository.findAll());
        return "notes/list";
    }

    @GetMapping(value={"/forms/edit", "/forms/edit/{uniqueId}"})
    public String showEditInclude(@PathVariable(value="uniqueId", required=false) String uniqueId, Model model, Locale locale) {
        Optional<Note> note = Optional.empty();
        if (uniqueId != null) {
            note = this.noteRepository.findById((Object)uniqueId);
        }
        if (note.isEmpty()) {
            Note newNote = new Note();
            newNote.setEnabled(true);
            newNote.setLocalizedTexts(new LinkedHashMap());
            for (String lang : this.initService.getLocaleCodes()) {
                newNote.getLocalizedTexts().put(lang, "");
            }
            note = Optional.of(newNote);
        }
        model.addAttribute("note", note.get());
        return "notes/edit";
    }

    @PostMapping(value={"/note", "/note/{uniqueId}"})
    @ResponseBody
    public RestResponse saveNote(@PathVariable(value="uniqueId", required=false) String uniqueId, @RequestBody Note note, HttpServletRequest req, HttpServletResponse resp, Locale locale) {
        RestItemResponse response = new RestItemResponse();
        if (uniqueId == null) {
            this.noteRepository.save((Object)note);
            response.setAction(RestResponse.ApiActions.CREATED);
            response.setItem(this.objectMapper.valueToTree((Object)note));
        } else {
            Note updateNote = (Note)this.noteRepository.findById((Object)uniqueId).orElseGet(null);
            if (updateNote != null) {
                updateNote.setEnabled(note.isEnabled());
                updateNote.setName(note.getName());
                updateNote.setDisplayDate(note.getDisplayDate());
                updateNote.setExpirationDate(note.getExpirationDate());
                updateNote.setLocalizedTexts(note.getLocalizedTexts());
                this.noteRepository.save((Object)updateNote);
                response.setAction(RestResponse.ApiActions.UPDATED);
                response.setItem(this.objectMapper.valueToTree((Object)updateNote));
            }
        }
        response.setAction(RestResponse.ApiActions.UNCHANGED);
        return response;
    }

    @DeleteMapping(value={"/note/{uniqueId}"})
    @ResponseBody
    public RestResponse deleteNote(@PathVariable(value="uniqueId") String uniqueId, HttpServletRequest req, HttpServletResponse resp, Locale locale) {
        this.noteRepository.deleteById((Object)uniqueId);
        RestItemResponse response = new RestItemResponse();
        response.setAction(RestResponse.ApiActions.DELETED);
        return response;
    }
}

