/*
 * Decompiled with CFR 0.152.
 */
package de.uniba.minf.registry.view.controller;

import de.uniba.minf.registry.pojo.converter.ImportConverter;
import de.uniba.minf.registry.repository.EntityRepository;
import de.uniba.minf.registry.repository.ImportRepository;
import de.uniba.minf.registry.view.controller.BaseViewController;
import de.unibamberg.minf.core.web.controller.ResourceNotFoundException;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@RequestMapping(value={"/imports"})
public class ImportViewController
extends BaseViewController {
    @Autowired
    private ImportRepository importRepo;
    @Autowired
    private ImportConverter importConverter;
    @Autowired
    private EntityRepository entityRepo;

    public ImportViewController() {
        super("imports");
    }

    @GetMapping
    public String listImports(HttpServletResponse response) throws IOException {
        return "imports/list";
    }

    @GetMapping(value={"/{importId}/entities/"})
    public String showEntitiesForImport(@PathVariable(value="importId") String importId, Model model, Locale locale) {
        Optional i = this.importConverter.convertPojo(this.importRepo.findById((Object)importId));
        if (i.isEmpty()) {
            throw new ResourceNotFoundException();
        }
        model.addAttribute("import", i.get());
        return "imports/list_entities";
    }

    @GetMapping(value={"/import"})
    public String importDialog(Model model, HttpServletResponse response) throws IOException {
        model.addAttribute("templates", (Object)this.entityRepo.findLatestByCriteria(Criteria.where((String)"template").is((Object)true)));
        ArrayList entityDefinitions = new ArrayList();
        entityDefinitions.addAll(this.getPrimaryEntityDefinitions());
        entityDefinitions.addAll(this.getSecondaryEntityDefinitions());
        model.addAttribute("entityDefinitions", entityDefinitions);
        return "imports/import";
    }
}

