/*
 * Decompiled with CFR 0.152.
 */
package de.uniba.minf.registry.view.controller;

import de.uniba.minf.registry.model.CompositePropertyImpl;
import de.uniba.minf.registry.model.Property;
import de.uniba.minf.registry.model.PropertyImpl;
import de.uniba.minf.registry.model.PropertyList;
import de.uniba.minf.registry.model.definition.EntityDefinition;
import de.uniba.minf.registry.model.definition.PropertyDefinition;
import de.uniba.minf.registry.model.entity.Entity;
import de.uniba.minf.registry.view.controller.base.BaseEntityViewController;
import de.uniba.minf.registry.view.model.VocabularyPropertyViewItem;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import java.util.Optional;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.server.ResponseStatusException;

@Controller
@RequestMapping(value={"/entity"})
public class EntityViewController
extends BaseEntityViewController {
    public EntityViewController() {
        super("entity");
    }

    @GetMapping(value={"/new/{entityDefinitionName}/", "/new/{entityDefinitionName}/l/{layerEntityId}"})
    public String newEntity(@PathVariable(value="entityDefinitionName") String entityDefinitionName, @PathVariable(name="layerEntityId", required=false) String layerEntityId, Model model, Locale locale) {
        EntityDefinition entityDefinition = this.entityDefinitionService.findCurrentByName(entityDefinitionName, false);
        if (!entityDefinition.isLocalCreation()) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Entity definition defined as localCreation: false -> no local entries");
        }
        Entity e = new Entity();
        e.setDefinitionName(entityDefinition.getName());
        e.setDefinitionVersion(entityDefinition.getVersion());
        if (layerEntityId != null) {
            e.setLayersEntityIds(new ArrayList());
            e.getLayersEntityIds().add(layerEntityId);
            this.entityService.loadLayers(e);
        }
        return this.editEntity(e, entityDefinition, model, locale);
    }

    @GetMapping(value={"{uniqueId}/"})
    public String showEntity(@PathVariable(value="uniqueId") String uniqueId, Model model, Locale locale, HttpServletResponse response) throws IOException, URISyntaxException {
        Optional entity = this.entityService.findById(uniqueId, true);
        if (!entity.isPresent()) {
            entity = this.entityService.findLatestByEntityId(uniqueId, true);
        }
        if (!entity.isPresent()) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, "~entity not found");
        }
        EntityDefinition entityDefinition = this.entityDefinitionService.findCurrentByName(((Entity)entity.get()).getDefinitionName(), false);
        if (entityDefinition.getName().equals("_source")) {
            response.sendRedirect(this.webConfig.getBaseUrlObj().getAbsoluteUrl("_source/%s/", new String[]{uniqueId}));
            return null;
        }
        return this.editEntity((Entity)entity.get(), entityDefinition, model, locale);
    }

    @GetMapping(value={"/{uniqueId}/includes/{propertyIdentifier}"})
    public String showEntityInclude(@PathVariable(value="uniqueId") String uniqueId, @PathVariable(value="propertyIdentifier") String propertyIdentifier, @RequestParam(value="path") String path, @RequestParam(name="entity", required=false) String entityId, @RequestParam(name="edit", defaultValue="false") boolean editable, Model model, Locale locale) {
        VocabularyPropertyViewItem propViewItem = null;
        String[] propertyPath = propertyIdentifier.split("\\.");
        if (propertyIdentifier.startsWith("model.generic.layers")) {
            propViewItem = this.getLayerHierarchyItem(propertyPath[3], Optional.empty());
        } else {
            EntityDefinition entityDefinition = this.entityDefinitionService.findCurrentByName(propertyPath[0], false);
            PropertyDefinition propertyDefinition = entityDefinition.getDefinition(Arrays.copyOfRange(propertyPath, 1, propertyPath.length));
            if (entityId == null && editable) {
                entityId = uniqueId;
            }
            if (entityId != null) {
                model.addAttribute("layerSelectionMode", (Object)true);
                Optional entity = this.entityService.findLatestByEntityId(uniqueId, true);
                if (entity.isPresent()) {
                    this.compositingService.composeLayers((Entity)entity.get());
                    Property p = ((Entity)entity.get()).get(propertyDefinition).stream().findFirst().orElse(null);
                    if (editable) {
                        CompositePropertyImpl pEdit = new CompositePropertyImpl();
                        if (CompositePropertyImpl.class.isAssignableFrom(p.getClass())) {
                            pEdit.setLayeredPropertyMap(((CompositePropertyImpl)CompositePropertyImpl.class.cast(p)).getLayeredPropertyMap());
                        }
                        pEdit.setDefinition(propertyDefinition);
                        pEdit.setLabel(p.getLabel());
                        pEdit.setValue(p.getValue());
                        pEdit.setProperties(p.getProperties());
                        p = pEdit;
                    } else if (!entityId.equals(((Entity)entity.get()).getEntityId()) && !entityId.equals(((Entity)entity.get()).getUniqueId())) {
                        CompositePropertyImpl pComp = this.compositingService.createLayersOnlyProperty(propertyDefinition);
                        if (CompositePropertyImpl.class.isAssignableFrom(p.getClass())) {
                            pComp.setLayeredPropertyMap(((CompositePropertyImpl)CompositePropertyImpl.class.cast(p)).getLayeredPropertyMap());
                        }
                        pComp.setValue(((Property)pComp.getLayeredPropertyMap().get(entityId)).getValue());
                        pComp.setProperties(p.getProperties());
                        pComp.setLayersOnly(!editable);
                        p = pComp;
                    }
                    propViewItem = this.propertyViewItemCombiner.getFromDefinitionAndEntity(propertyDefinition, p);
                }
            } else {
                model.addAttribute("layerSelectionMode", (Object)false);
            }
            if (propViewItem == null) {
                PropertyList pl = new PropertyList();
                PropertyImpl p = new PropertyImpl();
                p.setProperties(new ArrayList());
                p.getProperties().add(pl);
                propViewItem = this.propertyViewItemCombiner.getFromDefinitionAndEntity(propertyDefinition, (Property)p);
            }
        }
        model.addAttribute("propViewItem", (Object)propViewItem);
        model.addAttribute("path", (Object)path);
        model.addAttribute("entity", (Object)new Entity());
        return "entities/async_property";
    }
}

