/*
 * Decompiled with CFR 0.152.
 */
package de.uniba.minf.registry.view.controller;

import de.uniba.minf.registry.model.definition.EntityDefinition;
import de.uniba.minf.registry.view.controller.BaseViewController;
import de.unibamberg.minf.core.web.exception.NotFoundException;
import java.util.Locale;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@RequestMapping(value={"/entities"})
public class EntitiesViewController
extends BaseViewController {
    public EntitiesViewController() {
        super("entities");
    }

    @GetMapping(value={"/{entityType}/"})
    public String showEntities(@PathVariable(value="entityType") String entityType, Model model, Locale locale) {
        EntityDefinition entityDefinition = this.entityDefinitionRepository.findCurrentByName(entityType);
        if (entityDefinition == null) {
            throw new NotFoundException();
        }
        model.addAttribute("entityDefinition", (Object)entityDefinition);
        model.addAttribute("definitionName", (Object)entityDefinition.getName());
        model.addAttribute("creationAllowed", (Object)entityDefinition.isLocalCreation());
        model.addAttribute("compositionAllowed", (Object)entityDefinition.isCompositing());
        model.addAttribute("apiUrlPrefix", (Object)("e/" + entityDefinition.getName()));
        model.addAttribute("previewProperties", (Object)entityDefinition.getOrderedProperties());
        return "entities/list";
    }
}

